/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.hibernatesearch.domain;

import br.com.elotech.tributos.hibernatesearch.facet.FacetField;
import java.util.List;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.jpa.FullTextQuery;
import org.hibernate.search.jpa.Search;
import org.hibernate.search.query.dsl.FuzzyContext;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.springframework.data.domain.Pageable;

public class HibernateSearchParams {
    private static final String ANALYZER_QUERY = "dividePalavrasNoEspacoEmBranco_query";
    private final FullTextEntityManager fullTextEntityManager;
    private final Class<?> entityType;
    private final Pageable pageable;
    private final String searchValue;
    private final List<String> searchFields;
    private final List<FacetField> facets;
    private final QueryBuilder queryBuilder;

    public HibernateSearchParams(EntityManager entityManager, Class<?> entityType, Pageable pageable, String searchValue, List<String> searchFields, List<FacetField> facets) {
        this.fullTextEntityManager = Search.getFullTextEntityManager((EntityManager)entityManager);
        this.entityType = entityType;
        this.pageable = pageable;
        this.searchValue = searchValue;
        this.searchFields = searchFields;
        this.facets = facets;
        this.queryBuilder = this.createQueryBuilder();
    }

    private QueryBuilder createQueryBuilder() {
        return this.fullTextEntityManager.getSearchFactory().buildQueryBuilder().forEntity(this.entityType).overridesForField("pessoa.nome", ANALYZER_QUERY).overridesForField("pessoa.nomeFantasia", ANALYZER_QUERY).overridesForField("proprietarios.pessoa.nome", ANALYZER_QUERY).overridesForField("proprietarios.pessoa.nomeFantasia", ANALYZER_QUERY).overridesForField("contratosSocial.pessoas.pessoa.nome", ANALYZER_QUERY).overridesForField("contratosSocial.pessoas.pessoa.nomeFantasia", ANALYZER_QUERY).overridesForField("nomePropriedade", ANALYZER_QUERY).get();
    }

    public Query createQueryFromSearchFields() {
        return this.queryBuilder.simpleQueryString().onFields((String)this.searchFields.get(0), this.searchFields.subList(1, this.searchFields.size()).toArray(new String[0])).withAndAsDefaultOperator().matching(this.searchValue).createQuery();
    }

    public Query createQueryWithSpecificField(String field, String fieldValue) {
        return this.queryBuilder.keyword().onFields(new String[]{field}).matching((Object)fieldValue).createQuery();
    }

    public FullTextQuery createFullTextQuery(Query query) {
        return this.fullTextEntityManager.createFullTextQuery(query, new Class[]{this.entityType}).setFirstResult(this.pageable.getPageNumber() * this.pageable.getPageSize()).setMaxResults(this.pageable.getPageSize()).setSort(this.convertSort(this.pageable.getSort()));
    }

    private Sort convertSort(org.springframework.data.domain.Sort sort) {
        Sort newSort = new Sort();
        sort.forEach(e -> {
            Boolean reverse = !e.getDirection().isAscending();
            if (e.getProperty().equals("cadastroGeral_sort")) {
                SortField sortField = new SortField(e.getProperty(), SortField.Type.LONG, reverse.booleanValue());
                newSort.setSort(sortField);
            } else {
                SortField sortField = new SortField(e.getProperty(), SortField.Type.STRING, reverse.booleanValue());
                newSort.setSort(sortField);
            }
        });
        return newSort;
    }

    public Query createFuzzyQuery() {
        return ((FuzzyContext)this.queryBuilder.keyword().fuzzy().withEditDistanceUpTo(2).boostedTo(1.0f)).withPrefixLength(0).onFields(this.searchFields.toArray(new String[0])).matching((Object)this.searchValue).createQuery();
    }

    @Generated
    public FullTextEntityManager getFullTextEntityManager() {
        return this.fullTextEntityManager;
    }

    @Generated
    public Class<?> getEntityType() {
        return this.entityType;
    }

    @Generated
    public Pageable getPageable() {
        return this.pageable;
    }

    @Generated
    public String getSearchValue() {
        return this.searchValue;
    }

    @Generated
    public List<String> getSearchFields() {
        return this.searchFields;
    }

    @Generated
    public List<FacetField> getFacets() {
        return this.facets;
    }

    @Generated
    public QueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HibernateSearchParams)) {
            return false;
        }
        HibernateSearchParams other = (HibernateSearchParams)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        FullTextEntityManager this$fullTextEntityManager = this.getFullTextEntityManager();
        FullTextEntityManager other$fullTextEntityManager = other.getFullTextEntityManager();
        if (this$fullTextEntityManager == null ? other$fullTextEntityManager != null : !this$fullTextEntityManager.equals(other$fullTextEntityManager)) {
            return false;
        }
        Class this$entityType = this.getEntityType();
        Class other$entityType = other.getEntityType();
        if (this$entityType == null ? other$entityType != null : !this$entityType.equals(other$entityType)) {
            return false;
        }
        Pageable this$pageable = this.getPageable();
        Pageable other$pageable = other.getPageable();
        if (this$pageable == null ? other$pageable != null : !this$pageable.equals(other$pageable)) {
            return false;
        }
        String this$searchValue = this.getSearchValue();
        String other$searchValue = other.getSearchValue();
        if (this$searchValue == null ? other$searchValue != null : !this$searchValue.equals(other$searchValue)) {
            return false;
        }
        List this$searchFields = this.getSearchFields();
        List other$searchFields = other.getSearchFields();
        if (this$searchFields == null ? other$searchFields != null : !((Object)this$searchFields).equals(other$searchFields)) {
            return false;
        }
        List this$facets = this.getFacets();
        List other$facets = other.getFacets();
        if (this$facets == null ? other$facets != null : !((Object)this$facets).equals(other$facets)) {
            return false;
        }
        QueryBuilder this$queryBuilder = this.getQueryBuilder();
        QueryBuilder other$queryBuilder = other.getQueryBuilder();
        return !(this$queryBuilder == null ? other$queryBuilder != null : !this$queryBuilder.equals(other$queryBuilder));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HibernateSearchParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FullTextEntityManager $fullTextEntityManager = this.getFullTextEntityManager();
        result = result * 59 + ($fullTextEntityManager == null ? 43 : $fullTextEntityManager.hashCode());
        Class $entityType = this.getEntityType();
        result = result * 59 + ($entityType == null ? 43 : $entityType.hashCode());
        Pageable $pageable = this.getPageable();
        result = result * 59 + ($pageable == null ? 43 : $pageable.hashCode());
        String $searchValue = this.getSearchValue();
        result = result * 59 + ($searchValue == null ? 43 : $searchValue.hashCode());
        List $searchFields = this.getSearchFields();
        result = result * 59 + ($searchFields == null ? 43 : ((Object)$searchFields).hashCode());
        List $facets = this.getFacets();
        result = result * 59 + ($facets == null ? 43 : ((Object)$facets).hashCode());
        QueryBuilder $queryBuilder = this.getQueryBuilder();
        result = result * 59 + ($queryBuilder == null ? 43 : $queryBuilder.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HibernateSearchParams(fullTextEntityManager=" + this.getFullTextEntityManager() + ", entityType=" + this.getEntityType() + ", pageable=" + this.getPageable() + ", searchValue=" + this.getSearchValue() + ", searchFields=" + this.getSearchFields() + ", facets=" + this.getFacets() + ", queryBuilder=" + this.getQueryBuilder() + ")";
    }
}

