/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.DocumentoTexto;
import br.com.elotech.tributos.domain.DocumentoTipo;
import br.com.elotech.tributos.domain.DocumentoTipoOutros;
import br.com.elotech.tributos.domain.GrupoDocumento;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoValidadeDocumento;
import br.com.elotech.tributos.domain.relatorio.Relatorio;
import br.com.elotech.tributos.dto.DocumentoFinalidadeDTO;
import br.com.elotech.tributos.dto.DocumentoTipoAssinaturaDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.Valid;
import lombok.Generated;

public class DocumentoTipoDTO {
    private Long id;
    private String descricao;
    private Boolean impressaoWeb;
    private Boolean porCadastroGeral;
    private Boolean ativo;
    private Boolean exigeProcesso;
    private Boolean possuiCabecalho;
    private Boolean possuiRodape;
    private Boolean possuiObservacao;
    private Boolean possuiHistorico;
    private Boolean armazenarComoPdf;
    private Boolean maisDeUmLayout;
    private Boolean verificaDebitoPendente;
    private Boolean verificaAssinaturaDigital;
    private Boolean exigeProjeto;
    private Long assunto;
    private Boolean geraDocumentoCentral;
    private Long validadeDia;
    private LocalDate validadeData;
    private String validade;
    private Relatorio relatorio;
    private List<TipoCadastro> tiposCadastro = new ArrayList();
    @Valid
    private List<DocumentoTipoAssinaturaDTO> assinaturas = new ArrayList();
    @JsonIgnore
    private List<DocumentoTexto> textos = new ArrayList();
    private List<DocumentoTipoOutros> outros = new ArrayList();
    private List<Relatorio> relatorios = new ArrayList();
    private List<DocumentoFinalidadeDTO> finalidades = new ArrayList();
    @JsonIgnore
    private List<GrupoDocumento> gruposDocumento = new ArrayList();

    public static DocumentoTipoDTO of(DocumentoTipo entity) {
        DocumentoTipoDTO dto = new DocumentoTipoDTO();
        if (Objects.nonNull(entity)) {
            dto.setId(entity.getId());
            dto.setDescricao(entity.getDescricao());
            dto.setAtivo(Boolean.valueOf(entity.getInativo() == false));
            dto.setExigeProcesso(entity.getExigeProcesso());
            dto.setImpressaoWeb(entity.getImpressaoWeb());
            dto.setPorCadastroGeral(entity.getPorCadastroGeral());
            dto.setPossuiCabecalho(entity.getPossuiCabecalho());
            dto.setPossuiRodape(entity.getPossuiRodape());
            dto.setPossuiObservacao(entity.getPossuiObservacao());
            dto.setPossuiHistorico(entity.getPossuiHistorico());
            dto.setArmazenarComoPdf(entity.getArmazenarComoPdf());
            dto.setMaisDeUmLayout(entity.getMaisDeUmLayout());
            dto.setVerificaDebitoPendente(entity.getVerificaDebitoPendente());
            dto.setVerificaAssinaturaDigital(entity.getVerificaAssinaturaDigital());
            dto.setExigeProjeto(entity.getExigeProjeto());
            dto.setAssunto(entity.getAssunto());
            dto.setGeraDocumentoCentral(entity.getGeraDocumentoCentral());
            dto.setValidadeDia((Long)Optional.ofNullable(entity.getValidadeDia()).map(Integer::longValue).orElse(null));
            dto.setValidadeData(entity.getValidadeData());
            dto.setValidade((String)Optional.ofNullable(entity.getValidade()).map(TipoValidadeDocumento::getValue).orElse(null));
            dto.setRelatorio(entity.getRelatorio());
            Optional.ofNullable(entity.getRelatorios()).ifPresent(arg_0 -> dto.setRelatorios(arg_0));
            if (Objects.nonNull(entity.getFinalidades())) {
                dto.setFinalidades(entity.getFinalidades().stream().map(DocumentoFinalidadeDTO::from).sorted(Comparator.comparing(DocumentoFinalidadeDTO::getExercicio).thenComparing(finalidadeDTO -> Objects.nonNull(finalidadeDTO.getDescricao()) ? finalidadeDTO.getDescricao() : "")).collect(Collectors.toList()));
            }
            if (Objects.nonNull(entity.getAssinaturas())) {
                dto.setAssinaturas(entity.getAssinaturas().stream().map(DocumentoTipoAssinaturaDTO::from).sorted(Comparator.comparing(DocumentoTipoAssinaturaDTO::getPeriodoFinal, Comparator.nullsLast(Comparator.naturalOrder())).reversed()).collect(Collectors.toList()));
            }
            Optional.ofNullable(entity.getTiposCadastro()).ifPresent(arg_0 -> dto.setTiposCadastro(arg_0));
            Optional.ofNullable(entity.getTextos()).ifPresent(arg_0 -> dto.setTextos(arg_0));
            Optional.ofNullable(entity.getOutros()).ifPresent(arg_0 -> dto.setOutros(arg_0));
            Optional.ofNullable(entity.getGruposDocumento()).ifPresent(arg_0 -> dto.setGruposDocumento(arg_0));
        }
        return dto;
    }

    @Generated
    public DocumentoTipoDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Boolean getImpressaoWeb() {
        return this.impressaoWeb;
    }

    @Generated
    public Boolean getPorCadastroGeral() {
        return this.porCadastroGeral;
    }

    @Generated
    public Boolean getAtivo() {
        return this.ativo;
    }

    @Generated
    public Boolean getExigeProcesso() {
        return this.exigeProcesso;
    }

    @Generated
    public Boolean getPossuiCabecalho() {
        return this.possuiCabecalho;
    }

    @Generated
    public Boolean getPossuiRodape() {
        return this.possuiRodape;
    }

    @Generated
    public Boolean getPossuiObservacao() {
        return this.possuiObservacao;
    }

    @Generated
    public Boolean getPossuiHistorico() {
        return this.possuiHistorico;
    }

    @Generated
    public Boolean getArmazenarComoPdf() {
        return this.armazenarComoPdf;
    }

    @Generated
    public Boolean getMaisDeUmLayout() {
        return this.maisDeUmLayout;
    }

    @Generated
    public Boolean getVerificaDebitoPendente() {
        return this.verificaDebitoPendente;
    }

    @Generated
    public Boolean getVerificaAssinaturaDigital() {
        return this.verificaAssinaturaDigital;
    }

    @Generated
    public Boolean getExigeProjeto() {
        return this.exigeProjeto;
    }

    @Generated
    public Long getAssunto() {
        return this.assunto;
    }

    @Generated
    public Boolean getGeraDocumentoCentral() {
        return this.geraDocumentoCentral;
    }

    @Generated
    public Long getValidadeDia() {
        return this.validadeDia;
    }

    @Generated
    public LocalDate getValidadeData() {
        return this.validadeData;
    }

    @Generated
    public String getValidade() {
        return this.validade;
    }

    @Generated
    public Relatorio getRelatorio() {
        return this.relatorio;
    }

    @Generated
    public List<TipoCadastro> getTiposCadastro() {
        return this.tiposCadastro;
    }

    @Generated
    public List<DocumentoTipoAssinaturaDTO> getAssinaturas() {
        return this.assinaturas;
    }

    @Generated
    public List<DocumentoTexto> getTextos() {
        return this.textos;
    }

    @Generated
    public List<DocumentoTipoOutros> getOutros() {
        return this.outros;
    }

    @Generated
    public List<Relatorio> getRelatorios() {
        return this.relatorios;
    }

    @Generated
    public List<DocumentoFinalidadeDTO> getFinalidades() {
        return this.finalidades;
    }

    @Generated
    public List<GrupoDocumento> getGruposDocumento() {
        return this.gruposDocumento;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setImpressaoWeb(Boolean impressaoWeb) {
        this.impressaoWeb = impressaoWeb;
    }

    @Generated
    public void setPorCadastroGeral(Boolean porCadastroGeral) {
        this.porCadastroGeral = porCadastroGeral;
    }

    @Generated
    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    @Generated
    public void setExigeProcesso(Boolean exigeProcesso) {
        this.exigeProcesso = exigeProcesso;
    }

    @Generated
    public void setPossuiCabecalho(Boolean possuiCabecalho) {
        this.possuiCabecalho = possuiCabecalho;
    }

    @Generated
    public void setPossuiRodape(Boolean possuiRodape) {
        this.possuiRodape = possuiRodape;
    }

    @Generated
    public void setPossuiObservacao(Boolean possuiObservacao) {
        this.possuiObservacao = possuiObservacao;
    }

    @Generated
    public void setPossuiHistorico(Boolean possuiHistorico) {
        this.possuiHistorico = possuiHistorico;
    }

    @Generated
    public void setArmazenarComoPdf(Boolean armazenarComoPdf) {
        this.armazenarComoPdf = armazenarComoPdf;
    }

    @Generated
    public void setMaisDeUmLayout(Boolean maisDeUmLayout) {
        this.maisDeUmLayout = maisDeUmLayout;
    }

    @Generated
    public void setVerificaDebitoPendente(Boolean verificaDebitoPendente) {
        this.verificaDebitoPendente = verificaDebitoPendente;
    }

    @Generated
    public void setVerificaAssinaturaDigital(Boolean verificaAssinaturaDigital) {
        this.verificaAssinaturaDigital = verificaAssinaturaDigital;
    }

    @Generated
    public void setExigeProjeto(Boolean exigeProjeto) {
        this.exigeProjeto = exigeProjeto;
    }

    @Generated
    public void setAssunto(Long assunto) {
        this.assunto = assunto;
    }

    @Generated
    public void setGeraDocumentoCentral(Boolean geraDocumentoCentral) {
        this.geraDocumentoCentral = geraDocumentoCentral;
    }

    @Generated
    public void setValidadeDia(Long validadeDia) {
        this.validadeDia = validadeDia;
    }

    @Generated
    public void setValidadeData(LocalDate validadeData) {
        this.validadeData = validadeData;
    }

    @Generated
    public void setValidade(String validade) {
        this.validade = validade;
    }

    @Generated
    public void setRelatorio(Relatorio relatorio) {
        this.relatorio = relatorio;
    }

    @Generated
    public void setTiposCadastro(List<TipoCadastro> tiposCadastro) {
        this.tiposCadastro = tiposCadastro;
    }

    @Generated
    public void setAssinaturas(List<DocumentoTipoAssinaturaDTO> assinaturas) {
        this.assinaturas = assinaturas;
    }

    @Generated
    public void setTextos(List<DocumentoTexto> textos) {
        this.textos = textos;
    }

    @Generated
    public void setOutros(List<DocumentoTipoOutros> outros) {
        this.outros = outros;
    }

    @Generated
    public void setRelatorios(List<Relatorio> relatorios) {
        this.relatorios = relatorios;
    }

    @Generated
    public void setFinalidades(List<DocumentoFinalidadeDTO> finalidades) {
        this.finalidades = finalidades;
    }

    @Generated
    public void setGruposDocumento(List<GrupoDocumento> gruposDocumento) {
        this.gruposDocumento = gruposDocumento;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocumentoTipoDTO)) {
            return false;
        }
        DocumentoTipoDTO other = (DocumentoTipoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$descricao = this.getDescricao();
        String other$descricao = other.getDescricao();
        if (this$descricao == null ? other$descricao != null : !this$descricao.equals(other$descricao)) {
            return false;
        }
        Boolean this$impressaoWeb = this.getImpressaoWeb();
        Boolean other$impressaoWeb = other.getImpressaoWeb();
        if (this$impressaoWeb == null ? other$impressaoWeb != null : !((Object)this$impressaoWeb).equals(other$impressaoWeb)) {
            return false;
        }
        Boolean this$porCadastroGeral = this.getPorCadastroGeral();
        Boolean other$porCadastroGeral = other.getPorCadastroGeral();
        if (this$porCadastroGeral == null ? other$porCadastroGeral != null : !((Object)this$porCadastroGeral).equals(other$porCadastroGeral)) {
            return false;
        }
        Boolean this$ativo = this.getAtivo();
        Boolean other$ativo = other.getAtivo();
        if (this$ativo == null ? other$ativo != null : !((Object)this$ativo).equals(other$ativo)) {
            return false;
        }
        Boolean this$exigeProcesso = this.getExigeProcesso();
        Boolean other$exigeProcesso = other.getExigeProcesso();
        if (this$exigeProcesso == null ? other$exigeProcesso != null : !((Object)this$exigeProcesso).equals(other$exigeProcesso)) {
            return false;
        }
        Boolean this$possuiCabecalho = this.getPossuiCabecalho();
        Boolean other$possuiCabecalho = other.getPossuiCabecalho();
        if (this$possuiCabecalho == null ? other$possuiCabecalho != null : !((Object)this$possuiCabecalho).equals(other$possuiCabecalho)) {
            return false;
        }
        Boolean this$possuiRodape = this.getPossuiRodape();
        Boolean other$possuiRodape = other.getPossuiRodape();
        if (this$possuiRodape == null ? other$possuiRodape != null : !((Object)this$possuiRodape).equals(other$possuiRodape)) {
            return false;
        }
        Boolean this$possuiObservacao = this.getPossuiObservacao();
        Boolean other$possuiObservacao = other.getPossuiObservacao();
        if (this$possuiObservacao == null ? other$possuiObservacao != null : !((Object)this$possuiObservacao).equals(other$possuiObservacao)) {
            return false;
        }
        Boolean this$possuiHistorico = this.getPossuiHistorico();
        Boolean other$possuiHistorico = other.getPossuiHistorico();
        if (this$possuiHistorico == null ? other$possuiHistorico != null : !((Object)this$possuiHistorico).equals(other$possuiHistorico)) {
            return false;
        }
        Boolean this$armazenarComoPdf = this.getArmazenarComoPdf();
        Boolean other$armazenarComoPdf = other.getArmazenarComoPdf();
        if (this$armazenarComoPdf == null ? other$armazenarComoPdf != null : !((Object)this$armazenarComoPdf).equals(other$armazenarComoPdf)) {
            return false;
        }
        Boolean this$maisDeUmLayout = this.getMaisDeUmLayout();
        Boolean other$maisDeUmLayout = other.getMaisDeUmLayout();
        if (this$maisDeUmLayout == null ? other$maisDeUmLayout != null : !((Object)this$maisDeUmLayout).equals(other$maisDeUmLayout)) {
            return false;
        }
        Boolean this$verificaDebitoPendente = this.getVerificaDebitoPendente();
        Boolean other$verificaDebitoPendente = other.getVerificaDebitoPendente();
        if (this$verificaDebitoPendente == null ? other$verificaDebitoPendente != null : !((Object)this$verificaDebitoPendente).equals(other$verificaDebitoPendente)) {
            return false;
        }
        Boolean this$verificaAssinaturaDigital = this.getVerificaAssinaturaDigital();
        Boolean other$verificaAssinaturaDigital = other.getVerificaAssinaturaDigital();
        if (this$verificaAssinaturaDigital == null ? other$verificaAssinaturaDigital != null : !((Object)this$verificaAssinaturaDigital).equals(other$verificaAssinaturaDigital)) {
            return false;
        }
        Boolean this$exigeProjeto = this.getExigeProjeto();
        Boolean other$exigeProjeto = other.getExigeProjeto();
        if (this$exigeProjeto == null ? other$exigeProjeto != null : !((Object)this$exigeProjeto).equals(other$exigeProjeto)) {
            return false;
        }
        Long this$assunto = this.getAssunto();
        Long other$assunto = other.getAssunto();
        if (this$assunto == null ? other$assunto != null : !((Object)this$assunto).equals(other$assunto)) {
            return false;
        }
        Boolean this$geraDocumentoCentral = this.getGeraDocumentoCentral();
        Boolean other$geraDocumentoCentral = other.getGeraDocumentoCentral();
        if (this$geraDocumentoCentral == null ? other$geraDocumentoCentral != null : !((Object)this$geraDocumentoCentral).equals(other$geraDocumentoCentral)) {
            return false;
        }
        Long this$validadeDia = this.getValidadeDia();
        Long other$validadeDia = other.getValidadeDia();
        if (this$validadeDia == null ? other$validadeDia != null : !((Object)this$validadeDia).equals(other$validadeDia)) {
            return false;
        }
        LocalDate this$validadeData = this.getValidadeData();
        LocalDate other$validadeData = other.getValidadeData();
        if (this$validadeData == null ? other$validadeData != null : !((Object)this$validadeData).equals(other$validadeData)) {
            return false;
        }
        String this$validade = this.getValidade();
        String other$validade = other.getValidade();
        if (this$validade == null ? other$validade != null : !this$validade.equals(other$validade)) {
            return false;
        }
        Relatorio this$relatorio = this.getRelatorio();
        Relatorio other$relatorio = other.getRelatorio();
        if (this$relatorio == null ? other$relatorio != null : !this$relatorio.equals(other$relatorio)) {
            return false;
        }
        List this$tiposCadastro = this.getTiposCadastro();
        List other$tiposCadastro = other.getTiposCadastro();
        if (this$tiposCadastro == null ? other$tiposCadastro != null : !((Object)this$tiposCadastro).equals(other$tiposCadastro)) {
            return false;
        }
        List this$assinaturas = this.getAssinaturas();
        List other$assinaturas = other.getAssinaturas();
        if (this$assinaturas == null ? other$assinaturas != null : !((Object)this$assinaturas).equals(other$assinaturas)) {
            return false;
        }
        List this$textos = this.getTextos();
        List other$textos = other.getTextos();
        if (this$textos == null ? other$textos != null : !((Object)this$textos).equals(other$textos)) {
            return false;
        }
        List this$outros = this.getOutros();
        List other$outros = other.getOutros();
        if (this$outros == null ? other$outros != null : !((Object)this$outros).equals(other$outros)) {
            return false;
        }
        List this$relatorios = this.getRelatorios();
        List other$relatorios = other.getRelatorios();
        if (this$relatorios == null ? other$relatorios != null : !((Object)this$relatorios).equals(other$relatorios)) {
            return false;
        }
        List this$finalidades = this.getFinalidades();
        List other$finalidades = other.getFinalidades();
        if (this$finalidades == null ? other$finalidades != null : !((Object)this$finalidades).equals(other$finalidades)) {
            return false;
        }
        List this$gruposDocumento = this.getGruposDocumento();
        List other$gruposDocumento = other.getGruposDocumento();
        return !(this$gruposDocumento == null ? other$gruposDocumento != null : !((Object)this$gruposDocumento).equals(other$gruposDocumento));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DocumentoTipoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $descricao = this.getDescricao();
        result = result * 59 + ($descricao == null ? 43 : $descricao.hashCode());
        Boolean $impressaoWeb = this.getImpressaoWeb();
        result = result * 59 + ($impressaoWeb == null ? 43 : ((Object)$impressaoWeb).hashCode());
        Boolean $porCadastroGeral = this.getPorCadastroGeral();
        result = result * 59 + ($porCadastroGeral == null ? 43 : ((Object)$porCadastroGeral).hashCode());
        Boolean $ativo = this.getAtivo();
        result = result * 59 + ($ativo == null ? 43 : ((Object)$ativo).hashCode());
        Boolean $exigeProcesso = this.getExigeProcesso();
        result = result * 59 + ($exigeProcesso == null ? 43 : ((Object)$exigeProcesso).hashCode());
        Boolean $possuiCabecalho = this.getPossuiCabecalho();
        result = result * 59 + ($possuiCabecalho == null ? 43 : ((Object)$possuiCabecalho).hashCode());
        Boolean $possuiRodape = this.getPossuiRodape();
        result = result * 59 + ($possuiRodape == null ? 43 : ((Object)$possuiRodape).hashCode());
        Boolean $possuiObservacao = this.getPossuiObservacao();
        result = result * 59 + ($possuiObservacao == null ? 43 : ((Object)$possuiObservacao).hashCode());
        Boolean $possuiHistorico = this.getPossuiHistorico();
        result = result * 59 + ($possuiHistorico == null ? 43 : ((Object)$possuiHistorico).hashCode());
        Boolean $armazenarComoPdf = this.getArmazenarComoPdf();
        result = result * 59 + ($armazenarComoPdf == null ? 43 : ((Object)$armazenarComoPdf).hashCode());
        Boolean $maisDeUmLayout = this.getMaisDeUmLayout();
        result = result * 59 + ($maisDeUmLayout == null ? 43 : ((Object)$maisDeUmLayout).hashCode());
        Boolean $verificaDebitoPendente = this.getVerificaDebitoPendente();
        result = result * 59 + ($verificaDebitoPendente == null ? 43 : ((Object)$verificaDebitoPendente).hashCode());
        Boolean $verificaAssinaturaDigital = this.getVerificaAssinaturaDigital();
        result = result * 59 + ($verificaAssinaturaDigital == null ? 43 : ((Object)$verificaAssinaturaDigital).hashCode());
        Boolean $exigeProjeto = this.getExigeProjeto();
        result = result * 59 + ($exigeProjeto == null ? 43 : ((Object)$exigeProjeto).hashCode());
        Long $assunto = this.getAssunto();
        result = result * 59 + ($assunto == null ? 43 : ((Object)$assunto).hashCode());
        Boolean $geraDocumentoCentral = this.getGeraDocumentoCentral();
        result = result * 59 + ($geraDocumentoCentral == null ? 43 : ((Object)$geraDocumentoCentral).hashCode());
        Long $validadeDia = this.getValidadeDia();
        result = result * 59 + ($validadeDia == null ? 43 : ((Object)$validadeDia).hashCode());
        LocalDate $validadeData = this.getValidadeData();
        result = result * 59 + ($validadeData == null ? 43 : ((Object)$validadeData).hashCode());
        String $validade = this.getValidade();
        result = result * 59 + ($validade == null ? 43 : $validade.hashCode());
        Relatorio $relatorio = this.getRelatorio();
        result = result * 59 + ($relatorio == null ? 43 : $relatorio.hashCode());
        List $tiposCadastro = this.getTiposCadastro();
        result = result * 59 + ($tiposCadastro == null ? 43 : ((Object)$tiposCadastro).hashCode());
        List $assinaturas = this.getAssinaturas();
        result = result * 59 + ($assinaturas == null ? 43 : ((Object)$assinaturas).hashCode());
        List $textos = this.getTextos();
        result = result * 59 + ($textos == null ? 43 : ((Object)$textos).hashCode());
        List $outros = this.getOutros();
        result = result * 59 + ($outros == null ? 43 : ((Object)$outros).hashCode());
        List $relatorios = this.getRelatorios();
        result = result * 59 + ($relatorios == null ? 43 : ((Object)$relatorios).hashCode());
        List $finalidades = this.getFinalidades();
        result = result * 59 + ($finalidades == null ? 43 : ((Object)$finalidades).hashCode());
        List $gruposDocumento = this.getGruposDocumento();
        result = result * 59 + ($gruposDocumento == null ? 43 : ((Object)$gruposDocumento).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DocumentoTipoDTO(id=" + this.getId() + ", descricao=" + this.getDescricao() + ", impressaoWeb=" + this.getImpressaoWeb() + ", porCadastroGeral=" + this.getPorCadastroGeral() + ", ativo=" + this.getAtivo() + ", exigeProcesso=" + this.getExigeProcesso() + ", possuiCabecalho=" + this.getPossuiCabecalho() + ", possuiRodape=" + this.getPossuiRodape() + ", possuiObservacao=" + this.getPossuiObservacao() + ", possuiHistorico=" + this.getPossuiHistorico() + ", armazenarComoPdf=" + this.getArmazenarComoPdf() + ", maisDeUmLayout=" + this.getMaisDeUmLayout() + ", verificaDebitoPendente=" + this.getVerificaDebitoPendente() + ", verificaAssinaturaDigital=" + this.getVerificaAssinaturaDigital() + ", exigeProjeto=" + this.getExigeProjeto() + ", assunto=" + this.getAssunto() + ", geraDocumentoCentral=" + this.getGeraDocumentoCentral() + ", validadeDia=" + this.getValidadeDia() + ", validadeData=" + this.getValidadeData() + ", validade=" + this.getValidade() + ", relatorio=" + this.getRelatorio() + ", tiposCadastro=" + this.getTiposCadastro() + ", assinaturas=" + this.getAssinaturas() + ", textos=" + this.getTextos() + ", outros=" + this.getOutros() + ", relatorios=" + this.getRelatorios() + ", finalidades=" + this.getFinalidades() + ", gruposDocumento=" + this.getGruposDocumento() + ")";
    }
}

