/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.TipoCadastro;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class DebitoPesquisaDTO {
    private Long id;
    private Long exercicio;
    private TipoCadastro tipoCadastro;
    private Long cadastroGeral;
    private String proprietarioPrincipal;
    private Long divida;
    private String descricaoDivida;
    private Long subDivida;
    private List<String> observacoes;
    private LocalDate dataLancamento;
    private Long numeroParcela;
    private BigDecimal total;

    public static DebitoPesquisaDTO from(Debito debito) {
        DebitoPesquisaDTO dto = new DebitoPesquisaDTO();
        dto.id = debito.getId();
        dto.exercicio = debito.getExercicio();
        dto.tipoCadastro = debito.getCadastroGeral().getTipoCadastro();
        dto.cadastroGeral = debito.getCadastroGeral().getCadastroGeral();
        dto.proprietarioPrincipal = debito.getCadastroGeral().getProprietarioPrincipal().map(p -> p.getPessoa().getNome()).orElse("");
        dto.divida = debito.getDivida().getDivida();
        dto.descricaoDivida = debito.getDivida().getDescricao();
        dto.subDivida = debito.getSubDivida();
        dto.observacoes = new ArrayList();
        dto.dataLancamento = debito.getDataLancamento();
        dto.numeroParcela = debito.getNumeroParcela();
        dto.total = BigDecimal.ZERO;
        return dto;
    }

    @Generated
    public DebitoPesquisaDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public TipoCadastro getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public String getProprietarioPrincipal() {
        return this.proprietarioPrincipal;
    }

    @Generated
    public Long getDivida() {
        return this.divida;
    }

    @Generated
    public String getDescricaoDivida() {
        return this.descricaoDivida;
    }

    @Generated
    public Long getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public List<String> getObservacoes() {
        return this.observacoes;
    }

    @Generated
    public LocalDate getDataLancamento() {
        return this.dataLancamento;
    }

    @Generated
    public Long getNumeroParcela() {
        return this.numeroParcela;
    }

    @Generated
    public BigDecimal getTotal() {
        return this.total;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setTipoCadastro(TipoCadastro tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setProprietarioPrincipal(String proprietarioPrincipal) {
        this.proprietarioPrincipal = proprietarioPrincipal;
    }

    @Generated
    public void setDivida(Long divida) {
        this.divida = divida;
    }

    @Generated
    public void setDescricaoDivida(String descricaoDivida) {
        this.descricaoDivida = descricaoDivida;
    }

    @Generated
    public void setSubDivida(Long subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setObservacoes(List<String> observacoes) {
        this.observacoes = observacoes;
    }

    @Generated
    public void setDataLancamento(LocalDate dataLancamento) {
        this.dataLancamento = dataLancamento;
    }

    @Generated
    public void setNumeroParcela(Long numeroParcela) {
        this.numeroParcela = numeroParcela;
    }

    @Generated
    public void setTotal(BigDecimal total) {
        this.total = total;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DebitoPesquisaDTO)) {
            return false;
        }
        DebitoPesquisaDTO other = (DebitoPesquisaDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        TipoCadastro this$tipoCadastro = this.getTipoCadastro();
        TipoCadastro other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !this$tipoCadastro.equals(other$tipoCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        String this$proprietarioPrincipal = this.getProprietarioPrincipal();
        String other$proprietarioPrincipal = other.getProprietarioPrincipal();
        if (this$proprietarioPrincipal == null ? other$proprietarioPrincipal != null : !this$proprietarioPrincipal.equals(other$proprietarioPrincipal)) {
            return false;
        }
        Long this$divida = this.getDivida();
        Long other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !((Object)this$divida).equals(other$divida)) {
            return false;
        }
        String this$descricaoDivida = this.getDescricaoDivida();
        String other$descricaoDivida = other.getDescricaoDivida();
        if (this$descricaoDivida == null ? other$descricaoDivida != null : !this$descricaoDivida.equals(other$descricaoDivida)) {
            return false;
        }
        Long this$subDivida = this.getSubDivida();
        Long other$subDivida = other.getSubDivida();
        if (this$subDivida == null ? other$subDivida != null : !((Object)this$subDivida).equals(other$subDivida)) {
            return false;
        }
        List this$observacoes = this.getObservacoes();
        List other$observacoes = other.getObservacoes();
        if (this$observacoes == null ? other$observacoes != null : !((Object)this$observacoes).equals(other$observacoes)) {
            return false;
        }
        LocalDate this$dataLancamento = this.getDataLancamento();
        LocalDate other$dataLancamento = other.getDataLancamento();
        if (this$dataLancamento == null ? other$dataLancamento != null : !((Object)this$dataLancamento).equals(other$dataLancamento)) {
            return false;
        }
        Long this$numeroParcela = this.getNumeroParcela();
        Long other$numeroParcela = other.getNumeroParcela();
        if (this$numeroParcela == null ? other$numeroParcela != null : !((Object)this$numeroParcela).equals(other$numeroParcela)) {
            return false;
        }
        BigDecimal this$total = this.getTotal();
        BigDecimal other$total = other.getTotal();
        return !(this$total == null ? other$total != null : !((Object)this$total).equals(other$total));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DebitoPesquisaDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        TipoCadastro $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : $tipoCadastro.hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        String $proprietarioPrincipal = this.getProprietarioPrincipal();
        result = result * 59 + ($proprietarioPrincipal == null ? 43 : $proprietarioPrincipal.hashCode());
        Long $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : ((Object)$divida).hashCode());
        String $descricaoDivida = this.getDescricaoDivida();
        result = result * 59 + ($descricaoDivida == null ? 43 : $descricaoDivida.hashCode());
        Long $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : ((Object)$subDivida).hashCode());
        List $observacoes = this.getObservacoes();
        result = result * 59 + ($observacoes == null ? 43 : ((Object)$observacoes).hashCode());
        LocalDate $dataLancamento = this.getDataLancamento();
        result = result * 59 + ($dataLancamento == null ? 43 : ((Object)$dataLancamento).hashCode());
        Long $numeroParcela = this.getNumeroParcela();
        result = result * 59 + ($numeroParcela == null ? 43 : ((Object)$numeroParcela).hashCode());
        BigDecimal $total = this.getTotal();
        result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DebitoPesquisaDTO(id=" + this.getId() + ", exercicio=" + this.getExercicio() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", proprietarioPrincipal=" + this.getProprietarioPrincipal() + ", divida=" + this.getDivida() + ", descricaoDivida=" + this.getDescricaoDivida() + ", subDivida=" + this.getSubDivida() + ", observacoes=" + this.getObservacoes() + ", dataLancamento=" + this.getDataLancamento() + ", numeroParcela=" + this.getNumeroParcela() + ", total=" + this.getTotal() + ")";
    }
}

