/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.DebitoProcesso;
import br.com.elotech.tributos.domain.DebitoTributo;
import br.com.elotech.tributos.domain.DividaTributo;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.dto.DebitoManualObservacaoDTO;
import br.com.elotech.tributos.dto.DebitoManualParcelaDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;

public class DebitoManualIssDTO {
    @NotNull(message="Exerc\u00edcio \u00e9 obrigat\u00f3rio")
    private @NotNull(message="Exerc\u00edcio \u00e9 obrigat\u00f3rio") Long exercicio;
    @NotNull(message="Tipo cadastro \u00e9 obrigat\u00f3rio")
    private @NotNull(message="Tipo cadastro \u00e9 obrigat\u00f3rio") TipoCadastro tipoCadastro;
    @NotNull(message="Cadastro \u00e9 obrigat\u00f3rio")
    private @NotNull(message="Cadastro \u00e9 obrigat\u00f3rio") Long cadastroGeral;
    @NotNull(message="D\u00edvida \u00e9 obrigat\u00f3ria")
    private @NotNull(message="D\u00edvida \u00e9 obrigat\u00f3ria") Long divida;
    private Long subDivida;
    @NotNull(message="Data de lan\u00e7amento \u00e9 obrigat\u00f3ria")
    private @NotNull(message="Data de lan\u00e7amento \u00e9 obrigat\u00f3ria") LocalDate dataLancamento;
    @NotNull(message="Forma de corre\u00e7\u00e3o \u00e9 obrigat\u00f3ria")
    private @NotNull(message="Forma de corre\u00e7\u00e3o \u00e9 obrigat\u00f3ria") Long formaCorrecao;
    private Long exercicioProcesso;
    private Long processo;
    private String program;
    private Boolean baixaAutomatica = Boolean.FALSE;
    @NotEmpty(message="Informe ao menos uma parcela")
    private @NotEmpty(message="Informe ao menos uma parcela") List<DebitoManualParcelaDTO> parcelas = new ArrayList();
    @NotNull(message="O tributo \u00e9 obrigat\u00f3rio")
    private @NotNull(message="O tributo \u00e9 obrigat\u00f3rio") DividaTributo tributo;
    private List<DebitoManualObservacaoDTO> observacoes = new ArrayList();

    @JsonIgnore
    public Optional<DebitoManualParcelaDTO> getParcelaByNumeroParcela(Long numeroParcela) {
        return this.getParcelas().stream().filter(parcela -> parcela.getParcela().equals(numeroParcela)).findFirst();
    }

    public List<Debito> toEntity(Long entidade, String usuario) {
        Long subDividaIssHomologado = 100L;
        return this.parcelas.stream().map(parcela -> {
            Debito debito = new Debito();
            debito.setEntidade(entidade);
            debito.setExercicio(this.getExercicio());
            debito.setTipoCadastro(this.getTipoCadastro().getValue());
            debito.setCadastroGeralId(this.getCadastroGeral());
            debito.setGuiaRecolhimento(this.getDivida());
            if (Objects.isNull(this.subDivida)) {
                debito.setSubDivida(Long.valueOf(subDividaIssHomologado + parcela.getParcela()));
            } else {
                debito.setSubDivida(this.subDivida);
            }
            debito.setDataInclusao(LocalDate.now());
            debito.setDataLancamento(this.getDataLancamento());
            debito.setUsuario(usuario);
            debito.setPrograma("DebitoManualISS");
            Optional.ofNullable(this.program).ifPresent(arg_0 -> ((Debito)debito).setPrograma(arg_0));
            if (Objects.nonNull(this.getProcesso())) {
                debito.getProcessos().add(DebitoProcesso.of((Long)this.getExercicioProcesso(), (Long)this.getProcesso(), (String)"Processo informado durante gera\u00e7\u00e3o de d\u00e9bito manual."));
            }
            if (Objects.nonNull(this.getObservacoes())) {
                this.getObservacoes().stream().map(observacao -> observacao.toEntity(usuario)).forEach(debito.getObservacoes()::add);
            }
            DebitoTributo debitoTributo = parcela.toDebitoTributo(this.getTributo());
            DebitoParcela debitoParcela = parcela.toDebitoParcelaISS(usuario, this.getDataLancamento(), this.getExercicio());
            debito.getTributos().add(debitoTributo);
            debito.getParcelas().add(debitoParcela);
            DebitoParcelaTributo parcelaTributo = new DebitoParcelaTributo();
            parcelaTributo.setDebitoParcela(debitoParcela);
            parcelaTributo.setTributo(debitoTributo.getId().getTributo());
            parcelaTributo.setValor(debitoTributo.getValorTributo());
            parcelaTributo.setValorOriginal(debitoTributo.getValorTributo());
            debitoParcela.getTributos().add(parcelaTributo);
            debito.setNumeroParcela(Long.valueOf(1L));
            debito.setDataPrimeiraParcela();
            debito.setChildrenId();
            return debito;
        }).collect(Collectors.toList());
    }

    @Generated
    public DebitoManualIssDTO() {
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public TipoCadastro getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getDivida() {
        return this.divida;
    }

    @Generated
    public Long getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public LocalDate getDataLancamento() {
        return this.dataLancamento;
    }

    @Generated
    public Long getFormaCorrecao() {
        return this.formaCorrecao;
    }

    @Generated
    public Long getExercicioProcesso() {
        return this.exercicioProcesso;
    }

    @Generated
    public Long getProcesso() {
        return this.processo;
    }

    @Generated
    public String getProgram() {
        return this.program;
    }

    @Generated
    public Boolean getBaixaAutomatica() {
        return this.baixaAutomatica;
    }

    @Generated
    public List<DebitoManualParcelaDTO> getParcelas() {
        return this.parcelas;
    }

    @Generated
    public DividaTributo getTributo() {
        return this.tributo;
    }

    @Generated
    public List<DebitoManualObservacaoDTO> getObservacoes() {
        return this.observacoes;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setTipoCadastro(TipoCadastro tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setDivida(Long divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubDivida(Long subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setDataLancamento(LocalDate dataLancamento) {
        this.dataLancamento = dataLancamento;
    }

    @Generated
    public void setFormaCorrecao(Long formaCorrecao) {
        this.formaCorrecao = formaCorrecao;
    }

    @Generated
    public void setExercicioProcesso(Long exercicioProcesso) {
        this.exercicioProcesso = exercicioProcesso;
    }

    @Generated
    public void setProcesso(Long processo) {
        this.processo = processo;
    }

    @Generated
    public void setProgram(String program) {
        this.program = program;
    }

    @Generated
    public void setBaixaAutomatica(Boolean baixaAutomatica) {
        this.baixaAutomatica = baixaAutomatica;
    }

    @Generated
    public void setParcelas(List<DebitoManualParcelaDTO> parcelas) {
        this.parcelas = parcelas;
    }

    @Generated
    public void setTributo(DividaTributo tributo) {
        this.tributo = tributo;
    }

    @Generated
    public void setObservacoes(List<DebitoManualObservacaoDTO> observacoes) {
        this.observacoes = observacoes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DebitoManualIssDTO)) {
            return false;
        }
        DebitoManualIssDTO other = (DebitoManualIssDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        TipoCadastro this$tipoCadastro = this.getTipoCadastro();
        TipoCadastro other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !this$tipoCadastro.equals(other$tipoCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Long this$divida = this.getDivida();
        Long other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !((Object)this$divida).equals(other$divida)) {
            return false;
        }
        Long this$subDivida = this.getSubDivida();
        Long other$subDivida = other.getSubDivida();
        if (this$subDivida == null ? other$subDivida != null : !((Object)this$subDivida).equals(other$subDivida)) {
            return false;
        }
        LocalDate this$dataLancamento = this.getDataLancamento();
        LocalDate other$dataLancamento = other.getDataLancamento();
        if (this$dataLancamento == null ? other$dataLancamento != null : !((Object)this$dataLancamento).equals(other$dataLancamento)) {
            return false;
        }
        Long this$formaCorrecao = this.getFormaCorrecao();
        Long other$formaCorrecao = other.getFormaCorrecao();
        if (this$formaCorrecao == null ? other$formaCorrecao != null : !((Object)this$formaCorrecao).equals(other$formaCorrecao)) {
            return false;
        }
        Long this$exercicioProcesso = this.getExercicioProcesso();
        Long other$exercicioProcesso = other.getExercicioProcesso();
        if (this$exercicioProcesso == null ? other$exercicioProcesso != null : !((Object)this$exercicioProcesso).equals(other$exercicioProcesso)) {
            return false;
        }
        Long this$processo = this.getProcesso();
        Long other$processo = other.getProcesso();
        if (this$processo == null ? other$processo != null : !((Object)this$processo).equals(other$processo)) {
            return false;
        }
        String this$program = this.getProgram();
        String other$program = other.getProgram();
        if (this$program == null ? other$program != null : !this$program.equals(other$program)) {
            return false;
        }
        Boolean this$baixaAutomatica = this.getBaixaAutomatica();
        Boolean other$baixaAutomatica = other.getBaixaAutomatica();
        if (this$baixaAutomatica == null ? other$baixaAutomatica != null : !((Object)this$baixaAutomatica).equals(other$baixaAutomatica)) {
            return false;
        }
        List this$parcelas = this.getParcelas();
        List other$parcelas = other.getParcelas();
        if (this$parcelas == null ? other$parcelas != null : !((Object)this$parcelas).equals(other$parcelas)) {
            return false;
        }
        DividaTributo this$tributo = this.getTributo();
        DividaTributo other$tributo = other.getTributo();
        if (this$tributo == null ? other$tributo != null : !this$tributo.equals(other$tributo)) {
            return false;
        }
        List this$observacoes = this.getObservacoes();
        List other$observacoes = other.getObservacoes();
        return !(this$observacoes == null ? other$observacoes != null : !((Object)this$observacoes).equals(other$observacoes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DebitoManualIssDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        TipoCadastro $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : $tipoCadastro.hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Long $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : ((Object)$divida).hashCode());
        Long $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : ((Object)$subDivida).hashCode());
        LocalDate $dataLancamento = this.getDataLancamento();
        result = result * 59 + ($dataLancamento == null ? 43 : ((Object)$dataLancamento).hashCode());
        Long $formaCorrecao = this.getFormaCorrecao();
        result = result * 59 + ($formaCorrecao == null ? 43 : ((Object)$formaCorrecao).hashCode());
        Long $exercicioProcesso = this.getExercicioProcesso();
        result = result * 59 + ($exercicioProcesso == null ? 43 : ((Object)$exercicioProcesso).hashCode());
        Long $processo = this.getProcesso();
        result = result * 59 + ($processo == null ? 43 : ((Object)$processo).hashCode());
        String $program = this.getProgram();
        result = result * 59 + ($program == null ? 43 : $program.hashCode());
        Boolean $baixaAutomatica = this.getBaixaAutomatica();
        result = result * 59 + ($baixaAutomatica == null ? 43 : ((Object)$baixaAutomatica).hashCode());
        List $parcelas = this.getParcelas();
        result = result * 59 + ($parcelas == null ? 43 : ((Object)$parcelas).hashCode());
        DividaTributo $tributo = this.getTributo();
        result = result * 59 + ($tributo == null ? 43 : $tributo.hashCode());
        List $observacoes = this.getObservacoes();
        result = result * 59 + ($observacoes == null ? 43 : ((Object)$observacoes).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DebitoManualIssDTO(exercicio=" + this.getExercicio() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", divida=" + this.getDivida() + ", subDivida=" + this.getSubDivida() + ", dataLancamento=" + this.getDataLancamento() + ", formaCorrecao=" + this.getFormaCorrecao() + ", exercicioProcesso=" + this.getExercicioProcesso() + ", processo=" + this.getProcesso() + ", program=" + this.getProgram() + ", baixaAutomatica=" + this.getBaixaAutomatica() + ", parcelas=" + this.getParcelas() + ", tributo=" + this.getTributo() + ", observacoes=" + this.getObservacoes() + ")";
    }
}

