/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.calculo.dto.CadastroCalculoDTO;
import br.com.elotech.tributos.calculo.dto.CadastroCalculoRoot;
import br.com.elotech.tributos.calculo.dto.CadastroImobiliarioCalculoDTO;
import br.com.elotech.tributos.calculo.dto.CadastroMobiliarioCalculoDTO;
import br.com.elotech.tributos.calculo.dto.CalculoBuildDTO;
import br.com.elotech.tributos.calculo.dto.CalculoContext;
import br.com.elotech.tributos.calculo.dto.CalculoImobiliarioContext;
import br.com.elotech.tributos.calculo.dto.CalculoMobiliarioContext;
import br.com.elotech.tributos.calculo.dto.CampoDinamicoScriptDTO;
import br.com.elotech.tributos.calculo.exception.CalculoException;
import br.com.elotech.tributos.calculo.repository.CadastroImobiliarioCalculoRepository;
import br.com.elotech.tributos.calculo.repository.CadastroMobiliarioCalculoRepository;
import br.com.elotech.tributos.calculo.service.CalculoBuild;
import br.com.elotech.tributos.calculo.service.CalculoParser;
import br.com.elotech.tributos.calculo.service.CalculoTabelaValores;
import br.com.elotech.tributos.calculo.service.TabelaValorService;
import br.com.elotech.tributos.domain.TipoDivida;
import br.com.elotech.tributos.domain.calculo.CalculoConfigBase;
import br.com.elotech.tributos.domain.calculo.TipoCalculoConfig;
import com.google.common.base.Stopwatch;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.ConversionService;

public abstract class CalculoExecucaoBaseService<T extends CalculoConfigBase> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CalculoExecucaoBaseService.class);
    private final CadastroImobiliarioCalculoRepository cadastroImobiliarioCalculoRepository;
    private final ConversionService conversionService;
    private final TabelaValorService tabelaValorService;
    private final CadastroMobiliarioCalculoRepository cadastroMobiliarioCalculoRepository;

    protected List<CadastroCalculoRoot> calcular(List<T> configs, Long exercicio, String filtro, Long segmento, Boolean traceAtivo, LocalDate dataReferencia, UnaryOperator<List<CadastroCalculoRoot>> customizer) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Set camposDinamicos = CalculoParser.extractCamposDinamicos(configs);
        List root = this.loadCadastros(configs, filtro, segmento, exercicio, camposDinamicos, dataReferencia);
        if (Objects.nonNull(customizer)) {
            root = (List)customizer.apply(root);
        }
        stopwatch.stop();
        log.debug("Carregando {} cadastros - {} m {} s {} ms - {} ns", new Object[]{root.size(), stopwatch.elapsed(TimeUnit.MINUTES), stopwatch.elapsed(TimeUnit.SECONDS), stopwatch.elapsed(TimeUnit.MILLISECONDS), stopwatch.elapsed(TimeUnit.NANOSECONDS)});
        if (root.isEmpty()) {
            throw new CalculoException("N\u00e3o foram encontrados cadastros para o filtro informado.");
        }
        return this.calcular(root, configs, traceAtivo, exercicio);
    }

    public List<CadastroCalculoRoot> calcular(List<T> configs, Long exercicio, String filtro, Long segmento, Boolean traceAtivo, LocalDate dataReferencia) {
        return this.calcular(configs, exercicio, filtro, segmento, traceAtivo, dataReferencia, null);
    }

    public List<CadastroCalculoRoot> calcular(List<T> configs, Long exercicio, String filtro, Boolean traceAtivo, LocalDate dataReferencia) {
        return this.calcular(configs, exercicio, filtro, null, traceAtivo, dataReferencia);
    }

    public List<CadastroCalculoRoot> calcular(List<CadastroCalculoRoot> cadastros, List<T> configs, Boolean traceAtivo, Long exercicio) {
        CalculoTabelaValores calculoTabelaValores = this.carregaTabelaValores(exercicio);
        for (CalculoConfigBase config : configs) {
            CalculoBuildDTO calculoBuildDTO = this.getFormulaCompilada(config, traceAtivo);
            config.setCalculoBuildDTO(calculoBuildDTO);
            config.getCalculoBuildDTO().getContext().setCalculoTabelaValores(calculoTabelaValores);
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        cadastros.forEach(cadastro -> this.executeCalculo(configs, cadastro));
        stopwatch.stop();
        log.debug("Execution time: {} cadastros -  {} ms  - {} ns", new Object[]{cadastros.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS), stopwatch.elapsed(TimeUnit.NANOSECONDS)});
        return cadastros;
    }

    protected CalculoTabelaValores carregaTabelaValores(Long exercicio) {
        return new CalculoTabelaValores(this.conversionService, this.tabelaValorService.findByExercicio(exercicio));
    }

    public CalculoBuildDTO getFormulaCompilada(T config, Boolean traceAtivo) {
        try {
            String scriptParsed = CalculoParser.parseLinhas((List)config.getScript(), (String)config.getIdentificadorResultado(), (String)config.getIdentificadorBaseCalculo(), (String)config.getIdentificadorCondicao(), (String)"", (String)config.getIdentificadorAliquota(), (String)"", (String)"");
            Stopwatch stopwatch = Stopwatch.createStarted();
            CalculoBuildDTO calculoBuildDTO = CalculoBuild.buildCalculo((String)scriptParsed, (Boolean)traceAtivo, (TipoDivida)config.getTipoDivida());
            stopwatch.stop();
            log.debug("Build time {}: {} ms - {} ns ", new Object[]{config.getIdentificadorLog(), stopwatch.elapsed(TimeUnit.MILLISECONDS), stopwatch.elapsed(TimeUnit.NANOSECONDS)});
            return calculoBuildDTO;
        }
        catch (Exception e) {
            throw new CalculoException(String.format("Erro ao compilar o c\u00e1lculo %s", config.getIdentificadorLog()), (Throwable)e);
        }
    }

    protected void executeCalculo(List<T> configs, CadastroCalculoRoot root) {
        for (CalculoConfigBase config : configs) {
            try {
                if (TipoCalculoConfig.GERAL.equals((Object)config.getTipo())) {
                    this.executeCalculoGeral(root, config);
                    continue;
                }
                this.executeCalculoPorSegmento(root, config);
            }
            catch (InvocationTargetException e) {
                log.error("Erro ao calcular {} do cadastro {}-{}: {}", new Object[]{config.getIdentificadorLog(), root.getTipoCadastro(), root.getCadastroGeral(), e});
                root.addInconsistencia(config, e.getTargetException().getMessage());
            }
            catch (Exception e) {
                log.error("Erro ao calcular {} do cadastro {}-{}: {}", new Object[]{config.getIdentificadorLog(), root.getTipoCadastro(), root.getCadastroGeral(), e});
                root.addInconsistencia(config, e.getMessage());
            }
        }
    }

    private void executeCalculoPorSegmento(CadastroCalculoRoot root, T config) throws InvocationTargetException, IllegalAccessException {
        for (CadastroCalculoDTO cadastro : root.getChildren()) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            this.setVariaveisCadastro(config.getCalculoBuildDTO().getContext(), cadastro);
            CalculoContext context = CalculoBuild.evaluate((CalculoBuildDTO)config.getCalculoBuildDTO());
            cadastro.addResultado(config, context);
            stopwatch.stop();
            log.trace("Cadastro: {}-{} - {} - Evaluation time: {} ms  - {} ns", new Object[]{root.getTipoCadastro(), root.getCadastroGeral(), config.getIdentificadorLog(), stopwatch.elapsed(TimeUnit.MILLISECONDS), stopwatch.elapsed(TimeUnit.NANOSECONDS)});
        }
    }

    private void executeCalculoGeral(CadastroCalculoRoot root, T config) throws InvocationTargetException, IllegalAccessException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.setVariaveisCadastro(config.getCalculoBuildDTO().getContext(), (CadastroCalculoDTO)root.getChildren().get(0));
        CalculoContext context = CalculoBuild.evaluate((CalculoBuildDTO)config.getCalculoBuildDTO());
        root.addResultado(config, context);
        stopwatch.stop();
        log.trace("Cadastro: {}-{} - {} - Evaluation time: {} ms  - {} ns", new Object[]{root.getTipoCadastro(), root.getCadastroGeral(), config.getIdentificadorLog(), stopwatch.elapsed(TimeUnit.MILLISECONDS), stopwatch.elapsed(TimeUnit.NANOSECONDS)});
    }

    private void setVariaveisCadastro(CalculoContext context, CadastroCalculoDTO cadastro) {
        if (context instanceof CalculoImobiliarioContext) {
            ((CalculoImobiliarioContext)context).setCadastro(((CadastroImobiliarioCalculoDTO)cadastro).getCadastro());
            ((CalculoImobiliarioContext)context).setSegmento(((CadastroImobiliarioCalculoDTO)cadastro).getSegmento());
            ((CalculoImobiliarioContext)context).setTestada(((CadastroImobiliarioCalculoDTO)cadastro).getTestada());
            ((CalculoImobiliarioContext)context).setTestadagenerica(((CadastroImobiliarioCalculoDTO)cadastro).getTestadaGenerica());
        } else if (context instanceof CalculoMobiliarioContext) {
            ((CalculoMobiliarioContext)context).setCadastro(((CadastroMobiliarioCalculoDTO)cadastro).getCadastro());
            ((CalculoMobiliarioContext)context).setAtividade(((CadastroMobiliarioCalculoDTO)cadastro).getAtividade());
            ((CalculoMobiliarioContext)context).setCnae(((CadastroMobiliarioCalculoDTO)cadastro).getCnae());
            ((CalculoMobiliarioContext)context).setServico(((CadastroMobiliarioCalculoDTO)cadastro).getServico());
        }
    }

    protected List<CadastroCalculoRoot> loadCadastros(List<T> configs, String filtro, Long segmento, Long exercicio, Set<CampoDinamicoScriptDTO> camposDinamicos, LocalDate dataReferencia) {
        if (configs.isEmpty()) {
            throw new CalculoException("N\u00e3o foi informado script para execu\u00e7\u00e3o do c\u00e1lculo.");
        }
        TipoDivida tipoDivida = ((CalculoConfigBase)configs.get(0)).getTipoDivida();
        if (TipoDivida.IPTU.equals((Object)tipoDivida)) {
            return this.cadastroImobiliarioCalculoRepository.loadCadastros(filtro, segmento, exercicio, camposDinamicos);
        }
        if (TipoDivida.ISS_FIXO.equals((Object)tipoDivida) || TipoDivida.ALVARA.equals((Object)tipoDivida)) {
            return this.cadastroMobiliarioCalculoRepository.loadCadastros(filtro, exercicio, camposDinamicos, dataReferencia);
        }
        throw new EloValidationException(String.format("N\u00e3o h\u00e1 implementa\u00e7\u00e3o de c\u00e1lculo para o tipo de d\u00edvida %s.", tipoDivida));
    }

    @Generated
    public CalculoExecucaoBaseService(CadastroImobiliarioCalculoRepository cadastroImobiliarioCalculoRepository, ConversionService conversionService, TabelaValorService tabelaValorService, CadastroMobiliarioCalculoRepository cadastroMobiliarioCalculoRepository) {
        this.cadastroImobiliarioCalculoRepository = cadastroImobiliarioCalculoRepository;
        this.conversionService = conversionService;
        this.tabelaValorService = tabelaValorService;
        this.cadastroMobiliarioCalculoRepository = cadastroMobiliarioCalculoRepository;
    }
}

