/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.resource;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.calculo.domain.CalculoCadastro;
import br.com.elotech.tributos.calculo.dto.AuxiliaresCalculoDTO;
import br.com.elotech.tributos.calculo.dto.ParametroTesteScriptDTO;
import br.com.elotech.tributos.calculo.exception.CalculoException;
import br.com.elotech.tributos.calculo.service.CalculoTributoExecucaoService;
import br.com.elotech.tributos.calculo.service.CalculoTributoService;
import br.com.elotech.tributos.domain.TipoDivida;
import br.com.elotech.tributos.domain.calculo.CalculoTributo;
import br.com.elotech.tributos.domain.calculo.TipoCalculoConfig;
import br.com.elotech.tributos.domain.camposdinamicos.Campo;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/calculo-tributo"})
public class CalculoTributoResource
extends CrudResource<CalculoTributo, Long> {
    private final CalculoTributoExecucaoService calculoTributoExecucaoService;
    private final CalculoTributoService calculoTributoService;

    public CalculoTributoResource(CalculoTributoExecucaoService calculoTributoExecucaoService, CalculoTributoService calculoTributoService) {
        this.calculoTributoExecucaoService = calculoTributoExecucaoService;
        this.calculoTributoService = calculoTributoService;
    }

    @PostMapping(value={"/teste-script"})
    public ResponseEntity<CalculoCadastro> testarScript(@RequestBody ParametroTesteScriptDTO parametroCalculoDTO) {
        return ResponseEntity.ok((Object)this.calculoTributoExecucaoService.testarScript(parametroCalculoDTO).stream().map(CalculoCadastro::from).findFirst().orElseThrow(() -> new CalculoException("N\u00e3o foi poss\u00edvel calcular o Tributo")));
    }

    @GetMapping(value={"/auxiliares"})
    public ResponseEntity<AuxiliaresCalculoDTO> getAuxiliares(@RequestParam Long exercicio, @RequestParam String tipoDivida) {
        return ResponseEntity.ok((Object)this.calculoTributoService.getAuxiliares(exercicio, TipoDivida.fromValue((String)tipoDivida)));
    }

    @GetMapping(value={"/campos-dinamicos-calculo"})
    public ResponseEntity<List<Campo>> getCamposDinamicosCalculo(@RequestParam String search, @RequestParam String tipoDivida, @RequestParam String tipoCalculoTributo) {
        return ResponseEntity.ok((Object)this.calculoTributoService.getCamposDinamicosCalculo(search, TipoDivida.fromValue((String)tipoDivida), TipoCalculoConfig.fromValue((String)tipoCalculoTributo)));
    }
}

