/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.lancamentocredito;

import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.simam.LancamentoCredito;
import br.com.elotech.tributos.domain.simam.LancamentoCreditoTributo;
import br.com.elotech.tributos.domain.simam.LancamentoCreditoTributoId;
import br.com.elotech.tributos.dto.ClassificacaoTipoTributo;
import br.com.elotech.tributos.dto.TipoNaturezaCredito;
import br.com.elotech.tributos.dto.TipoOperacaoCredito;
import br.com.elotech.tributos.dto.simam.LancamentoCreditoConsultaDTO;
import br.com.elotech.tributos.repository.SequenceGeneratorRepository;
import br.com.elotech.tributos.repository.simam.LancamentoCreditoRepository;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.annotation.OnProcessError;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class LancamentoCreditoImplantacaoSaldoBatchProcessor
implements ItemProcessor<LancamentoCreditoConsultaDTO, LancamentoCreditoTributo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LancamentoCreditoImplantacaoSaldoBatchProcessor.class);
    private static final String LOG_PARAM = "SIM-AM - Lan\u00e7amento de Cr\u00e9dito (Implanta\u00e7\u00e3o de Saldo) - ";
    private final Map<String, Long> cargaExistente = new ConcurrentHashMap();
    private final AtomicLong ultimoNrCredito = new AtomicLong(0L);
    private Long nrAnoCredito;
    private StepExecution stepExecution;
    private final EntityManager entityManager;
    private final SequenceGeneratorRepository sequenceGeneratorRepository;
    private final LancamentoCreditoRepository lancamentoCreditoRepository;

    public LancamentoCreditoImplantacaoSaldoBatchProcessor(SequenceGeneratorRepository sequenceGeneratorRepository, EntityManager entityManager, LancamentoCreditoRepository lancamentoCreditoRepository) {
        this.entityManager = entityManager;
        this.sequenceGeneratorRepository = sequenceGeneratorRepository;
        this.lancamentoCreditoRepository = lancamentoCreditoRepository;
    }

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
        Long idControle = Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getLong("idControle"));
        this.nrAnoCredito = Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getLong("exercicio"));
        LOGGER.info("SIM-AM - Lan\u00e7amento de Cr\u00e9dito (Implanta\u00e7\u00e3o de Saldo) - Iniciando gera\u00e7\u00e3o de dados - exercicio: {}", (Object)this.nrAnoCredito);
        LOGGER.info("SIM-AM - Lan\u00e7amento de Cr\u00e9dito (Implanta\u00e7\u00e3o de Saldo) - load da carga existente");
        this.lancamentoCreditoRepository.getCargaExistenteLancamentoCreditoImplantacaoSaldo(idControle).forEach(item -> this.cargaExistente.put(item.getChave(), item.getId()));
        LOGGER.info("SIM-AM - Lan\u00e7amento de Cr\u00e9dito (Implanta\u00e7\u00e3o de Saldo) - Atualizando \u00faltimo NrCredito");
        this.ultimoNrCredito.set(this.lancamentoCreditoRepository.findNextNrCreditoByExercicio(this.nrAnoCredito));
    }

    public LancamentoCreditoTributo process(LancamentoCreditoConsultaDTO item) {
        String chave = String.format("%d-%d-%d-%d-%s", item.getIdTipoNaturezaCredito(), item.getIdTipoCredito(), item.getIdTipoOperacaoCredito(), item.getCdControleLeiAto(), item.getDtLancamento().toString());
        Long finalId = this.cargaExistente.compute(chave, (k, v) -> {
            if (Objects.nonNull(v)) {
                return v;
            }
            Long nextVal = this.sequenceGeneratorRepository.getNextVal("S05IDTCELANCCREDITO");
            LancamentoCredito lancamentoCredito = new LancamentoCredito();
            lancamentoCredito.setId(nextVal);
            lancamentoCredito.setTipoNaturezaCredito(TipoNaturezaCredito.fromValue((Long)item.getIdTipoNaturezaCredito()));
            lancamentoCredito.setTipoCredito(ClassificacaoTipoTributo.fromValue((Integer)item.getIdTipoCredito().intValue()));
            lancamentoCredito.setTipoOperacaoCredito(TipoOperacaoCredito.fromValue((Long)item.getIdTipoOperacaoCredito()));
            lancamentoCredito.setDataLancamento(item.getDtLancamento());
            lancamentoCredito.setNrAnoCredito(this.nrAnoCredito);
            lancamentoCredito.setNrCredito(Long.valueOf(this.ultimoNrCredito.getAndIncrement()));
            LOGGER.info("SIM-AM - Lan\u00e7amento de Cr\u00e9dito (Implanta\u00e7\u00e3o de Saldo) - gerando novo registro -> {} ({}/{})", new Object[]{nextVal, lancamentoCredito.getNrCredito(), lancamentoCredito.getNrAnoCredito()});
            this.lancamentoCreditoRepository.save((Object)lancamentoCredito);
            this.entityManager.flush();
            return nextVal;
        });
        LancamentoCreditoTributoId id = new LancamentoCreditoTributoId();
        id.setLancamentoCredito((LancamentoCredito)this.entityManager.getReference(LancamentoCredito.class, (Object)finalId));
        id.setDebitoParcelaTributo((DebitoParcelaTributo)this.entityManager.getReference(DebitoParcelaTributo.class, (Object)item.getIdDebitoParcelaReceita()));
        LancamentoCreditoTributo lancamentoTributo = new LancamentoCreditoTributo();
        lancamentoTributo.setId(id);
        lancamentoTributo.setValor(item.getVlLancamento());
        return lancamentoTributo;
    }

    @OnProcessError
    public void onProcessError(LancamentoCreditoConsultaDTO item, Exception e) throws Exception {
        LOGGER.error("SIM-AM - Lan\u00e7amento de Cr\u00e9dito (Implanta\u00e7\u00e3o de Saldo) - erro: {}\n{})", (Object)e.getMessage(), (Object)ObjectMapperSingleton.getObjectMapper().writeValueAsString((Object)item));
        throw e;
    }
}

