/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.estornodeducaocredito.dividaativa;

import br.com.elotech.tributos.domain.simam.EstornoDeducaoCancelamentoDividaAtiva;
import br.com.elotech.tributos.domain.simam.EstornoDeducaoCreditoCreditoDividaAtiva;
import br.com.elotech.tributos.domain.simam.EstornoDeducaoPagamentoDividaAtiva;
import br.com.elotech.tributos.domain.simam.EstornoTipoDeducaoDividaAtiva;
import br.com.elotech.tributos.repository.simam.EstornoDeducaoCreditoCancelamentoDividaAtivaRepository;
import br.com.elotech.tributos.repository.simam.EstornoDeducaoCreditoCreditoDividaAtivaRepository;
import br.com.elotech.tributos.repository.simam.EstornoDeducaoCreditoPagamentoDividaAtivaRepository;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterWrite;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class EstornoDeducaoCreditoDividaAtivaBatchWriter
implements ItemWriter<EstornoTipoDeducaoDividaAtiva> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EstornoDeducaoCreditoDividaAtivaBatchWriter.class);
    private final EntityManager entityManager;
    private final EstornoDeducaoCreditoCancelamentoDividaAtivaRepository estornodeducaoCreditoCancelamentoDividaAtivaRepository;
    private final EstornoDeducaoCreditoPagamentoDividaAtivaRepository estornodeducaoCreditoPagamentoDividaAtivaRepository;
    private final EstornoDeducaoCreditoCreditoDividaAtivaRepository estornodeducaoCreditoCreditoDividaAtivaRepository;
    private StepExecution stepExecution;

    @BeforeStep
    void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public void write(List<? extends EstornoTipoDeducaoDividaAtiva> items) throws Exception {
        List cancelamentos = items.stream().filter(EstornoDeducaoCancelamentoDividaAtiva.class::isInstance).map(EstornoDeducaoCancelamentoDividaAtiva.class::cast).collect(Collectors.toList());
        List pagamentos = items.stream().filter(EstornoDeducaoPagamentoDividaAtiva.class::isInstance).map(EstornoDeducaoPagamentoDividaAtiva.class::cast).collect(Collectors.toList());
        List creditos = items.stream().filter(EstornoDeducaoCreditoCreditoDividaAtiva.class::isInstance).map(EstornoDeducaoCreditoCreditoDividaAtiva.class::cast).collect(Collectors.toList());
        this.estornodeducaoCreditoCancelamentoDividaAtivaRepository.saveAll(cancelamentos);
        this.estornodeducaoCreditoPagamentoDividaAtivaRepository.saveAll(pagamentos);
        this.estornodeducaoCreditoCreditoDividaAtivaRepository.saveAll(creditos);
        this.entityManager.flush();
    }

    @AfterWrite
    public void afterWrite(List<? extends EstornoTipoDeducaoDividaAtiva> items) {
        log.info("SIM-AM - Estorno Dedu\u00e7\u00f5es de Cr\u00e9ditos em D\u00edvida Ativa - Registros salvos at\u00e9 o momento: {}. Job Id {}.", (Object)(this.stepExecution.getReadCount() + items.size()), (Object)this.stepExecution.getJobExecution().getId());
    }

    @Generated
    public EstornoDeducaoCreditoDividaAtivaBatchWriter(EntityManager entityManager, EstornoDeducaoCreditoCancelamentoDividaAtivaRepository estornodeducaoCreditoCancelamentoDividaAtivaRepository, EstornoDeducaoCreditoPagamentoDividaAtivaRepository estornodeducaoCreditoPagamentoDividaAtivaRepository, EstornoDeducaoCreditoCreditoDividaAtivaRepository estornodeducaoCreditoCreditoDividaAtivaRepository) {
        this.entityManager = entityManager;
        this.estornodeducaoCreditoCancelamentoDividaAtivaRepository = estornodeducaoCreditoCancelamentoDividaAtivaRepository;
        this.estornodeducaoCreditoPagamentoDividaAtivaRepository = estornodeducaoCreditoPagamentoDividaAtivaRepository;
        this.estornodeducaoCreditoCreditoDividaAtivaRepository = estornodeducaoCreditoCreditoDividaAtivaRepository;
    }
}

