/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.integracaoboleto;

import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoBoletoPixLog;
import br.com.elotech.tributos.dto.integracaoboleto.itau.CodigoBarrasQrCodePixItauDTO;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoPixReceiver;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import com.fasterxml.jackson.core.JsonProcessingException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class IntegracaoBoletoPixItauBatchProcessor
implements ItemProcessor<CodigoBarrasQrCodePixItauDTO, IntegracaoBoletoPixLog> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntegracaoBoletoPixItauBatchProcessor.class);
    private final IntegracaoPixReceiver integracaoPixReceiver;
    private StepExecution stepExecution;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public IntegracaoBoletoPixLog process(CodigoBarrasQrCodePixItauDTO item) throws JsonProcessingException {
        LOGGER.info("ExecutionId: {}, StepId: {}, ReadCount: {}.", new Object[]{this.stepExecution.getJobExecution().getId(), this.stepExecution.getId(), this.stepExecution.getReadCount()});
        LOGGER.info("Realizando o envio de c\u00f3digos de barra para o Banco do boleto: %d/%d", (Object)item.getId());
        try {
            return this.integracaoPixReceiver.updateCodigoBarrasBoleto(item);
        }
        catch (Exception e) {
            LOGGER.error("Erro: {}\n{})", (Object)e.getMessage(), (Object)ObjectMapperSingleton.getObjectMapper().writeValueAsString((Object)item));
            return null;
        }
    }

    @Generated
    public IntegracaoBoletoPixItauBatchProcessor(IntegracaoPixReceiver integracaoPixReceiver) {
        this.integracaoPixReceiver = integracaoPixReceiver;
    }
}

