select row_number() over (order by t.nrDivida, t.nrAnoDivida) as linha,
       t.idTceInscCreditoDA,
       t.nrDivida,
       t.nrAnoDivida,
       t.idTipoOperacaoCredito,
       case when (idTipoOperacaoCredito=2) then null else t.nrCredito end as nrCredito,
       case when (idTipoOperacaoCredito=2) then null else t.nrAnoCredito end as nrAnoCredito,
       case when (idTipoOperacaoCredito=3) then null else t.idTipoNaturezaCredito end as idTipoNaturezaCredito,
       case when (idTipoOperacaoCredito=3) then null else t.idTipoCredito end as idTipoCredito,
       case when (idTipoOperacaoCredito=3) then null else t.nrAnoBase end as nrAnoBase,
       t.cdControleLeiAto,
       c.idtce, 
       c.idtipoescopolei,
       t.dtInscricao,
       t.vlInscricao,
       t.nrAnoInscricao
from tceInscCreditoDA t
left join cgato c on c.entidade = :entidade and c.idato = t.cdControleLeiAto
where ((t.dtinscricao between :dataInicial and :dataFinal) or 
	   (extract(year from cast(:dataInicial as date)) = 2022
		and extract(month from cast(:dataInicial as date)) = 1
		and t.dtinscricao < :dataInicial))
order by t.nrDivida, t.nrAnoDivida;
