select case when (tcrt.tributavel = 'S') then 1 else 2 end as idTipoNaturezaCredito,
       trt.classificacaoreceitatipo                        as idTipoCredito,
       2                                                   as idTipoOperacaoCredito,
       tdp.datadividaativa                                 as dtInscricao,
       tcii.valor                                          as vlInscricao,
       tcii.iddebitoparcelareceita                         as idDebitoParcelaTributoOrigem,
       tcii.iddebitoparcelareceita                         as idDebitoParcelaTributoDestino,
       td.formacorrecao,
       tdp.exercicio as nrAnoBase,
       ca.idTce as cdControleLeiAto,
       0 as nrCredito,
       0 as nrAnoCredito
from TCECONTROLEIMPLANTACAO tci
         join tceControleImplantacaoItem tcii
              on tci.id = tcii.IDCONTROLE
         join tribdebitoparcelareceita tdpr
              on tdpr.iddebitoparcelareceita = tcii.iddebitoparcelareceita
         join tribdebitoparcela tdp
              on tdp.entidade = tdpr.entidade
                  and tdp.exercicio = tdpr.exercicio
                  and tdp.tipocadastro = tdpr.tipocadastro
                  and tdp.cadastrogeral = tdpr.cadastrogeral
                  and tdp.guiarecolhimento = tdpr.guiarecolhimento
                  and tdp.subdivida = tdpr.subdivida
                  and tdp.parcela = tdpr.parcela
         join tribdebito td
              on td.entidade = tdp.entidade
                  and td.exercicio = tdp.exercicio
                  and td.tipocadastro = tdp.tipocadastro
                  and td.cadastrogeral = tdp.cadastrogeral
                  and td.guiarecolhimento = tdp.guiarecolhimento
                  and td.subdivida = tdp.subdivida
         join tribreceita tr
              on tr.receita = tdpr.receita and tr.exercicio = :exercicio and tr.entidade = :entidade
         join tribreceitatipo trt
              on trt.tiporeceita = tr.tiporeceita
         join tribclassificacaoreceitatipo tcrt
              on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
         join tribguiarecolhimento tgr
              on tgr.entidade = td.entidade
                  and tgr.exercicio = td.exercicio
                  and tgr.guiarecolhimento = td.guiarecolhimento
    left join cgato ca on ca.entidade = tgr.entidade and ca.idato = tgr.fundamentolegal
where tcii.situacaolegal in (1, 2)
  and tcii.IDCONTROLE = :idControle
  and tci.entidade = :entidade
  and tci.EXERCICIO = :exercicio
  and trt.classificacaoreceitatipo in (1,2,3,4,5,7)
  and not exists(
        select 1
        from tceDebitoInscCreditoDA tdicDA
        where tdicDA.iddebitoparcelareceitaorigem = tdpr.iddebitoparcelareceita
    )
order by tdp.datadividaativa,
         idTipoNaturezaCredito,
         trt.classificacaoreceitatipo,
         tdpr.iddebitoparcelareceita,
         tdp.exercicio,
         ca.idtce;