select tic.nrDivida,
       tic.nrAnoDivida,
       tmd.idato as idAto,
       te.dataestorno                     as dtEstorno,
       max(substr(tmd.descricao, 0, 250)) as dsMotivo,
       tlepr.iddebitoparcelareceita,
       sum(tic.vlEstorno)                 as vlEstorno
from triblivroestornoparcelareceita tlepr
         join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tlepr.iddebitoparcelareceita
         join triblivroparcelareceita tlpr on tlpr.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
         join triblivroestorno te on te.idlivroestorno = tlepr.idlivroestorno
         join (select max(tic.nrdivida)    as nrdivida,
                      max(tic.nranodivida) as nranodivida,
                      sum(tdic.valor)      as vlEstorno,
                      tdic.iddebitoparcelareceitaorigem
               from tceDebitoInscCreditoDA tdic
                        join tceInscCreditoDA tic on tic.idtceinsccreditoda = tdic.idtceinsccreditoda
               group by tdic.iddebitoparcelareceitaorigem) tic
              on tic.iddebitoparcelareceitaorigem = tlepr.iddebitoparcelareceita
         join tribreceita tr on tr.entidade = tdpr.entidade and tr.exercicio = tdpr.exercicio and tr.receita = tdpr.receita
         join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
         join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
         left join tribmotivodesconto tmd on tmd.motivodesconto = tlepr.motivocancelamento
where trt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
  and te.dataestorno between :dataInicial and :dataFinal
  and tlepr.entidade = :entidade
  and tlpr.estornado = 'S'
  and not exists(
        select 1 from tceDebitoInscCreditoDAEst tdic where tdic.iddebitoparcelareceita = tlepr.iddebitoparcelareceita)
group by tic.nrDivida, tic.nrAnoDivida, tmd.idato, te.dataestorno, tlepr.iddebitoparcelareceita
order by te.dataestorno, tic.nrdivida, tic.nranodivida, tmd.idato