select filtro.nrDeducao,
                  filtro.nrAnoDeducao,
                  filtro.idAto,
                  filtro.dtEstorno,
                  filtro.vlEstorno,
                  filtro.dsMotivo,
                  filtro.idCancelamento,
                  filtro.entidade,
                  filtro.exercicio,
                  filtro.idpagamentobloqueto,
                  filtro.idcreditocontribuinteitem,
                  filtro.iddebitoparcelareceita
            from
            (
              select distinct
                     md.idato,
                     tc.nrdeducao as nrDeducao,
                     tc.nranodeducao as nrAnoDeducao,
                     tcdi.dataestorno as dtEstorno,
                     tcdi.valor as vlEstorno,
                     substr(md.descricao || '.' || coalesce(cd.motivo, ''), 0, 250) as dsMotivo,
            	         cd.idcancelamento,
            	         cd.entidade,
            	         cd.exercicio,
            	         0 as idpagamentobloqueto,
            	         0 as idcreditocontribuinteitem,
            	         tcdi.iddebitoparcelareceita
              from tribcancelamentodebito          cd
                   join tribcancelamentodebitoitem tcdi on tcdi.entidade = cd.entidade and tcdi.exercicio = cd.exercicio and tcdi.idcancelamento = cd.idcancelamento
                   join tceDeducaoCancelamentoDA   tdc  on tdc.entidade = tcdi.entidade and tdc.exercicio = tcdi.exercicio
                                                       and tdc.idcancelamento = tcdi.idcancelamento and tdc.iddebitoparcelareceita = tcdi.iddebitoparcelareceita
                   join tceDeducaoCreditoDA        tc   on tc.idtcededucaocreditoDA = tdc.idtcededucaocreditoDA
              left join tribmotivodesconto         md   on md.motivodesconto  = cd.motivocancelamento
              where cd.entidade = :entidade
                and tcdi.dataestorno between :dataInicial and :dataFinal
                and tcdi.estornado = 'S'
                and not exists (
                    select 1
                    from tceDeducaoCancelamentoDAEst tdc
                    where tdc.entidade = tcdi.entidade
                      and tdc.exercicio = tcdi.exercicio
                      and tdc.idcancelamento = tcdi.idcancelamento
                      and tdc.iddebitoparcelareceita = tcdi.iddebitoparcelareceita
                )
              union all
              select distinct
                     md.idato,
                     tc.nrdeducao as nrDeducao,
                     tc.nranodeducao as nrAnoDeducao,
                     tep.data as dtEstorno,
                     tpd.valordesconto as vlEstorno,
                     substr(md.descricao, 0, 250) as dsMotivo,
            	         0 as idcancelamento,
            	         0 as entidade,
            	         0 as exercicio,
            	         tepi.idpagamentobloqueto,
            	         0 as idcreditocontribuinteitem,
            	         tepi.iddebitoparcelareceita
                from tribpagamentodebito           tpd
                     join tribEstornoPagamentoItem tepi on tepi.idpagamentobloqueto = tpd.idPagamentoBloqueto and tepi.iddebitoparcelareceita = tpd.iddebitoparcelareceita
                     join tribestornopagamento     tep  on tep.entidade = tepi.entidade and tep.exercicio = tepi.exercicio and tep.estorno = tepi.estorno
                     join tcededucaopagamentoDA    tdp  on tpd.idpagamentobloqueto = tpd.idpagamentobloqueto and tdp.iddebitoparcelareceita = tpd.iddebitoparcelareceita
                     join tceDeducaoCreditoDA      tc   on tc.idtcededucaocreditoDA = tdp.idtcededucaocreditoDA
                left join tribmotivodesconto       md   on md.motivodesconto = tep.motivodesconto
                where tep.data between :dataInicial and :dataFinal
                and tep.entidade = :entidade
                and not exists (
                    select 1
                    from tceDeducaoPagamentoDAEst tdp
                    where tdp.iddebitoparcelareceita = tpd.iddebitoparcelareceita
                      and tdp.idPagamentoBloqueto = tpd.idPagamentoBloqueto
                )
                union all
                select distinct
                       md.idato,
                       tc.nrdeducao as nrDeducao,
                       tc.nranodeducao as nrAnoDeducao,
                       tcc.dataestorno as dtEstorno,
                       tcci.valordesconto as vlEstorno,
                       substr(md.descricao || '.' || coalesce(tcc.observacaoestorno, ''), 0, 250) as dsMotivo,
            		         0 as idcancelamento,
            		         0 as entidade,
            		         0 as exercicio,
            		         0 as idpagamentobloqueto,
            		         tdcc.idcreditocontribuinteitem,
            		         tdcc.iddebitoparcelareceita
                from tribcreditocontribuinte          tcc
                     join tribcreditocontribuinteitem tcci on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and tcci.creditocontribuinte = tcc.creditocontribuinte
                     join tceDeducaoCreditoCreditoDA  tdcc on tdcc.idCreditoContribuinteItem = tcci.idCreditoContribuinteItem and tdcc.idDebitoParcelaReceita = tcci.idDebitoParcelaReceita
                     join tceDeducaoCreditoDA         tc   on tc.idtcededucaocreditoDA = tdcc.idtcededucaocreditoDA
                left join tribmotivodesconto          md   on md.motivodesconto = tcc.motivodescontoestorno
                where tcc.dataestorno between :dataInicial and :dataFinal
                  and tcc.entidade = :entidade
                  and tcc.valorestornado > 0
                  and tcci.valordesconto > 0
                  and not exists (
                    select 1
                    from tceDeducaoCreditoCreditoDAEst tdcc
                    where tdcc.idCreditoContribuinteItem = tcci.idcreditocontribuinteitem
                      and tdcc.idDebitoParcelaReceita = tcci.idDebitoParcelaReceita
                  )
            ) filtro
            order by filtro.dtEstorno,
                    filtro.nrDeducao,
                    filtro.nrAnoDeducao,
                  	filtro.idAto
