select a.idtcededucaocreditoest as id,
       a.nrdeducao,
       a.nranodeducao,
       tlc.nranocredito,
       tlc.nrcredito,
       ca.idtce as cdControleLeiAto,
       a.dtestorno,
       case
           when count(distinct md.motivodesconto) > 1 then 'Motivos: ' || string_agg(cast(md.motivodesconto as varchar),',')
           else string_agg(substr(md.descricao || '. ' || coalesce(cd.motivo, ''), 0, 250),',')
           end as dsMotivo,
       sum(coalesce(tcdi.valorAtualizado, tcdi.valor)) as valor
from tcededucaocreditoest a
         join tcededucaocancelamentoest b
              on a.idtcededucaocreditoest = b.idtcededucaocreditoest
         join tribcancelamentodebitoitem tcdi
              on tcdi.entidade = b.entidade
                  and tcdi.exercicio = b.exercicio
                  and tcdi.idcancelamento = b.idcancelamento
                  and tcdi.iddebitoparcelareceita = b.iddebitoparcelareceita
         join tribcancelamentodebito cd
              on cd.entidade = tcdi.entidade
                  and cd.exercicio = tcdi.exercicio
                  and cd.idcancelamento = tcdi.idcancelamento
         left join tribmotivodesconto md
                   on md.motivodesconto = cd.motivocancelamento
         left join tcedebitolanccredito tdlc
                   on b.iddebitoparcelareceita = tdlc.iddebitoparcelareceita
         left join tcelanccredito tlc
                   on tlc.idtcelanccredito = tdlc.idtcelanccredito
         left join cgato ca
                   on ca.entidade = md.entidade
                       and ca.idato = md.idato
where (cd.datacancelamento between :dataInicial and :dataFinal) and cd.entidade = :entidade
group by tlc.nranocredito, tlc.nrcredito, ca.idtce, a.dtestorno,
         a.idtcededucaocreditoest, a.nrdeducao, a.nranodeducao
union all
select a.idtcededucaocreditoest as id,
       a.nrdeducao,
       a.nranodeducao,
       tlc.nranocredito,
       tlc.nrcredito,
       ca.idtce as cdControleLeiAto,
       a.dtestorno,
       case
           when count(distinct tpb.motivodesconto) > 1 then 'Motivos: ' || string_agg(cast(tpb.motivodesconto as varchar),',')
           else string_agg(substr(md.descricao  || '. ' || coalesce(tbad.observacao, ''), 0, 250),',')
           end as dsMotivo,
       sum(tpd.valordesconto) as valor
from tcededucaocreditoest a
         join tcededucaopagamentoest b
              on a.idtcededucaocreditoest = b.idtcededucaocreditoest
         join tribpagamentodebito tpd
              on tpd.idpagamentobloqueto  = b.idpagamentobloqueto
                  and tpd.iddebitoparcelareceita = b.iddebitoparcelareceita
         join tribpagamentobloqueto tpb
              on tpb.idpagamentobloqueto  = tpd.idpagamentobloqueto
         join tribpagamento tp
              on tp.entidade = tpb.entidade
                  and tp.exerciciopagamento = tpb.exerciciopagamento
                  and tp.pagamento = tpb.pagamento
         left join tribbaixaautomaticadetalhe tbad
                   on tbad.entidade = tp.entidade
                       and tbad.exerciciopagamento = tp.exerciciopagamento
                       and tbad.pagamento = tp.pagamento
         left join tribmotivodesconto md
                   on md.motivodesconto = tpb.motivodesconto
         left join tcedebitolanccredito tdlc
                   on tdlc.iddebitoparcelareceita = b.iddebitoparcelareceita
         left join tcelanccredito tlc
                   on tlc.idtcelanccredito = tdlc.idtcelanccredito
         left join cgato ca
                   on ca.entidade = md.entidade
                       and ca.idato = md.idato
where tp.datalancamento between :dataInicial and :dataFinal and tp.entidade = :entidade
group by tlc.nranocredito, tlc.nrcredito, ca.idtce, a.dtestorno,
         a.idtcededucaocreditoest, a.nrdeducao, a.nranodeducao
union all
select a.idtcededucaocreditoest as id,
       a.nrdeducao,
       a.nranodeducao,
       tlc.nranocredito,
       tlc.nrcredito,
       ca.idtce as cdControleLeiAto,
       a.dtestorno,
       case
           when count(distinct md.motivodesconto) > 1 then 'Motivos: ' || string_agg(distinct cast(md.motivodesconto as varchar),',')
           else string_agg(substr(md.descricao, 0, 250),',')
           end as dsMotivo,
       sum(tcci.valordesconto) as valor
from tcededucaocreditoest a
         join tcededucaocreditocreditoest b
              on a.idtcededucaocreditoest = b.idtcededucaocreditoest
         join tribCreditoContribuinteItem tcci
              on tcci.idcreditocontribuinteitem = b.idcreditocontribuinteitem
                  and tcci.iddebitoparcelareceita = b.iddebitoparcelareceita
         join tribcreditocontribuinte tcc
              on tcci.entidade = tcc.entidade
                  and tcci.exercicio = tcc.exercicio
                  and tcci.creditocontribuinte = tcc.creditocontribuinte
         join tribdebitoparcelareceita tdpr
              on tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita
         join tribbaixaautomaticadetalhe tbad
              on tcc.entidade = tbad.entidade
                  and tcc.exercicio = tbad.exerciciocredito
                  and tcc.creditocontribuinte = tbad.creditocontribuinte
         join tribbloqueto tb
              on tb.entidade = tbad.entidade
                  and tb.exerciciobloqueto = tbad.exerciciobloqueto
                  and tb.bloqueto = tbad.bloqueto
         join tribGuiaRecolhimentoFormaPag tgrfp
              on tgrfp.entidade = tdpr.entidade
                  and tgrfp.exercicio = tdpr.exercicio
                  and tgrfp.guiarecolhimento = tdpr.guiarecolhimento
                  and tgrfp.formapagamento = tb.formapagamento
         left join tribMotivoDesconto md
                   on md.motivodesconto = coalesce(tgrfp.motivodesconto, tb.motivodesconto)
         left join tcedebitolanccredito tdlc
                   on b.iddebitoparcelareceita = tdlc.iddebitoparcelareceita
         left join tcelanccredito tlc
                   on tlc.idtcelanccredito = tdlc.idtcelanccredito
         left join cgato ca
                   on ca.entidade = md.entidade
                       and ca.idato = md.idato
where tcc.entidade = :entidade and tcc.datacredito between :dataInicial and :dataFinal
group by tlc.nranocredito, tlc.nrcredito, ca.idtce, a.dtestorno,
         a.idtcededucaocreditoest, a.nrdeducao, a.nranodeducao
order by 1