select 
       :idPessoa as idPessoa, 
       filtro.nrDeducao, 
       filtro.nrAnoDeducao, 
       filtro.nrCredito, 
       filtro.nrAnoCredito, 
       filtro.idTipoDeducaoCredito, 
       filtro.cdControleLeiAto, 
       filtro.dtDeducao, 
       filtro.vlDeducao, 
       filtro.dsMotivo 
from 
( 
   /*pagamento*/ 
   select distinct 
          tdc.nrDeducao, 
          tdc.nrAnoDeducao, 
          tdc.nrCredito,
          tdc.nrAnoCredito,
          tdc.idTipoDeducaoCredito, 
          tdc.cdControleLeiAto,
          tdc.dtDeducao, 
          tdc.vlDeducao, 
          tdc.dsMotivo 
   from tceDeducaoCredito          tdc 
        join tceDeducaoPagamento        tdpag on tdpag.idtcededucaocredito = tdc.idtcededucaocredito 
        join tribpagamentodebito        tpd   on tpd.iddebitoparcelareceita = tdpag.iddebitoparcelareceita and tpd.idpagamentobloqueto = tdpag.idpagamentobloqueto 
        join tribpagamentobloqueto      tpb   on tpb.idpagamentobloqueto  = tpd.idpagamentobloqueto 
        join tribdebitoparcelareceita   tdpr  on tdpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita 
   left join tcedebitolanccredito       tdlc  on tdlc.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
   left join tribmotivodesconto         tmd   on tmd.motivodesconto = tpb.motivodesconto
   where tdc.dtdeducao between :dataInicial and :dataFinal 
     and tdpr.entidade = :entidade 
   union all 
   /*Cancelamento*/ 
   select distinct 
          tdc.nrDeducao, 
          tdc.nrAnoDeducao, 
          tdc.nrCredito,
          tdc.nrAnoCredito,
          tdc.idTipoDeducaoCredito, 
          tdc.cdControleLeiAto,
          tdc.dtDeducao, 
          tdc.vlDeducao, 
          tdc.dsMotivo 
   from tceDeducaoCredito               tdc 
        join tceDeducaoCancelamento     tdcan on tdcan.idtcededucaocredito = tdc.idtcededucaocredito 
        join tribcancelamentodebitoitem tcdi  on tcdi.entidade = tdcan.entidade and tcdi.exercicio = tdcan.exercicio 
                                             and tcdi.idcancelamento = tdcan.idcancelamento and tcdi.iddebitoparcelareceita = tdcan.iddebitoparcelareceita 
        join tribcancelamentodebito     cd    on cd.entidade = tcdi.entidade and cd.exercicio = tcdi.exercicio and cd.idcancelamento = tcdi.idcancelamento 
   left join tcedebitolanccredito       tdlc  on tdlc.iddebitoparcelareceita = tcdi.iddebitoparcelareceita
   left join tribmotivodesconto         tmd   on tmd.motivodesconto = cd.motivocancelamento
   where tdc.dtdeducao between :dataInicial and :dataFinal 
     and tcdi.entidade = :entidade 
   union all 
   /*isencao*/ 
   select distinct 
          tdc.nrDeducao, 
          tdc.nrAnoDeducao, 
          tdc.nrCredito,
          tdc.nrAnoCredito,
          tdc.idTipoDeducaoCredito, 
          tdc.cdControleLeiAto,
          tdc.dtDeducao, 
          tdc.vlDeducao, 
          tdc.dsMotivo 
   from tceDeducaoCredito             tdc 
        join tceDeducaoIsencao        tdise on tdise.idtcededucaocredito = tdc.idtcededucaocredito 
        join tribdebitoreceita        tdr   on tdr.iddebitoreceita = tdise.iddebitoreceita 
        join tribdebitoreceitaisencao tdri  on tdri.entidade = tdr.entidade and tdri.exercicio = tdr.exercicio and tdri.tipocadastro = tdr.tipocadastro 
                                           and tdri.cadastrogeral = tdr.cadastrogeral and tdri.guiarecolhimento = tdr.guiarecolhimento 
                                           and tdri.subdivida = tdr.subdivida and tdri.receita = tdr.receita 
        join tribisencao              ti    on ti.isencao = tdri.isencao 
        join tribdebitoparcelareceita tdpr  on tdpr.entidade = tdri.entidade and tdpr.exercicio = tdri.exercicio and tdpr.tipocadastro = tdri.tipocadastro 
                                           and tdpr.cadastrogeral = tdri.cadastrogeral and tdpr.guiarecolhimento = tdri.guiarecolhimento 
                                           and tdpr.subdivida = tdri.subdivida and tdpr.receita = tdri.receita 
   left join tcedebitolanccredito     tdlc  on tdlc.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
   where tdc.dtdeducao between :dataInicial and :dataFinal 
     and tdpr.entidade = :entidade 
   union all 
   /*Credito*/ 
   select distinct 
          tdc.nrDeducao, 
          tdc.nrAnoDeducao, 
          tdc.nrCredito,
          tdc.nrAnoCredito,
          tdc.idTipoDeducaoCredito, 
          tdc.cdControleLeiAto,
          tdc.dtDeducao, 
          tdc.vlDeducao, 
          tdc.dsMotivo 
   from tceDeducaoCredito                 tdc 
        join tceDeducaoCreditoCredito     tcred on tcred.idTceDeducaoCredito = tdc.idTceDeducaoCredito 
        join tribcreditocontribuinteitem  tcci  on tcci.idcreditocontribuinteitem = tcred.idcreditocontribuinteitem and tcci.iddebitoparcelareceita = tcred.iddebitoparcelareceita 
        join tribcreditocontribuinte      tcc   on tcc.entidade = tcci.entidade and tcc.exercicio = tcci.exercicio and tcc.creditocontribuinte = tcci.creditocontribuinte 
        join tribbaixaautomaticadetalhe   tbad  on tbad.entidade = tcc.entidade and tbad.exerciciocredito = tcc.exercicio and tbad.creditocontribuinte = tcc.creditocontribuinte 
        join tribdebitoparcelareceita     tdpr  on tdpr.iddebitoparcelareceita  = tcci.iddebitoparcelareceita 
        join tribbloqueto                 tb    on tb.entidade = tbad.entidade and tb.exerciciobloqueto = tbad.exerciciobloqueto and tb.bloqueto = tbad.bloqueto 
        join tribGuiaRecolhimentoFormaPag tgrfp on tgrfp.entidade = tdpr.entidade and tgrfp.exercicio = tdpr.exercicio and tgrfp.guiarecolhimento = tdpr.guiarecolhimento and tgrfp.formapagamento = tb.formapagamento 
   left join tcedebitolanccredito         tdlc  on tdlc.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
   left join tribMotivoDesconto           tmd   on tmd.motivodesconto = coalesce( tgrfp.motivodesconto, tb.motivodesconto )
   where tdc.dtdeducao between :dataInicial and :dataFinal 
     and tcci.entidade = :entidade 
) filtro 
order by filtro.nrDeducao, filtro.nrAnoDeducao;