SELECT :idPessoa as idPessoa,
       filtro.nrDeducao,
       filtro.nrAnoDeducao,
       filtro.nrdivida,
       filtro.nrAnoDivida,
       filtro.idTipoDeducaoCredito,
       filtro.cdControleLeiAto,
       filtro.dtDeducao,
       filtro.vlDeducao,
       filtro.dsMotivo
FROM
  (SELECT DISTINCT tdc.nrDeducao,
                   tdc.nrAnoDeducao,
                   tdc.nrdivida,
                   tdc.nrAnoDivida,
                   tdc.idTipoDeducaoCredito,
                   tdc.cdControleLeiAto,
                   tdc.dtDeducao,
                   tdc.vlDeducao,
                   tdc.dsMotivo
   FROM tceDeducaoCreditoDA tdc
   JOIN tceDeducaoPagamentoDa tdpag ON tdpag.idtcededucaocreditoDa = tdc.idtcededucaocreditoDA
   JOIN tribpagamentodebito tpd ON tpd.iddebitoparcelareceita = tdpag.iddebitoparcelareceita
   AND tpd.idpagamentobloqueto = tdpag.idpagamentobloqueto
   JOIN tribpagamentobloqueto tpb ON tpb.idpagamentobloqueto = tpd.idpagamentobloqueto
   JOIN tribdebitoparcelareceita tdpr ON tdpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita
   LEFT JOIN tcedebitoinsccreditoda tdic ON tdic.iddebitoparcelareceitaDestino = tdpr.iddebitoparcelareceita
   LEFT JOIN tribmotivodesconto tmd ON tmd.motivodesconto = tpb.motivodesconto
   WHERE tdc.dtdeducao BETWEEN :dataInicial AND :dataFinal
     AND tdpr.entidade = :entidade
   UNION ALL SELECT DISTINCT tdc.nrDeducao,
                             tdc.nrAnoDeducao,
                             tdc.nrdivida,
                             tdc.nrAnoDivida,
                             tdc.idTipoDeducaoCredito,
                             tdc.cdControleLeiAto,
                             tdc.dtDeducao,
                             tdc.vlDeducao,
                             tdc.dsMotivo
   FROM tceDeducaoCreditoDA tdc
   JOIN tceDeducaoCancelamentoDA tdcan ON tdcan.idtcededucaocreditoDA = tdc.idtcededucaocreditoDA
   JOIN tribcancelamentodebitoitem tcdi ON tcdi.entidade = tdcan.entidade
   AND tcdi.exercicio = tdcan.exercicio
   AND tcdi.idcancelamento = tdcan.idcancelamento
   AND tcdi.iddebitoparcelareceita = tdcan.iddebitoparcelareceita
   JOIN tribcancelamentodebito cd ON cd.entidade = tcdi.entidade
   AND cd.exercicio = tcdi.exercicio
   AND cd.idcancelamento = tcdi.idcancelamento
   JOIN tribdebitoparcelareceita tdpr ON tdpr.iddebitoparcelareceita = tcdi.iddebitoparcelareceita
   LEFT JOIN tcedebitoinsccreditoda tdic ON tdic.iddebitoparcelareceitaDestino = tdpr.iddebitoparcelareceita
   LEFT JOIN tribmotivodesconto tmd ON tmd.motivodesconto = cd.motivocancelamento
   WHERE tdc.dtdeducao BETWEEN :dataInicial AND :dataFinal
     AND tdpr.entidade = :entidade
   UNION ALL SELECT DISTINCT tdc.nrDeducao,
                             tdc.nrAnoDeducao,
                             tdc.nrdivida,
                             tdc.nrAnoDivida,
                             tdc.idTipoDeducaoCredito,
                             tdc.cdControleLeiAto,
                             tdc.dtDeducao,
                             tdc.vlDeducao,
                             tdc.dsMotivo
   FROM tceDeducaoCreditoDA tdc
   JOIN tceDeducaoCreditoCreditoDA tcred ON tcred.idTceDeducaoCreditoDA = tdc.idTceDeducaoCreditoDA
   JOIN tribcreditocontribuinteitem tcci ON tcci.idcreditocontribuinteitem = tcred.idcreditocontribuinteitem
   AND tcci.iddebitoparcelareceita = tcred.iddebitoparcelareceita
   JOIN tribcreditocontribuinte tcc ON tcc.entidade = tcci.entidade
   AND tcc.exercicio = tcci.exercicio
   AND tcc.creditocontribuinte = tcci.creditocontribuinte
   JOIN tribbaixaautomaticadetalhe tbad ON tbad.entidade = tcc.entidade
   AND tbad.exerciciocredito = tcc.exercicio
   AND tbad.creditocontribuinte = tcc.creditocontribuinte
   JOIN tribdebitoparcelareceita tdpr ON tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita
   JOIN tribbloqueto tb ON tb.entidade = tbad.entidade
   AND tb.exerciciobloqueto = tbad.exerciciobloqueto
   AND tb.bloqueto = tbad.bloqueto
   JOIN tribGuiaRecolhimentoFormaPag tgrfp ON tgrfp.entidade = tdpr.entidade
   AND tgrfp.exercicio = tdpr.exercicio
   AND tgrfp.guiarecolhimento = tdpr.guiarecolhimento
   AND tgrfp.formapagamento = tb.formapagamento
   LEFT JOIN tcedebitoinsccreditoda tdic ON tdic.iddebitoparcelareceitaDestino = tdpr.iddebitoparcelareceita
   LEFT JOIN tribMotivoDesconto tmd ON tmd.motivodesconto = coalesce(tgrfp.motivodesconto, tb.motivodesconto)
   WHERE tdc.dtdeducao BETWEEN :dataInicial AND :dataFinal
     AND tcci.entidade = :entidade ) filtro
ORDER BY filtro.nrDeducao,
         filtro.nrAnoDeducao