select 02                                  as codigoArquivo,
       'Estorno de Lançamento de Créditos' as arquivo,
       'DEBITO'                            as tipoArquivo,
       sum(coalesce(arquivo.valor, 0))     as valorArquivo,
       sum(coalesce(integracao.valor, 0))  as valorIntegrado
from (select coalesce(sum(tlce.vlestorno), 0) as valor
            from tcelanccreditoest tlce
             where tlce.dtestorno between :dataInicial and :dataFinal) as arquivo
         cross join (select sum(iip.valor) as valor
                     from integracaopatrimonial ip
                              left join itemintegracaopatrimonial iip on ip.id = iip.idintegracaopatrimonial
                              left join tribreceita r
                                        on r.receita = iip.tributo and r.exercicio = ip.exercicio and
                                           r.entidade = ip.entidade
                              JOIN tribreceitatipo trt
                                   ON trt.tiporeceita = r.tiporeceita
                     where ip.entidade = :entidade
                       and trt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
                       and ip.datamovimento between :dataInicial and :dataFinal
                       and iip.tipomovimento = 'CANCELAMENTO'
                       and iip.situacaolegal = 0
                       and iip.tipodeducao = 8
                       and ip.situacaointegracaopatrimonial != 'ESTORNADO_CONTABILIDADE') as integracao