select distinct
       :idPessoa AS idPessoa,
       atc.nrArrecadacao,
       atc.nrAnoArrecadacao,
       atc.idTipoOrigemReceita,
       case when (coalesce(tpd.situacaolegal, tdp.situacaolegal) = 0) then atc.nrcredito else null end as nrCredito,
       case when (coalesce(tpd.situacaolegal, tdp.situacaolegal) = 0) then atc.nranocredito else null end as nranocredito,
       case when (coalesce(tpd.situacaolegal, tdp.situacaolegal) = 1) then atc.nrdivida else null end as nrdivida,
       case when (coalesce(tpd.situacaolegal, tdp.situacaolegal) = 1) then atc.nranodivida else null end as nranodivida,
       atc.idTipoArrecadacao,
       atc.nrMes,
       atc.nrAno,
       atc.vlArrecadacao
from tceArrecadacaoTipoCredito          atc
left join tceArrTipoCreditoPagamento    atcp on atcp.idtcearrtipocredito = atc.idtcearrtipocredito
left join tribpagamentodebito           tpd  on tpd.iddebitoparcelareceita = atcp.iddebitoparcelareceita and tpd.idpagamentobloqueto = atcp.idpagamentobloqueto
left join tribpagamentobloqueto         tpb  on tpb.idpagamentobloqueto  = tpd.idpagamentobloqueto
left join tribpagamento                 tpag on tpag.entidade = tpb.entidade and tpag.exerciciopagamento = tpb.exerciciopagamento and tpag.pagamento = tpb.pagamento
left join tceArrTipoCreditoCredito      atcc on atcc.idtcearrtipocredito = atc.idtcearrtipocredito
left join tribCreditoContribuinteItem   tcci on tcci.idcreditocontribuinteitem = atcc.idcreditocontribuinteitem and tcci.iddebitoparcelareceita = atcc.iddebitoparcelareceita
left join tribcreditocontribuinte       tcc  on tcc.entidade = tcci.entidade and tcc.exercicio = tcci.exercicio and tcc.creditocontribuinte = tcci.creditocontribuinte
left join tribdebitoparcelareceita      tdpr on tdpr.iddebitoparcelareceita  = tcci.iddebitoparcelareceita
left join tribdebitoparcela             tdp  on tdp.entidade = tdpr.entidade and tdp.exercicio = tdpr.exercicio and tdp.tipocadastro = tdpr.tipocadastro
                                            and tdp.cadastrogeral = tdpr.cadastrogeral and tdp.guiarecolhimento = tdpr.guiarecolhimento
                                            and tdp.subdivida = tdpr.subdivida and tdp.parcela = tdpr.parcela
left join tcedebitolanccredito          tdlc on tdlc.iddebitoparcelareceita = coalesce( atcp.iddebitoparcelareceita, atcc.iddebitoparcelareceita )
left join tcedebitoinsccreditoda        tdic on tdic.iddebitoparcelareceitaDestino = coalesce( atcp.iddebitoparcelareceita, atcc.iddebitoparcelareceita )
where coalesce(tpag.datacredito, tcc.datacredito) BETWEEN :dataInicial AND :dataFinal
  and coalesce(tpag.entidade, tcc.entidade) = :entidade
order by atc.nrArrecadacao, atc.nrAnoArrecadacao