SELECT DISTINCT
  TCM.TIPOCADASTRO,
  TCM.CADASTROGERAL,
  TCG.EXCLUSAOLOGICA,
  TCG.CEP,
  TCG.COMPLEMENTO,
  P.RG,
  P.INSCRICAOESTADUAL,
  TCM.TELEFONE,
  TMS.LISTASERVICO,  
  TCM.AREAUTILIZADA,
  TCM.DATAABERTURA,
  TCM.DATAVALIDADEALVARA,
  TCM.DATAENCERRAMENTO,
  TCM.DATAALVARA,
  TCM.AREABOMBEIRO,
  TCM.TIPOCADASTROIMOBILIARIO,
  TCM.CADASTROGERALIMOBILIARIO,
  TCM.EXERCICIOALVARA,
  TCM.NUMEROALVARA,
  TCM.QTDEFUNCIONARIO,
  TCM.CMCRESPONSAVEL,
  TCM.OBSERVACAOALVARA,
  TCM.AREAPUBLICIDADE1,
  TCM.AREAPUBLICIDADE2,
  TCM.DATAAUDITORIAINICIO,
  TCM.DATAAUDITORIAFIM,
  TCM.DATAHOMOLOGACAO,
  TCM.PESSOAMOBILIARIO,
  TCM.LAUDO,
  TCM.EXERCICIOLAUDO,
  TPM.DESCRICAO,
  TCM.ATIVIDADEPRINCIPAL,
  P.PESSOA,
  P.TIPOPESSOA,
  P.NOME PROPRIETARIO_DESCR,
  P.NOMEFANTASIA,
  P.CNPJ_CPF,
  L.LOGRADOURO||' - '||TLOG.DESCRICAO ||' '|| L.DESCRICAO ||', '|| TCG.NUMERO DESCLOGRADOURO,
  EP.COMPLEMENTO,
  EP.CEP,
  TCG.NUMERO,
  TCI.SETOR_INSCRICAOCADASTRAL,
  TCI.QUADRA_DESCR,
  TCI.LOTE_INSCRICAOCADASTRAL,
  CP.TELEFONECOMERCIAL,
  TMSIT.SITUACAOMOBILIARIO,
  TSM.DESCRICAO SITUACAOMOBILIARIO_DESCR,
  TD.EXERCICIOPROCESSO EXERCPROTOCALVARA,
  TD.IDPROCESSO,
  PTC.PROCESSO,
  PTC.DATAPROCESSO,
  TCG.VISTORIADO,
  TNF.NOTIFICACAO,
  TNF.EXERCICIO,
  TF.FISCAL,
  TF.NOME,
  SA.NUMEROSOLICITACAO,
  SA.EXERCICIO AS ANOSOLICITACAO
FROM TRIBCADASTROMOBILIARIO TCM 
LEFT OUTER JOIN TRIBCADASTROGERAL TCG 
    ON TCG.TIPOCADASTRO = TCM.TIPOCADASTRO 
    AND TCG.CADASTROGERAL = TCM.CADASTROGERAL 
LEFT OUTER JOIN LOGRADOURO L 
    ON TCG.CIDADE = L.CIDADE 
    AND TCG.LOGRADOURO = L.LOGRADOURO 
LEFT OUTER JOIN TIPOLOGRADOURO TLOG 
    ON TLOG.TIPOLOGRADOURO = L.TIPOLOGRADOURO 
LEFT OUTER JOIN PESSOA P 
    ON P.PESSOA = TCG.PESSOA 
LEFT OUTER JOIN ENDERECOPESSOA EP 
    ON EP.PESSOA = P.PESSOA 
    AND EP.SEQUENCIA = P.SEQUENCIAENDERECO 
LEFT OUTER JOIN CONTATOPESSOA CP 
    ON CP.PESSOA = P.PESSOA 
    AND CP.SEQUENCIA = P.SEQUENCIACONTATO 
LEFT OUTER JOIN TRIBCADASTROIMOBILIARIO TCI 
    ON TCI.TIPOCADASTRO = TCM.TIPOCADASTROIMOBILIARIO 
    AND TCI.CADASTROGERAL = TCM.CADASTROGERALIMOBILIARIO 
LEFT OUTER JOIN TRIBMOBILIARIOSITUACAO TMSIT 
    ON TMSIT.TIPOCADASTRO = TCM.TIPOCADASTRO 
    AND TMSIT.CADASTROGERAL = TCM.CADASTROGERAL 
    AND TMSIT.ATUAL = 'S' 
LEFT OUTER JOIN TRIBSITUACAOMOBILIARIO TSM 
    ON TSM.SITUACAOMOBILIARIO = TMSIT.SITUACAOMOBILIARIO 
LEFT OUTER JOIN TRIBDOCUMENTO TD 
    ON TD.ENTIDADE = 1 
    AND TD.EXERCICIO = TCM.EXERCICIOALVARA 
    AND TD.TIPODOCUMENTO = 8 
    AND TD.DOCUMENTO = TCM.NUMEROALVARA 
LEFT OUTER JOIN PTCPROCESSO PTC 
    ON PTC.ENTIDADE = TCM.ENTIDADE 
    AND PTC.EXERCICIO = TCM.EXERCPROCESSOABERTURA 
    AND PTC.IDPROCESSO = TCM.IDPROCESSOABERTURA 
LEFT OUTER JOIN TRIBPESSOAMOBILIARIO TPM 
    ON TPM.PESSOAMOBILIARIO = TCM.PESSOAMOBILIARIO 
LEFT OUTER JOIN TRIBNOTIFICACAOFISCALIZACAO TNF 
    ON TNF.IDNOTIFICACAOFISCALIZACAO = TCM.IDNOTIFICACAOFISCALIZACAO 
LEFT OUTER JOIN TRIBFISCAL TF 
    ON TF.FISCAL = TNF.FISCAL 
    AND TF.TIPOFISCAL = TNF.TIPOFISCAL 
LEFT OUTER JOIN TRIBMOBILIARIOATIVIDADE TMAT
    ON TMAT.TIPOCADASTRO = TCM.TIPOCADASTRO 
    AND TMAT.CADASTROGERAL = TCM.CADASTROGERAL 
LEFT OUTER JOIN TRIBMOBILIARIOLISTASERVICO TMS
     ON  TMS.TIPOCADASTRO = TCM.TIPOCADASTRO
     AND TMS.CADASTROGERAL = TCM.CADASTROGERAL
LEFT OUTER JOIN TRIBCADASTROGERALISENCAO TCGI
     ON TCGI.TIPOCADASTRO = TCM.TIPOCADASTRO
     AND TCGI.CADASTROGERAL = TCM.CADASTROGERAL
LEFT OUTER JOIN TRIBISENCAO ISEN
     ON ISEN.ISENCAO = TCGI.ISENCAO
LEFT OUTER JOIN (SELECT X.TIPOCADASTROMOBILIARIO, X.CADASTROGERALMOBILIARIO, X.NUMEROSOLICITACAO, X.EXERCICIO
FROM TRIBSOLICITACAOALVARA X
WHERE X.NUMEROSOLICITACAO = (SELECT MAX(Y.NUMEROSOLICITACAO)
                             FROM TRIBSOLICITACAOALVARA Y
                             WHERE Y.TIPOCADASTROMOBILIARIO = X.TIPOCADASTROMOBILIARIO
                             AND Y.CADASTROGERALMOBILIARIO = X.CADASTROGERALMOBILIARIO)) SA
ON TCM.TIPOCADASTRO = SA.TIPOCADASTROMOBILIARIO
AND TCM.CADASTROGERAL = SA.CADASTROGERALMOBILIARIO
WHERE TCM.TIPOCADASTRO = :tipoCadastro
AND TCM.CADASTROGERAL = :cadastroGeral