SELECT TP.PAGAMENTO,
       TP.EXERCICIOPAGAMENTO,
       TP.LOTE,
       TP.EXERCICIOLOTE,
       TPB.EXERCICIOBLOQUETO AS EXERCICIOBOLETO,
       TB.IDKEY AS IDBOLETO,
       TPB.BLOQUETO AS BOLETO,
       TP.SEQUENCIAARQUIVO,
       TP.LOTEPREF,
       TP.SEQUENCIAPREF,
       TP.DATAPAGAMENTO,
       TP.DATALANCAMENTO,
       TPL.DATAMOVIMENTO,
       SUM(TDPR.VALOR) AS VALORPARCELA,
       SUM(TPD.VALORPAGO) AS VALORPAGO,
       SUM(TPD.VALORCALCULADO) AS VALORCALCULADO,
       SUM(TPD.VALORDEVOLVIDO) AS VALORDEVOLVIDO,
       CASE
         WHEN TEP.ESTORNO IS NULL THEN
          cast('N' as varchar(10))
         ELSE
          cast('S' as varchar(10))
       END ESTORNADO
  FROM TRIBDEBITOPARCELARECEITA TDPR
  INNER JOIN TRIBPAGAMENTODEBITO TPD ON TPD.IDDEBITOPARCELARECEITA = TDPR.IDDEBITOPARCELARECEITA
  INNER JOIN TRIBPAGAMENTOBLOQUETO TPB ON TPB.IDPAGAMENTOBLOQUETO = TPD.IDPAGAMENTOBLOQUETO
  INNER JOIN TRIBBLOQUETO TB ON TB.ENTIDADE = TPB.entidade
                                 AND TB.EXERCICIOBLOQUETO = TPB.EXERCICIOBLOQUETO
                                 AND TB.BLOQUETO = TPB.BLOQUETO
  INNER JOIN TRIBPAGAMENTO TP ON TPB.ENTIDADE = TP.ENTIDADE
                                  AND TPB.EXERCICIOPAGAMENTO = TP.EXERCICIOPAGAMENTO
                                  AND TPB.PAGAMENTO = TP.PAGAMENTO
  INNER JOIN TRIBPAGAMENTOLOTE TPL ON TPL.ENTIDADE = TP.ENTIDADE
                                       AND TPL.EXERCICIO = TP.EXERCICIOLOTE
                                       AND TPL.LOTE = TP.LOTE
  LEFT OUTER JOIN TRIBESTORNOPAGAMENTO TEP ON TEP.ENTIDADE = TP.ENTIDADE
                                          AND TEP.EXERCICIOPAGAMENTO = TP.EXERCICIOPAGAMENTO
                                          AND TEP.PAGAMENTO = TP.PAGAMENTO
                                          AND TEP.REABILITADO = 'N'
 WHERE TDPR.ENTIDADE = :entidade
   AND TDPR.EXERCICIO = :exercicio
   AND TDPR.TIPOCADASTRO = :tipoCadastro
   AND TDPR.CADASTROGERAL = :cadastroGeral
   AND TDPR.GUIARECOLHIMENTO = :divida
   AND TDPR.SUBDIVIDA = :subDivida
   AND TDPR.PARCELA = :parcela
 GROUP BY TP.PAGAMENTO,
          TP.EXERCICIOPAGAMENTO,
          TP.LOTE,
          TP.EXERCICIOLOTE,
          TPB.EXERCICIOBLOQUETO,
          TB.IDKEY,
          TPB.BLOQUETO,
          TP.SEQUENCIAARQUIVO,
          TP.LOTEPREF,
          TP.SEQUENCIAPREF,
          TP.DATAPAGAMENTO,
          TP.DATALANCAMENTO,
          TPL.DATAMOVIMENTO,
          CASE
            WHEN TEP.ESTORNO IS NULL THEN
             cast('N' as varchar(10))
            ELSE
             cast('S' as varchar(10))
          END
 ORDER BY TP.EXERCICIOPAGAMENTO, TP.PAGAMENTO
