CREATE OR REPLACE VIEW TRIBVIEWBOLETIMMOBILIARIO AS Select a.TipoCadastro,
       a.CadastroGeral,
       cg.exclusaologica as exclusaologica_s_n,
       a.Modelo,
       a.ModeloGrupo,
       a.ModeloCampo,
       a.ModeloResposta,
       tmc.descricao,
       case when tmc.TipoCampo in ('N','T','D') then a.DescricaoResposta
            else b.Descricao
       end  as Resposta
  from TribBoletimMobiliario a
left outer join TribModeloResposta b
        on a.Modelo = b.Modelo and
           a.ModeloGrupo = b.ModeloGrupo and
           a.ModeloCampo = b.ModeloCampo and
           a.ModeloResposta = b.ModeloResposta
left outer join TribModeloCampo tmc
        on a.Modelo = tmc.Modelo and
           a.ModeloGrupo = tmc.ModeloGrupo and
           a.ModeloCampo = tmc.ModeloCampo
left outer join tribcadastrogeral cg
        on a.tipocadastro = cg.tipocadastro and
           a.cadastrogeral = cg.cadastrogeral;