CREATE OR REPLACE VIEW ENDERECOCADASTROGERAL
(TIPOCADASTRO,CADASTROGERAL,PESSOA,CEP,CIDADE,UNIDADEFEDERACAO,NUMERO,CODLOG,TIPOLOGRADOURO,LOGRADOURO,BAIRRO,LOTEAMENTO,COMPLEMENTO,COMPLEMENTOLOTE,SETOR,QUADRA,LOTE,PESSOANOME,PESSOACNPJ_CPF,PESSOATIPOENDERECO,PESSOACEP,PESSOACIDADE,PESSOAUNIDADEFEDERACAO,PESSOANUMERO,PESSOATIPOLOGRADOURO,PESSOALOGRADOURO,PESSOABAIRRO,PESSOACOMPLEMENTO,ENDERECOCOMPLETO)
AS
select cad.tipocadastro,
       cad.cadastrogeral,
       cad.pessoa,
       cad.cep,
       cid.descricao as cidade,
       cid.unidadefederacao,
       cad.numero,
       log.logradouro as codlog,
       tipolog.sigla as tipologradouro,
       log.descricao as logradouro,
       bai.descricao as bairro,
       lote.descricao as Loteamento,
       cad.complemento,
       imob.complementolote,
       imob.Setor_InscricaoCadastral as Setor,
       imob.Quadra_InscricaoCadastral as Quadra,
       imob.Lote_InscricaoCadastral as Lote,
       pes.nome as pessoanome,
       pes.cnpj_cpf as pessoacnpj_cpf,
       pend.tipoendereco as pessoaTipoEndereco,
       pend.cep as pessoacep,
       pcid.descricao as pessoacidade,
       pcid.unidadefederacao as pessoaunidadefederacao,
       pend.numero as pessoanumero,
       ptipolog.sigla as pessoatipologradouro,
       plog.descricao as pessoalogradouro,
       pbai.descricao as pessoabairro,
       pend.complemento as pessoacomplemento,
       tipolog.descricao || ' ' || log.descricao || ', ' ||
       cad.numero || ', ' || imob.complementolote as enderecocompleto
from tribcadastrogeral cad
left outer join tribcadastroimobiliario imob on
     cad.tipocadastro = imob.tipocadastro
     and cad.cadastrogeral = imob.cadastrogeral
left outer join tribloteamento lote on
     imob.distrito_inscricaoCadastral = lote.distrito
     and imob.setor_inscricaocadastral = lote.setor
     and imob.loteamento = lote.loteamento
left outer join cidade cid on
     cad.cidade = cid.cidade
left outer join logradouro log on
     cad.cidade = log.cidade
     and cad.logradouro = log.logradouro
left outer join bairro bai on
     cad.cidade = bai.cidade
     and cad.bairro = bai.bairro
left outer join tipologradouro tipolog on
     log.tipologradouro = tipolog.tipologradouro
left outer join pessoa pes on
     cad.pessoa = pes.pessoa
left outer join enderecopessoa pend on
     pes.pessoa = pend.pessoa
     and pes.sequenciaendereco = pend.sequencia
left outer join cidade pcid on
     pend.cidade = pcid.cidade
left outer join logradouro plog on
     pend.cidade = plog.cidade
     and pend.logradouro = plog.logradouro
left outer join bairro pbai on
     pend.cidade = pbai.cidade
     and pend.bairro = pbai.bairro
left outer join tipologradouro ptipolog on
     plog.tipologradouro = ptipolog.tipologradouro