 Select cg.tipoCadastro,
        cg.cadastroGeral,
        cg.idkey as idCadastro,
        p.cnpj_cpf as cpfCnpj,
        case when p.tipopessoa = 'J' 
             then 'Jurídica'
             else 'Física'
        end as tipoPessoa,
        p.nome,
        p.pessoa,
        'SOCIO' as vinculoDescricao,
        0 as principal,
        tl.descricao as tipoLogradouro,
        lg.descricao as logradouro,
        cg.numero as numero,
        ba.descricao as bairro,
        ci.descricao as cidade,
        ci.unidadefederacao as unidadeFederacao,
        coalesce(tsm.descricao, 'OK') as situacao
   from tribCadastroGeral cg
   inner join pessoa b on cg.pessoa = b.pessoa 
   inner join tribproprietario a on cg.tipocadastro = a.tipocadastro 
                                and cg.cadastrogeral = a.cadastrogeral
   inner join pessoa p on a.pessoa = p.pessoa 
   inner join tribmobiliariosituacao tms on tms.tipocadastro = cg.tipocadastro 
                                        and tms.cadastrogeral = cg.cadastrogeral 
                                        and tms.atual = 'S' 
   inner join tribsituacaomobiliario tsm on tsm.situacaomobiliario = tms.situacaomobiliario
   left outer join logradouro lg on lg.cidade = cg.cidade
                                 and lg.logradouro = cg.logradouro
   left outer join tipologradouro tl on tl.tipologradouro = lg.tipologradouro
   left outer join bairro ba on ba.cidade = cg.cidade
                             and ba.bairro = cg.bairro
   left outer join cidade ci on ci.cidade = cg.cidade
   where a.TipoCadastro = 2 
     and tsm.situacaomobiliario <> 9 
     and cg.ExclusaoLogica = 'N'
     and p.pessoa <> b.pessoa
     and cg.idkey = :idCadastro