
SELECT parcelamentoDebito.idDebito,
    debito.entidade,
    debito.exercicio, 
    debito.tipoCadastro, 
    debito.cadastroGeral, 
    debito.guiaRecolhimento,
    debito.subDivida, 
    debito.dataLancamento,
    SUM(debitoParcela.valor) AS valor,
    SUM(debitoParcela.valorJuros) AS valorJuros,
    SUM(debitoParcela.valorMulta) AS valorMulta,
    SUM(debitoParcela.valorCorrecao) AS valorCorrecao,
    SUM(debitoParcela.valorDesconto) AS valordesconto
FROM TribParcelamentoDebito parcelamentoDebito
LEFT OUTER JOIN TribDebito debito 
    ON parcelamentoDebito.idDebito = debito.idDebito     
LEFT OUTER JOIN TribDebitoParcelaReceita debitoParcela
    ON debito.entidade = debitoParcela.entidade
    AND debito.exercicio = debitoParcela.exercicio
    AND debito.tipoCadastro = debitoParcela.tipoCadastro
    AND debito.cadastroGeral = debitoParcela.cadastroGeral
    AND debito.guiaRecolhimento = debitoParcela.guiaRecolhimento
    AND debito.subDivida = debitoParcela.subDivida
WHERE parcelamentoDebito.idParcelamento = ?
GROUP BY parcelamentoDebito.idDebito, 
    debito.entidade,
    debito.exercicio, 
    debito.tipoCadastro, 
    debito.cadastroGeral, 
    debito.guiaRecolhimento,
    debito.subDivida, 
    debito.dataLancamento
ORDER BY debito.exercicio DESC, debito.guiaRecolhimento, debito.subdivida
