select ger.tipocadastro,
       ger.cadastrogeral,
       pes.pessoa,
       pes.nome,
       pes.cnpj_cpf as cpfCnpj,
       logr.descricao as rua,
       ger.numero,
       ger.complemento,
       ger.cep,
       cid.descricao as cidade,
       uni.descricao as estado,
       ger.idCadastroGeralIss,
       coalesce(sit_imob.situacaoimobiliario, sit_mob.situacaomobiliario) as situacao,
       coalesce(ts_imob.descricao, ts_mob.descricao) as descSituacao,
       cad_mob.numeroAlvara,
       cad_mob.exercicioAlvara,
       cad_mob.atividadePrincipal,
       cad_mob.observacaoAlvara,
       cad_mob.dataAbertura,
       cad_mob.dataEncerramento,
       cad_mob.dataValidadeAlvara,
       cad_mob.dataUltimaFiscalizacao,
       case 
        when (select count(*) from tribrepresentantelegal a
              where a.pessoa = pes.pessoa
              and a.tipocadastro = ger.tipocadastro
              and a.cadastrogeral = ger.cadastrogeral) = 1 then 'S' else 'N'
       end as representanteLegal       
from tribcadastrogeral ger
inner join pessoa pes on pes.pessoa = ger.pessoa
left outer join logradouro logr on logr.cidade     = ger.cidade
                               and logr.logradouro = ger.logradouro
left outer join cidade cid on cid.cidade = ger.cidade
left outer join unidadefederacao uni on uni.unidadefederacao = cid.unidadefederacao
                                    and uni.pais = cid.pais
left outer join tribcadastroimobiliario cad_imob on ger.tipocadastro = cad_imob.tipocadastro
                                                and ger.cadastrogeral = cad_imob.cadastrogeral
left outer join (select a.tipocadastro, a.cadastrogeral, max(a.sequencia) as sequencia
                 from tribimobiliariosituacao a where a.atual = 'S'
                 group by a.tipocadastro, a.cadastrogeral) s_imob on cad_imob.tipocadastro = s_imob.tipocadastro
                                                                 and cad_imob.cadastrogeral = s_imob.cadastrogeral
left outer join tribimobiliariosituacao sit_imob on s_imob.tipocadastro = sit_imob.tipocadastro
                                               and s_imob.cadastrogeral = sit_imob.cadastrogeral
                                               and s_imob.sequencia = sit_imob.sequencia
left outer join tribsituacaoimobiliario ts_imob on sit_imob.situacaoimobiliario = ts_imob.situacaoimobiliario                                              
left outer join tribcadastromobiliario cad_mob on ger.tipocadastro = cad_mob.tipocadastro
                                              and ger.cadastrogeral = cad_mob.cadastrogeral
left outer join (select a.tipocadastro, a.cadastrogeral, max(a.sequencia) as sequencia
                 from tribmobiliariosituacao a where a.atual = 'S'
                 group by a.tipocadastro, a.cadastrogeral) s_mob on cad_mob.tipocadastro = s_mob.tipocadastro
                                                                and cad_mob.cadastrogeral = s_mob.cadastrogeral
left outer join tribmobiliariosituacao sit_mob on s_mob.tipocadastro = sit_mob.tipocadastro
                                              and s_mob.cadastrogeral = sit_mob.cadastrogeral
                                              and s_mob.sequencia = sit_mob.sequencia
left outer join tribsituacaomobiliario ts_mob on sit_mob.situacaomobiliario = ts_mob.situacaomobiliario                                              
where ger.tipocadastro  = ?
and   ger.cadastrogeral = ?
