select   cg.idkey as "idCadastro",
         prop.pessoa as "pessoa",
         case p.tipopessoa when 'F' then 'FISICA'
                           when 'J' then 'JURIDICA'
         else null end as "tipoPessoa",
         p.cnpj_cpf as "cpfCnpj",
         p.nome as "nome",
         prop.vinculo as "codigoVinculo",
         prop.percentual as "percentual",
         case when prop.coresponsavelprincipal = 'S' then 'true' else 'false' end as "coresponsavelPrincipal",
         case when coalesce(prop.principal, 'N') = 'S' then 'true' else 'false' end as "principal",
         ep.cep as "cep",
         l.tipologradouro as "idTipoLogradouroAise",
         l.idkey as "idLogradouroAise",
         l.descricao as "logradouro",
         c.cidade as "idCidadeAise",
         c.descricao as "cidade",
         c.codigoibge as "ibge",
         ep.numero as "numero",
         c.unidadefederacao as "uf",
         ep.complemento as "complemento",
         b.idkey as "idBairroAise",
         b.descricao as "bairro",
         ep.tipoendereco as "tipoEndereco"
  from tribcadastrogeral cg
left outer join tribproprietario prop
  on cg.tipocadastro = prop.tipocadastro and
     cg.cadastrogeral = prop.cadastrogeral
left outer join pessoa p
  on prop.pessoa = p.pessoa
left outer join enderecopessoa ep
  on p.pessoa = ep.pessoa and
     p.sequenciaendereco = ep.sequencia
left outer join cidade c
  on ep.cidade = c.cidade
left outer join logradouro l
  on ep.logradouro = l.logradouro and
     ep.cidade = l.cidade
left outer join bairro b
  on ep.cidade = b.cidade and
     ep.bairro = b.bairro
where cg.tipocadastro = :tipoCadastro
