select tp.entidade,
       tep.dataestorno         as datamovimentacao,
       tr.receita              as tributo,
       tr.descricao            as descricaotributo,
       desconto.classificacaotributo,
       case
         when tdp.situacaolegal <> 0 and ( tdp.datadividaativa is null or tdp.datadividaativa <= tep.dataestorno )
         then tdp.situacaolegal
         else 0
       end                     situacaolegal,
       null                    as tipooperacaodeducao,
       'ESTORNO_DESCONTO_PARCELAMENTO' as tipomovimento,
       td.iddebito,
       sum(desconto.valor)     as valor
from   tribestornoparcelamento tep
       left outer join tribparcelamento tp
                    on tp.idparcelamento = tep.idparcelamento
       left outer join (select tpre.idparcelamentoreceitaespelho,
                               tpre.idparcelamento,
                               tpre.receitaorigem      as tributo,
                               tpre.valordescontoprincipal as valor,
                               tpre.iddebitonovo,
                               'P'                     as classificacaotributo
                        from   tribparcelamentoreceitaespelho tpre
                        where  valordescontoprincipal > 0
                        union
                        select tpre.idparcelamentoreceitaespelho,
                               tpre.idparcelamento,
                               tpre.receitaorigem      as tributo,
                               tpre.valordescontojuros as valor,
                               tpre.iddebitonovo,
                               'J'                     as classificacaotributo
                        from   tribparcelamentoreceitaespelho tpre
                        where  valordescontojuros > 0
                        union
                        select tpre.idparcelamentoreceitaespelho,
                               tpre.idparcelamento,
                               tpre.receitaorigem      as tributo,
                               tpre.valordescontomulta as valor,
                               tpre.iddebitonovo,
                               'M'                     as classificacaotributo
                        from   tribparcelamentoreceitaespelho tpre
                        where  valordescontomulta > 0
                        union
                        select tpre.idparcelamentoreceitaespelho,
                               tpre.idparcelamento,
                               tpre.receitaorigem         as tributo,
                               tpre.valordescontocorrecao as valor,
                               tpre.iddebitonovo,
                               'C'                        as classificacaotributo
                        from   tribparcelamentoreceitaespelho tpre
                        where  valordescontocorrecao > 0) desconto
                    on desconto.idparcelamento = tp.idparcelamento
       left outer join tribdebito td
                    on td.iddebito = desconto.iddebitonovo
       left outer join tribdebitoparcela tdp
                    on td.entidade = tdp.entidade
                   and td.exercicio = tdp.exercicio
                   and td.tipocadastro = tdp.tipocadastro
                   and td.cadastrogeral = tdp.cadastrogeral
                   and td.guiarecolhimento = tdp.guiarecolhimento
                   and td.subdivida = tdp.subdivida
                   and tdp.parcela = 1
       left outer join tribreceita tr
                    on td.entidade = tr.entidade
                   and td.exercicio = tr.exercicio
                   and desconto.tributo = tr.receita
where  td.constituido = 'S'
  and  coalesce(tr.inscrito, 1) = 1
  and  tep.dataestorno in (:datasMovimento)
  and  exists(select 1 from tribestornoparcelamentodebito tepd
                      where tepd.idestornoparcelamento = tep.idestornoparcelamento
                        and tepd.iddebitoorigem > tepd.iddebitodestino)
group  by tp.entidade,
          tep.dataestorno,
          tr.receita,
          tr.descricao,
          desconto.classificacaotributo,
          case
            when tdp.situacaolegal <> 0 and ( tdp.datadividaativa is null or tdp.datadividaativa <= tep.dataestorno )
            then tdp.situacaolegal
            else 0
          end,
          td.iddebito