SELECT DEBITOPARCELARECEITA.RECEITA                          AS tributo,
       SUM(COALESCE(PAGAMENTODEBITO.VALORPRINCIPAL, 0)) * -1 AS valorPrincipal,
       SUM(COALESCE(PAGAMENTODEBITO.VALORJUROS, 0)) * -1     AS valorJuros,
       SUM(COALESCE(PAGAMENTODEBITO.VALORMULTA, 0)) * -1     AS valorMulta,
       SUM(COALESCE(PAGAMENTODEBITO.VALORCORRECAO, 0)) * -1  AS valorCorrecao,
       SUM(COALESCE(PAGAMENTODEBITO.VALORDESCONTO, 0)) * -1  AS valorDesconto
FROM TRIBESTORNOPAGAMENTO ESTORNOPAGAMENTO
         JOIN TRIBESTORNOPAGAMENTOITEM ESTORNOPAGAMENTOITEM ON
        ESTORNOPAGAMENTO.ENTIDADE = ESTORNOPAGAMENTOITEM.ENTIDADE AND
        ESTORNOPAGAMENTO.EXERCICIO = ESTORNOPAGAMENTOITEM.EXERCICIO AND
        ESTORNOPAGAMENTO.ESTORNO = ESTORNOPAGAMENTOITEM.ESTORNO
         JOIN TRIBPAGAMENTODEBITO PAGAMENTODEBITO
              ON ESTORNOPAGAMENTOITEM.IDPAGAMENTOBLOQUETO = PAGAMENTODEBITO.IDPAGAMENTOBLOQUETO AND
                 ESTORNOPAGAMENTOITEM.IDDEBITOPARCELARECEITA = PAGAMENTODEBITO.IDDEBITOPARCELARECEITA
         JOIN TRIBDEBITOPARCELARECEITA DEBITOPARCELARECEITA
              ON PAGAMENTODEBITO.IDDEBITOPARCELARECEITA = DEBITOPARCELARECEITA.IDDEBITOPARCELARECEITA
         JOIN CONTABANCARIA ON ESTORNOPAGAMENTO.ENTIDADE = CONTABANCARIA.ENTIDADE AND
                               ESTORNOPAGAMENTO.CONTABANCARIAESTORNO = CONTABANCARIA.CONTABANCARIA
         JOIN TRIBRECEITA RECEITA ON RECEITA.ENTIDADE = DEBITOPARCELARECEITA.ENTIDADE AND
                                     RECEITA.EXERCICIO = DEBITOPARCELARECEITA.EXERCICIO AND
                                     RECEITA.RECEITA = DEBITOPARCELARECEITA.RECEITA
         JOIN TRIBRECEITATIPO TIPORECEITA ON TIPORECEITA.TIPORECEITA = RECEITA.TIPORECEITA
WHERE CONTABANCARIA.INTEGRAARRECADACAO = 'S'
AND ESTORNOPAGAMENTO.DATA = :dataLancamento
%s
GROUP BY DEBITOPARCELARECEITA.RECEITA