SELECT DEBITOPARCELARECEITA.RECEITA                                  AS tributo,
       SUM(COALESCE(CREDITOCONTRIBUINTEITEM.VALORPRINCIPAL, 0)) * -1 AS valorPrincipal,
       SUM(COALESCE(CREDITOCONTRIBUINTEITEM.VALORJUROS, 0)) * -1     AS valorJuros,
       SUM(COALESCE(CREDITOCONTRIBUINTEITEM.VALORMULTA, 0)) * -1     AS valorMulta,
       SUM(COALESCE(CREDITOCONTRIBUINTEITEM.VALORCORRECAO, 0)) * -1  AS valorCorrecao,
       CASE
           WHEN SUM(COALESCE(CREDITOCONTRIBUINTEITEM.VALORDESCONTOPRINCIPAL, 0) +
                    COALESCE(CREDITOCONTRIBUINTEITEM.VALORDESCONTOJUROS, 0) +
                    COALESCE(CREDITOCONTRIBUINTEITEM.VALORDESCONTOMULTA, 0) +
                    COALESCE(CREDITOCONTRIBUINTEITEM.VALORDESCONTOCORRECAO, 0)) > 0
               THEN SUM(COALESCE(CREDITOCONTRIBUINTEITEM.VALORDESCONTOPRINCIPAL, 0) +
                        COALESCE(CREDITOCONTRIBUINTEITEM.VALORDESCONTOJUROS, 0) +
                        COALESCE(CREDITOCONTRIBUINTEITEM.VALORDESCONTOMULTA, 0) +
                        COALESCE(CREDITOCONTRIBUINTEITEM.VALORDESCONTOCORRECAO, 0)) * -1
           ELSE SUM(COALESCE(CREDITOCONTRIBUINTEITEM.VALORDESCONTO, 0)) * -1
           END                                                  AS valorDesconto
FROM TRIBCREDITOCONTRIBUINTE CREDITOCONTRIBUINTE
         LEFT OUTER JOIN TRIBCREDITOCONTRIBUINTEITEM CREDITOCONTRIBUINTEITEM
                         ON CREDITOCONTRIBUINTE.ENTIDADE = CREDITOCONTRIBUINTEITEM.ENTIDADE AND
                            CREDITOCONTRIBUINTE.EXERCICIO = CREDITOCONTRIBUINTEITEM.EXERCICIO AND
                            CREDITOCONTRIBUINTE.CREDITOCONTRIBUINTE = CREDITOCONTRIBUINTEITEM.CREDITOCONTRIBUINTE
         LEFT OUTER JOIN CONTABANCARIA ON CREDITOCONTRIBUINTE.ENTIDADE = CONTABANCARIA.ENTIDADE AND
                                          CREDITOCONTRIBUINTE.CONTABANCARIA = CONTABANCARIA.CONTABANCARIA
         LEFT OUTER JOIN TRIBDEBITOPARCELARECEITA DEBITOPARCELARECEITA
                         ON CREDITOCONTRIBUINTEITEM.IDDEBITOPARCELARECEITA = DEBITOPARCELARECEITA.IDDEBITOPARCELARECEITA
         LEFT OUTER JOIN TRIBRECEITA RECEITA ON DEBITOPARCELARECEITA.ENTIDADE = RECEITA.ENTIDADE AND
                                                DEBITOPARCELARECEITA.EXERCICIO = RECEITA.EXERCICIO AND
                                                DEBITOPARCELARECEITA.RECEITA = RECEITA.RECEITA
         LEFT OUTER JOIN TRIBRECEITATIPO TIPORECEITA ON RECEITA.TIPORECEITA = TIPORECEITA.TIPORECEITA
WHERE CREDITOCONTRIBUINTE.DATAESTORNO = :dataLancamento
AND CONTABANCARIA.INTEGRAARRECADACAO = 'S'
AND EXISTS(SELECT 1
         FROM TRIBCREDITOCONTRIBUINTEITEMMOV CREDITOCONTRIBUINTEITEMMOV
         WHERE CREDITOCONTRIBUINTEITEMMOV.IDCREDITOCONTRIBUINTEITEM =
               CREDITOCONTRIBUINTEITEM.IDCREDITOCONTRIBUINTEITEM
           AND CREDITOCONTRIBUINTEITEMMOV.TIPO = 'E')
%s
GROUP BY DEBITOPARCELARECEITA.RECEITA