    SELECT DISTINCT TPL.DATAMOVIMENTO,
                    (cast(TBAD.BANCO as varchar(255)) || ' - ' || BCO.DESCRICAO)        			 AS BANCO,
                    (cast(TBAD.CONTABANCARIA as varchar(255)) || ' - ' || CB.DESCRICAO) 			 AS CONTABANCARIA,
                    (cast(TBAD.CONVENIO as varchar(255)) || ' - ' || TC.DESCRICAO)      			 AS CONVENIO,
                    (cast(TBAD.LOTE as varchar(255)) || '/' || cast(TBAD.EXERCICIO as varchar(255))) AS DESCRICAOLOTE,
                    TBAD.LOTE,
                    TBAD.EXERCICIO,
                    TBAD.ENTIDADE,
                    TPL.DATALOTE,
                    TPL.NUMEROBAIXAS,
                    TPL.NOMEARQUIVO,
                    TBAD.SEQUENCIAARQUIVO,
                    TBAD.MENSAGEM,
                    TBAD.NOSSONUMERO,
                    TBAD.DATAPAGAMENTO,
                    TBAD.VALOR,
                    TBAD.VALORPAGO,
                    (TBAD.VALORPAGO - TBAD.VALOR) 													 AS DIFERENCA
     FROM TRIBBAIXAAUTOMATICADETALHE TBAD
LEFT JOIN BANCO                      BCO  ON (TBAD.BANCO = BCO.BANCO)
LEFT JOIN CONTABANCARIA              CB   ON (TBAD.CONTABANCARIA = CB.CONTABANCARIA)
LEFT JOIN TRIBPAGAMENTOLOTE          TPL  ON (TBAD.ENTIDADE = TPL.ENTIDADE AND TBAD.EXERCICIO = TPL.EXERCICIO AND TBAD.LOTE = TPL.LOTE)
LEFT JOIN TRIBCONVENIO               TC   ON (TBAD.ENTIDADE = TC.ENTIDADE AND TBAD.CONVENIO = TC.CONVENIO)
    WHERE TBAD.ENTIDADE = :ENTIDADE
      AND TBAD.EXERCICIO = :EXERCICIO
      AND TBAD.LOTE = :LOTE
      AND TBAD.CODIGORETORNODEBITOAUTOMATICO IS NULL
      AND TBAD.SITUACAO <> :CLASSIFICACAOTIPOMENSAGEM
ORDER BY
  TBAD.ENTIDADE,
  TBAD.EXERCICIO,
  TBAD.LOTE,
  TBAD.SEQUENCIAARQUIVO
