/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.ws.domain;

import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoDocumentoEnum;
import br.com.elotech.tributos.dto.DocumentoDTO;
import java.math.BigDecimal;
import java.time.LocalDate;

public class GeraLaudoAvaliacaoEnvio {
    private static final Long DOCUMENTO_PADRAO = 0L;
    private String userKey;
    private Long tipoCadastro;
    private Long cadastroGeral;
    private final Long exercicio;
    private Long tipoDocumento = TipoDocumentoEnum.LAUDO_AVALIACAO.getCodigo();
    private Long documento = DOCUMENTO_PADRAO;
    private BigDecimal valorVenalInformado;
    private String nomeRequerente;
    private String cpfRequerente;
    private String usuario;

    public GeraLaudoAvaliacaoEnvio() {
        this.exercicio = LocalDate.now().getYear();
    }

    public GeraLaudoAvaliacaoEnvio(Long cadastroGeral, String userKey, Long exercicio) {
        this.cadastroGeral = cadastroGeral;
        this.userKey = userKey;
        this.exercicio = exercicio;
    }

    public GeraLaudoAvaliacaoEnvio(Long cadastroGeral) {
        this.tipoCadastro = TipoCadastro.IMOBILIARIO.getValue();
        this.cadastroGeral = cadastroGeral;
        this.exercicio = LocalDate.now().getYear();
    }

    public GeraLaudoAvaliacaoEnvio(DocumentoDTO dto) {
        this.tipoCadastro = dto.getTipoCadastro().getValue();
        this.cadastroGeral = dto.getCadastroGeral();
        this.valorVenalInformado = dto.getValorVenalInformado();
        this.nomeRequerente = dto.getNomeRequerente();
        this.cpfRequerente = dto.getCpfRequerente();
        this.exercicio = LocalDate.now().getYear();
        this.usuario = dto.getUsuario();
    }

    public String getUserKey() {
        return this.userKey;
    }

    public void setUserKey(String userKey) {
        this.userKey = userKey;
    }

    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    public Long getExercicio() {
        return this.exercicio;
    }

    public Long getTipoDocumento() {
        return this.tipoDocumento;
    }

    public void setTipoDocumento(Long tipoDocumento) {
        this.tipoDocumento = tipoDocumento;
    }

    public Long getDocumento() {
        return this.documento;
    }

    public void setDocumento(Long documento) {
        this.documento = documento;
    }

    public BigDecimal getValorVenalInformado() {
        return this.valorVenalInformado;
    }

    public void setValorVenalInformado(BigDecimal valorVenalInformado) {
        this.valorVenalInformado = valorVenalInformado;
    }

    public String getNomeRequerente() {
        return this.nomeRequerente;
    }

    public void setNomeRequerente(String nomeRequerente) {
        this.nomeRequerente = nomeRequerente;
    }

    public String getCpfRequerente() {
        return this.cpfRequerente;
    }

    public void setCpfRequerente(String cpfRequerente) {
        this.cpfRequerente = cpfRequerente;
    }

    public String getUsuario() {
        return this.usuario;
    }

    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }
}

