/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.ws.rest;

import br.com.elotech.tributos.config.HttpEntityFactory;
import br.com.elotech.tributos.config.TributosProperties;
import br.com.elotech.tributos.dto.ImprimirRelatorioDTO;
import br.com.elotech.tributos.exception.RelatorioGenericoException;
import br.com.elotech.tributos.service.ws.AiseRelatorioService;
import br.com.elotech.tributos.service.ws.rest.AiseLoginServiceRest;
import br.com.elotech.tributos.ws.domain.LoginRespostaRest;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class AiseRelatorioServiceRest
implements AiseRelatorioService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AiseRelatorioServiceRest.class);
    private final AiseLoginServiceRest aiseLoginServiceRest;
    private final RestTemplate restTemplate;
    private final TributosProperties tributosProperties;
    private final ObjectMapper objectMapper;

    public AiseRelatorioServiceRest(AiseLoginServiceRest aiseLoginServiceRest, RestTemplate restTemplate, TributosProperties tributosProperties, ObjectMapper objectMapper) {
        this.aiseLoginServiceRest = aiseLoginServiceRest;
        this.restTemplate = restTemplate;
        this.tributosProperties = tributosProperties;
        this.objectMapper = objectMapper;
    }

    private String toJson(Object object) {
        try {
            return this.objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RelatorioGenericoException(HttpStatus.BAD_REQUEST, "Erro ao gerar relat\u00f3rio gen\u00e9rico", (Exception)((Object)e));
        }
    }

    public byte[] imprimirRelatorioGenerico(ImprimirRelatorioDTO relatorioDTO) {
        try {
            LoginRespostaRest loginResposta = this.aiseLoginServiceRest.login();
            String url = String.format("%s/imprimirrelatoriogenerico?uid=%s", this.tributosProperties.getAise().getWsBaseUrl(), loginResposta.getIdToken());
            String parametros = this.toJson((Object)relatorioDTO);
            LOGGER.info(String.format("Gerando Relat\u00f3rio Gen\u00e9rico...%nPar\u00e2metros: %s%nUrl: %s", parametros, url));
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, HttpEntityFactory.createJsonHttpEntity((Object)relatorioDTO), byte[].class, new Object[0]);
            return (byte[])response.getBody();
        }
        catch (Exception ex) {
            LOGGER.error("Erro na gera\u00e7\u00e3o de relat\u00f3rio gen\u00e9rico", (Throwable)ex);
            throw new RelatorioGenericoException(HttpStatus.BAD_REQUEST, ex.getMessage(), ex);
        }
    }
}

