/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.simam;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.dto.simam.DeducaoCreditoDTO;
import br.com.elotech.tributos.repository.EntidadeRepository;
import br.com.elotech.tributos.repository.simam.DeducaoCreditoRepository;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class DeducaoCreditoService {
    private final DeducaoCreditoRepository deducaoCreditoRepository;
    private final EntidadeRepository entidadeRepository;

    public List<DeducaoCreditoDTO> findDeducaoCredito(Long idEntidade, LocalDate dataInicial, LocalDate dataFinal) {
        Entidade entidade = (Entidade)this.entidadeRepository.findById((Object)idEntidade).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel localizar a entidade com id %d", idEntidade)));
        return this.deducaoCreditoRepository.findLancamentos(Long.valueOf(entidade.getIdentificacaoTce()), entidade.getId(), dataInicial, dataFinal);
    }

    public void atualizaValorFinal(Long entidade, LocalDate dataInicial, LocalDate dataFinal) {
        this.deducaoCreditoRepository.atualizaValorFinal(entidade, dataInicial, dataFinal);
    }

    public void verificarErrors(Long entidade, LocalDate dataInicial, LocalDate dataFinal) {
        this.deducaoCreditoRepository.verificarErrors(entidade, dataInicial, dataFinal);
    }

    @Generated
    public DeducaoCreditoService(DeducaoCreditoRepository deducaoCreditoRepository, EntidadeRepository entidadeRepository) {
        this.deducaoCreditoRepository = deducaoCreditoRepository;
        this.entidadeRepository = entidadeRepository;
    }
}

