/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.requerimento;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.OrigemEmissao;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoBloqueto;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoRequerimento;
import br.com.elotech.tributos.domain.TipoRequerimentoItem;
import br.com.elotech.tributos.domain.Tributo;
import br.com.elotech.tributos.domain.requerimento.Requerimento;
import br.com.elotech.tributos.domain.requerimento.RequerimentoId;
import br.com.elotech.tributos.domain.requerimento.RequerimentoItem;
import br.com.elotech.tributos.domain.requerimento.RequerimentoItemId;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.DebitoManualDTO;
import br.com.elotech.tributos.dto.DebitoManualObservacaoDTO;
import br.com.elotech.tributos.dto.DebitoManualParcelaDTO;
import br.com.elotech.tributos.dto.DebitoManualTributoDTO;
import br.com.elotech.tributos.dto.DebitoParcelaDTO;
import br.com.elotech.tributos.dto.GeraBoletoDTO;
import br.com.elotech.tributos.dto.requerimento.RequerimentoDTO;
import br.com.elotech.tributos.repository.requerimento.RequerimentoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.GeraBoletoService;
import br.com.elotech.tributos.service.GeraDebitoService;
import br.com.elotech.tributos.service.PessoaService;
import br.com.elotech.tributos.service.TipoRequerimentoItemService;
import br.com.elotech.tributos.service.TipoRequerimentoService;
import br.com.elotech.tributos.service.TributoService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class RequerimentoService
extends CrudService<Requerimento, RequerimentoId> {
    private final CadastroGeralService cadastroGeralService;
    private final PessoaService pessoaService;
    private final TipoRequerimentoService tipoRequerimentoService;
    private final TipoRequerimentoItemService tipoRequerimentoItemService;
    private final TributoService tributoService;
    private final GeraDebitoService geraDebitoService;
    private final GeraBoletoService geraBoletoService;
    private final RequerimentoRepository requerimentoRepository;
    private final ContextService contextService;

    public RequerimentoService(CadastroGeralService cadastroGeralService, PessoaService pessoaService, TipoRequerimentoService tipoRequerimentoService, TipoRequerimentoItemService tipoRequerimentoItemService, TributoService tributoService, GeraDebitoService geraDebitoService, GeraBoletoService geraBoletoService, RequerimentoRepository requerimentoRepository, ContextService contextService) {
        this.cadastroGeralService = cadastroGeralService;
        this.pessoaService = pessoaService;
        this.tipoRequerimentoService = tipoRequerimentoService;
        this.tipoRequerimentoItemService = tipoRequerimentoItemService;
        this.tributoService = tributoService;
        this.geraDebitoService = geraDebitoService;
        this.geraBoletoService = geraBoletoService;
        this.requerimentoRepository = requerimentoRepository;
        this.contextService = contextService;
    }

    public RequerimentoId gerar(RequerimentoDTO requerimentoDTO) {
        Pessoa pessoaRequerente = (Pessoa)this.pessoaService.findById(requerimentoDTO.getRequerente()).orElseThrow(() -> new EloValidationException("Requerente n\u00e3o encontrado"));
        TipoRequerimento tipoRequerimento = (TipoRequerimento)this.tipoRequerimentoService.findById((Serializable)requerimentoDTO.getTipoRequerimento()).orElseThrow(() -> new EloValidationException("Tipo do requerimento n\u00e3o encontrado"));
        CadastroGeral cadastroGeral = (CadastroGeral)this.cadastroGeralService.findByTipoCadastroAndCadastroGeral(TipoCadastro.fromValue((Long)requerimentoDTO.getTipoCadastro()), requerimentoDTO.getCadastroGeral()).orElseThrow(() -> new EloValidationException("Cadastro n\u00e3o encontrado"));
        if (Objects.nonNull(requerimentoDTO.getIdProcesso()) && Objects.isNull(requerimentoDTO.getExercicioProcesso()) || Objects.isNull(requerimentoDTO.getIdProcesso()) && Objects.nonNull(requerimentoDTO.getExercicioProcesso())) {
            throw new EloValidationException("Os campos ano processo e n\u00b0 processo s\u00e3o dependentes e n\u00e3o podem ser preenchidos separadamente");
        }
        RequerimentoId id = new RequerimentoId();
        id.setEntidade(requerimentoDTO.getEntidade());
        id.setExercicio(requerimentoDTO.getExercicio());
        Requerimento requerimento = new Requerimento();
        requerimento.setId(id);
        requerimento.setTipoRequerimento(tipoRequerimento);
        requerimento.setCadastroGeral(cadastroGeral);
        requerimento.setPessoa(pessoaRequerente);
        requerimento.setDataRequerimento(requerimentoDTO.getDataLancamento());
        requerimento.setIdProcesso(requerimentoDTO.getIdProcesso());
        requerimento.setExercicioProcesso(requerimentoDTO.getExercicioProcesso());
        requerimento.setUsuario(SecurityUtils.getUserAise());
        requerimento.setData(LocalDate.now());
        Requerimento savedEntity = (Requerimento)this.requerimentoRepository.save((Object)requerimento);
        savedEntity.getItens().addAll(this.getRequerimentoItems(requerimentoDTO, tipoRequerimento, savedEntity));
        savedEntity.addParcela(requerimentoDTO.getDataVencimento());
        savedEntity.addObservacoes(requerimentoDTO.getObservacoes());
        DebitoIdDTO debitoIdDTO = this.gerarDebitoRequerimento(savedEntity);
        this.getEm().flush();
        Bloqueto boleto = this.geraBoletoRequerimento(debitoIdDTO.getIdDebito());
        savedEntity.setExercicioDebito(debitoIdDTO.getExercicio());
        savedEntity.setDivida(debitoIdDTO.getDivida());
        savedEntity.setSubDivida(debitoIdDTO.getSubDivida());
        savedEntity.setBoleto(boleto);
        return ((Requerimento)this.requerimentoRepository.save((Object)savedEntity)).getId();
    }

    private List<RequerimentoItem> getRequerimentoItems(RequerimentoDTO requerimentoDTO, TipoRequerimento tipoRequerimento, Requerimento savedEntity) {
        RequerimentoId id = savedEntity.getId();
        return requerimentoDTO.getItens().stream().filter(item -> item.getQuantidade().multiply(item.getValorUnitario()).compareTo(BigDecimal.ZERO) > 0).map(itemDto -> {
            TipoRequerimentoItem tipoRequerimentoItem = (TipoRequerimentoItem)this.tipoRequerimentoItemService.findById((Serializable)itemDto.getTipoRequerimentoItem()).orElseThrow(() -> new EloValidationException("Item do Tipo Requerimento n\u00e3o encontrado."));
            if (!tipoRequerimento.equals((Object)tipoRequerimentoItem.getTipoRequerimento())) {
                throw new EloValidationException("Item n\u00e3o pertence ao Tipo do Requerimento informado.");
            }
            Tributo tributo = this.tributoService.findByEntidadeAndExercicioAndTributo(id.getEntidade(), id.getExercicio(), tipoRequerimentoItem.getTributo());
            if (Objects.isNull(tributo)) {
                throw new EloValidationException(String.format("Tributo %s n\u00e3o encontrado na entidade %d e exerc\u00edcio %d.", tipoRequerimentoItem.getTributo(), id.getEntidade(), id.getExercicio()));
            }
            RequerimentoItem requerimentoItem = new RequerimentoItem();
            requerimentoItem.setId(new RequerimentoItemId(id, tipoRequerimentoItem.getId()));
            requerimentoItem.setDescricao(tipoRequerimentoItem.getDescricao());
            requerimentoItem.setQuantidade(itemDto.getQuantidade());
            requerimentoItem.setValorUnitario(itemDto.getValorUnitario());
            requerimentoItem.setTributo(tributo);
            return requerimentoItem;
        }).collect(Collectors.toList());
    }

    private Bloqueto geraBoletoRequerimento(Long idDebito) {
        DebitoParcelaDTO debitoParcelaDTO = new DebitoParcelaDTO();
        debitoParcelaDTO.setIdDebito(idDebito);
        debitoParcelaDTO.setParcela(Long.valueOf(1L));
        GeraBoletoDTO geraBoletoDTO = new GeraBoletoDTO();
        geraBoletoDTO.setOrigemEmissao(OrigemEmissao.AISE);
        geraBoletoDTO.setTipoBoleto(TipoBloqueto.PARCELADO);
        geraBoletoDTO.setDebitos(Collections.singletonList(debitoParcelaDTO));
        geraBoletoDTO.setDataReferencia(this.contextService.getDataAtual());
        return (Bloqueto)this.geraBoletoService.geraBoleto(geraBoletoDTO, Boolean.FALSE).stream().findFirst().orElseThrow(() -> new IllegalStateException("Erro ao gerar boleto"));
    }

    private DebitoIdDTO gerarDebitoRequerimento(Requerimento requerimento) {
        DebitoManualDTO debitoManualDTO = new DebitoManualDTO();
        debitoManualDTO.setExercicio(requerimento.getId().getExercicio());
        debitoManualDTO.setTipoCadastro(TipoCadastro.fromValue((Long)requerimento.getCadastroGeral().getTipoCadastro().getValue()));
        debitoManualDTO.setCadastroGeral(requerimento.getCadastroGeral().getCadastroGeral());
        debitoManualDTO.setDivida(requerimento.getTipoRequerimento().getDivida().getDivida());
        debitoManualDTO.setDataLancamento(requerimento.getDataRequerimento());
        debitoManualDTO.setExercicioProcesso(requerimento.getExercicioProcesso());
        debitoManualDTO.setProcesso(requerimento.getIdProcesso());
        requerimento.getParcelas().forEach(parcela -> {
            DebitoManualParcelaDTO debitoManualParcelaDTO = new DebitoManualParcelaDTO();
            debitoManualParcelaDTO.setParcela(parcela.getId().getParcela());
            debitoManualParcelaDTO.setDataVencimento(parcela.getDataVencimento());
            debitoManualParcelaDTO.setValor(parcela.getValor());
            debitoManualDTO.getParcelas().add(debitoManualParcelaDTO);
        });
        AtomicLong ordemTributo = new AtomicLong(1L);
        requerimento.getItens().forEach(item -> {
            DebitoManualTributoDTO debitoManualTributoDTO = new DebitoManualTributoDTO();
            debitoManualTributoDTO.setTributo(item.getTributo().getTributo());
            debitoManualTributoDTO.setValorTributo(item.getValorTotal());
            debitoManualTributoDTO.setOrdem(Long.valueOf(ordemTributo.getAndIncrement()));
            debitoManualDTO.getTributos().add(debitoManualTributoDTO);
        });
        requerimento.getObservacoes().forEach(observacao -> {
            DebitoManualObservacaoDTO debitoManualObservacaoDTO = new DebitoManualObservacaoDTO();
            debitoManualObservacaoDTO.setObservacao(observacao.getObservacao());
            debitoManualDTO.getObservacoes().add(debitoManualObservacaoDTO);
        });
        return this.geraDebitoService.geraDebitoManual(debitoManualDTO);
    }
}

