/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaogeomais;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Distrito;
import br.com.elotech.tributos.domain.Loteamento;
import br.com.elotech.tributos.domain.Setor;
import br.com.elotech.tributos.dto.integracaogeomais.LoteamentoGeomaisDTO;
import br.com.elotech.tributos.dto.integracaogeomais.LoteamentoPostElogeoDTO;
import br.com.elotech.tributos.service.DistritoService;
import br.com.elotech.tributos.service.LoteamentoService;
import br.com.elotech.tributos.service.SetorService;
import br.com.elotech.tributos.util.EloRequireNonNull;
import java.io.Serializable;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class LoteamentoElogeoService {
    private final DistritoService distritoService;
    private final SetorService setorService;
    private final LoteamentoService loteamentoService;

    public LoteamentoElogeoService(DistritoService distritoService, SetorService setorService, LoteamentoService loteamentoService) {
        this.distritoService = distritoService;
        this.setorService = setorService;
        this.loteamentoService = loteamentoService;
    }

    private LoteamentoGeomaisDTO entityToElogeoDTO(Loteamento loteamento) {
        return LoteamentoGeomaisDTO.from((Loteamento)loteamento);
    }

    public Loteamento findByLoteamentoElogeoDTO(Long id) {
        return this.loteamentoService.findByLoteamento(id);
    }

    public Page<LoteamentoGeomaisDTO> findAllElogeo(Pageable page) {
        return this.loteamentoService.findAll(page).map(arg_0 -> this.entityToElogeoDTO(arg_0));
    }

    public Page<LoteamentoGeomaisDTO> findByRSQL(String search, Pageable pageable) {
        return this.loteamentoService.findByRsql(search, pageable).map(arg_0 -> this.entityToElogeoDTO(arg_0));
    }

    public LoteamentoGeomaisDTO saveElogeoDTO(LoteamentoPostElogeoDTO loteamentoPostElogeoDTO, String distrito, String setor, Long loteamento) {
        return this.save(loteamentoPostElogeoDTO, Boolean.FALSE, distrito, setor, loteamento);
    }

    public LoteamentoGeomaisDTO saveElogeoDTO(LoteamentoPostElogeoDTO loteamentoPostElogeoDTO) {
        return this.save(loteamentoPostElogeoDTO, Boolean.TRUE, null, null, null);
    }

    private LoteamentoGeomaisDTO save(LoteamentoPostElogeoDTO loteamentoPostElogeoDTO, Boolean novoCadastro, String distrito, String setor, Long loteamento) {
        Loteamento loteamentoToSave = loteamentoPostElogeoDTO.toEntity();
        loteamentoToSave.setDistrito((Distrito)this.distritoService.findById((Serializable)((Object)loteamentoPostElogeoDTO.getDistrito())).orElseThrow(() -> new EloValidationException(String.format("Distrito %s n\u00e3o localizado.", loteamentoPostElogeoDTO.getDistrito()))));
        loteamentoToSave.setSetor((Setor)EloRequireNonNull.eloRequireNonNull((Object)this.setorService.findByDistritoDistritoAndSetor(loteamentoPostElogeoDTO.getDistrito(), loteamentoPostElogeoDTO.getSetor()), (String)String.format("Setor %s n\u00e3o localizado.", loteamentoPostElogeoDTO.getSetor())));
        Loteamento loteamentoPrepared = this.prepareToSave(loteamentoToSave, novoCadastro, distrito, setor, loteamento);
        Loteamento saved = (Loteamento)this.loteamentoService.save((EloEntity)loteamentoPrepared, null);
        return this.entityToElogeoDTO(saved);
    }

    private Loteamento prepareToSave(Loteamento loteamentoToSave, Boolean novoCadastro, String distrito, String setor, Long loteamento) {
        if (!novoCadastro.booleanValue() && loteamentoToSave.getLoteamento() != null) {
            Loteamento loteamentoFound = Optional.ofNullable(this.loteamentoService.findBySetorDistritoDistritoAndSetorSetorAndLoteamento(distrito, setor, loteamento)).orElseThrow(() -> new EloValidationException(String.format("Loteamento %s do Distrito %s e Setor %s n\u00e3o localizado.", loteamento, distrito, setor)));
            return loteamentoFound.mergeElogeo(loteamentoToSave);
        }
        return loteamentoToSave;
    }
}

