/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto.bancodobrasil;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.TipoCodigoBarras;
import br.com.elotech.tributos.domain.cnab240.ParametroCNAB240;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoBoletoPixLog;
import br.com.elotech.tributos.domain.registroboletoonline.ErroBoletoRegistroOnline;
import br.com.elotech.tributos.dto.CodigoBarrasDTO;
import br.com.elotech.tributos.dto.integracaoboleto.ConsultaPixResponseDTO;
import br.com.elotech.tributos.dto.integracaoboleto.IntegracaoPixResponseDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.ConsultaPagCobrancaPixResponseBBDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.ConsultaPagamentoPixResponseBBDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.ConsultaQrCodePagamentoPixResponseBBDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.EmissaoBoletoBBDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.EmissaoBoletoBBResponseDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.GerarQrCodePixBBRequestDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.GerarQrCodePixBBResponseDTO;
import br.com.elotech.tributos.enums.integracaoboleto.TipoIntegracaoBoletoPix;
import br.com.elotech.tributos.repository.BancoRepository;
import br.com.elotech.tributos.repository.FormaPagamentoRepository;
import br.com.elotech.tributos.repository.cnab240.ParametroCNAB240Repository;
import br.com.elotech.tributos.repository.integracaoboleto.IntegracaoBoletoPixLogRepository;
import br.com.elotech.tributos.repository.registroboletoonline.ErroBoletoRegistradoOnlineRepository;
import br.com.elotech.tributos.service.BloquetoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.impl.exception.ParametroNaoEncontradoException;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoBoletoRegistrado;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoPix;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoPixUtil;
import br.com.elotech.tributos.util.GeradorDigitoVerificador;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class IntegracaoBoletoBBService
implements IntegracaoBoletoRegistrado,
IntegracaoPix {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegracaoBoletoBBService.class);
    private static final String AUTHORIZATION = "Authorization";
    private static final String BEARER = "Bearer %s";
    private final RestTemplate restTemplate;
    private final ParametroGeralService parametroGeralService;
    private final ObjectMapper mapper;
    private final IntegracaoBoletoPixLogRepository integracaoBoletoPixLogRepository;
    private final PlatformTransactionManager transactionManager;
    private final TransactionDefinition transactionDefinition = new DefaultTransactionDefinition(3);
    private final ParametroCNAB240Repository parametroCNAB240Repository;
    private final BancoRepository bancoRepository;
    private final ErroBoletoRegistradoOnlineRepository erroBoletoRegistradoOnlineRepository;
    private final FormaPagamentoRepository formaPagamentoRepository;
    private final BloquetoService bloquetoService;

    public ParametroCNAB240 getParametroCnab240ByBanco() {
        return (ParametroCNAB240)this.parametroCNAB240Repository.findFirstByBanco((Banco)this.bancoRepository.findOne((Object)Banco.CODIGO_BANCO_BRASIL)).orElseThrow(() -> new EloValidationException("Par\u00e2metro CNAB 240 n\u00e3o encontrado para o Banco do Brasil!"));
    }

    public CodigoBarrasDTO generateBoleto(Bloqueto boleto, ParametroCNAB240 parametroCNAB240) {
        IntegracaoBoletoPixLog integracaoBoletoPixLog = new IntegracaoBoletoPixLog(TipoIntegracaoBoletoPix.GERA_BOLETO);
        HttpEntity request = null;
        try {
            integracaoBoletoPixLog.setBloqueto(boleto.getId());
            integracaoBoletoPixLog.setDataIntegracao(LocalDateTime.now());
            EmissaoBoletoBBDTO dto = EmissaoBoletoBBDTO.from((Bloqueto)boleto, (ParametroCNAB240)parametroCNAB240);
            HttpHeaders headers = new HttpHeaders();
            headers.set(AUTHORIZATION, String.format(BEARER, this.getAccessToken()));
            headers.set("Content-Type", "application/json;charset=UTF-8");
            request = new HttpEntity((Object)dto, (MultiValueMap)headers);
            String devAppKey = this.getParametro(ParametroGeralEnum.BOLETO_BB_API_DEV_APP_KEY);
            String url = String.format("%s?gw-dev-app-key=%s", this.getParametro(ParametroGeralEnum.BOLETO_BB_EMISSAO), devAppKey);
            integracaoBoletoPixLog.setJsonRequest(this.mapper.writeValueAsString((Object)request));
            integracaoBoletoPixLog.setUrlRequest(url);
            integracaoBoletoPixLog.setHttpMethod(HttpMethod.POST);
            JsonNode response = (JsonNode)this.restTemplate.exchange(url, HttpMethod.POST, request, JsonNode.class, new Object[0]).getBody();
            integracaoBoletoPixLog.setJsonResponse(this.mapper.writeValueAsString((Object)response));
            CodigoBarrasDTO codigoBarrasDTO = new CodigoBarrasDTO();
            codigoBarrasDTO.setCodigoBarras(response.get("codigoBarraNumerico").asText());
            codigoBarrasDTO.setLinhaDigitavel(response.get("linhaDigitavel").asText());
            codigoBarrasDTO.setCampo1(StringUtils.substring((String)codigoBarrasDTO.getLinhaDigitavel(), (int)0, (int)10));
            codigoBarrasDTO.setCampo2(StringUtils.substring((String)codigoBarrasDTO.getLinhaDigitavel(), (int)10, (int)21));
            codigoBarrasDTO.setCampo3(StringUtils.substring((String)codigoBarrasDTO.getLinhaDigitavel(), (int)21, (int)32));
            codigoBarrasDTO.setCampo4(StringUtils.substring((String)codigoBarrasDTO.getLinhaDigitavel(), (int)32, (int)33));
            codigoBarrasDTO.setCampo5(StringUtils.substring((String)codigoBarrasDTO.getLinhaDigitavel(), (int)33, (int)47));
            codigoBarrasDTO.setNossoNumero(boleto.getNossoNumero());
            codigoBarrasDTO.setDvNossoNumero(boleto.getDvNossoNumero());
            codigoBarrasDTO.generateCodigoBarrasFormatadoIntervalo2Of5();
            if (response.has("qrCode") && response.get("qrCode").has("emv") && !StringUtils.isEmpty((String)response.get("qrCode").get("emv").asText())) {
                byte[] imagemQrCode = IntegracaoPixUtil.gerarImagemQrCodePix((String)response.get("qrCode").get("emv").asText());
                boleto.setCodigoQrCode(imagemQrCode);
                boleto.setTextoQrCode(response.get("qrCode").get("emv").asText());
                boleto.setTxidPix(response.get("qrCode").get("txId").asText());
            }
            CodigoBarrasDTO codigoBarrasDTO2 = codigoBarrasDTO;
            return codigoBarrasDTO2;
        }
        catch (RestException e) {
            String stackTrace = Arrays.stream(e.getStackTrace()).map(StackTraceElement::toString).collect(Collectors.joining("\n"));
            this.saveRespostaErro(request, e.getMessage(), boleto, stackTrace);
            EmissaoBoletoBBResponseDTO dtoErros = (EmissaoBoletoBBResponseDTO)this.converteErroResposta(e.getMessage(), EmissaoBoletoBBResponseDTO.class);
            String descricaoErros = Optional.ofNullable(dtoErros).filter(EmissaoBoletoBBResponseDTO::hasErro).map(EmissaoBoletoBBResponseDTO::getErrosConcatenado).orElse(e.getMessage());
            integracaoBoletoPixLog.setJsonResponse(e.getMessage());
            integracaoBoletoPixLog.setDescricaoErro(descricaoErros);
            throw new RestException(e.getStatus(), "Erro ao enviar o boleto registrado para o Banco do Brasil: " + descricaoErros, (Throwable)e);
        }
        catch (Exception e) {
            log.error("Erro ao integrar o boleto com o banco do brasil", (Throwable)e);
            String stackTrace = Arrays.stream(e.getStackTrace()).map(StackTraceElement::toString).collect(Collectors.joining("\n"));
            this.saveRespostaErro(request, e.getMessage(), boleto, stackTrace);
            integracaoBoletoPixLog.setDescricaoErro(e.getMessage());
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), (Throwable)e);
        }
        finally {
            this.salvarIntegracaoBoletoPixLog(integracaoBoletoPixLog);
        }
    }

    public IntegracaoPixResponseDTO generateQrCodePix(Bloqueto bloqueto) {
        IntegracaoBoletoPixLog integracaoBoletoPixLog = new IntegracaoBoletoPixLog(TipoIntegracaoBoletoPix.GERA_PIX);
        try {
            Validate.notNull((Object)bloqueto);
            integracaoBoletoPixLog.setBloqueto(bloqueto.getId());
            String devAppKey = this.getParametro(ParametroGeralEnum.BOLETO_BB_API_DEV_APP_KEY);
            String url = String.format("%s/arrecadacao-qrcodes?gw-dev-app-key=%s", this.getParametro(ParametroGeralEnum.BOLETO_BB_API_PIX_URL), devAppKey);
            GerarQrCodePixBBRequestDTO dto = GerarQrCodePixBBRequestDTO.from((Bloqueto)bloqueto);
            HttpHeaders headers = new HttpHeaders();
            headers.set(AUTHORIZATION, String.format(BEARER, this.getAccessToken()));
            HttpEntity requestEntity = new HttpEntity((Object)dto, (MultiValueMap)headers);
            integracaoBoletoPixLog.setJsonRequest(this.mapper.writeValueAsString((Object)requestEntity));
            integracaoBoletoPixLog.setUrlRequest(url);
            integracaoBoletoPixLog.setHttpMethod(HttpMethod.POST);
            GerarQrCodePixBBResponseDTO response = (GerarQrCodePixBBResponseDTO)this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, GerarQrCodePixBBResponseDTO.class, new Object[0]).getBody();
            integracaoBoletoPixLog.setJsonResponse(this.mapper.writeValueAsString((Object)response));
            IntegracaoPixResponseDTO resultDto = new IntegracaoPixResponseDTO();
            resultDto.setTextoQrCode(response.getQrCode());
            bloqueto.setTxidPix(response.getCodigoConciliacaoSolicitante());
            IntegracaoPixResponseDTO integracaoPixResponseDTO = resultDto;
            return integracaoPixResponseDTO;
        }
        catch (RestException e) {
            GerarQrCodePixBBResponseDTO dtoErros = (GerarQrCodePixBBResponseDTO)this.converteErroResposta(e.getMessage(), GerarQrCodePixBBResponseDTO.class);
            if (Objects.nonNull(dtoErros) && dtoErros.hasErro()) {
                integracaoBoletoPixLog.setDescricaoErro(dtoErros.getErrosConcatenado());
                integracaoBoletoPixLog.setJsonResponse(e.getMessage());
                throw new RestException(e.getStatus(), dtoErros.getErrosConcatenado());
            }
            integracaoBoletoPixLog.setDescricaoErro(e.getMessage());
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            integracaoBoletoPixLog.setDescricaoErro(e.getMessage());
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), (Throwable)e);
        }
        finally {
            this.salvarIntegracaoBoletoPixLog(integracaoBoletoPixLog);
        }
    }

    public ConsultaPixResponseDTO getPagamentoCobrancaByE2E(String endToEndIdentification, String parametroCosultaPagamento) {
        IntegracaoBoletoPixLog integracaoBoletoPixLog = new IntegracaoBoletoPixLog(TipoIntegracaoBoletoPix.CONSULTA_PIX_E2E);
        try {
            integracaoBoletoPixLog.setCodigoE2E(endToEndIdentification);
            String devAppKey = this.getParametro(ParametroGeralEnum.BOLETO_BB_API_DEV_APP_KEY);
            String url = String.format("%s/%s?gw-dev-app-key=%s", parametroCosultaPagamento, endToEndIdentification, devAppKey);
            HttpHeaders headers = new HttpHeaders();
            headers.set(AUTHORIZATION, String.format(BEARER, this.getAccessToken()));
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
            HttpMethod httpMethod = HttpMethod.GET;
            integracaoBoletoPixLog.setJsonRequest(this.mapper.writeValueAsString((Object)requestEntity));
            integracaoBoletoPixLog.setUrlRequest(url);
            integracaoBoletoPixLog.setHttpMethod(httpMethod);
            ConsultaPagCobrancaPixResponseBBDTO response = (ConsultaPagCobrancaPixResponseBBDTO)this.restTemplate.exchange(url, httpMethod, requestEntity, ConsultaPagCobrancaPixResponseBBDTO.class, new Object[0]).getBody();
            integracaoBoletoPixLog.setJsonResponse(this.mapper.writeValueAsString((Object)response));
            integracaoBoletoPixLog.setTxid(response.getTxid());
            ConsultaPixResponseDTO consultaPixResponseDTO = response.toConsultaPixResponseDTO();
            return consultaPixResponseDTO;
        }
        catch (RestException e) {
            ConsultaPagCobrancaPixResponseBBDTO dtoErros = (ConsultaPagCobrancaPixResponseBBDTO)this.converteErroResposta(e.getMessage(), ConsultaPagCobrancaPixResponseBBDTO.class);
            if (Objects.nonNull(dtoErros) && dtoErros.hasErro()) {
                integracaoBoletoPixLog.setDescricaoErro(dtoErros.getErrosConcatenado());
                integracaoBoletoPixLog.setJsonResponse(e.getMessage());
                throw new RestException(e.getStatus(), dtoErros.getErrosConcatenado());
            }
            integracaoBoletoPixLog.setDescricaoErro(e.getMessage());
            throw new RestException(e.getStatus(), e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            integracaoBoletoPixLog.setDescricaoErro(e.getMessage());
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), (Throwable)e);
        }
        finally {
            this.salvarIntegracaoBoletoPixLog(integracaoBoletoPixLog);
        }
    }

    public ConsultaPixResponseDTO getPagamentoByE2E(String endToendIdentification) {
        IntegracaoBoletoPixLog integracaoBoletoPixLog = new IntegracaoBoletoPixLog(TipoIntegracaoBoletoPix.CONSULTA_PIX_E2E);
        try {
            integracaoBoletoPixLog.setCodigoE2E(endToendIdentification);
            String devAppKey = this.getParametro(ParametroGeralEnum.BOLETO_BB_API_DEV_APP_KEY);
            String url = String.format("%s/arrecadacao-qrcodes/pagamentos/%s?gw-dev-app-key=%s", this.getParametro(ParametroGeralEnum.BOLETO_BB_API_PIX_URL), endToendIdentification, devAppKey);
            HttpHeaders headers = new HttpHeaders();
            headers.set(AUTHORIZATION, String.format(BEARER, this.getAccessToken()));
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
            HttpMethod httpMethod = HttpMethod.GET;
            integracaoBoletoPixLog.setJsonRequest(this.mapper.writeValueAsString((Object)requestEntity));
            integracaoBoletoPixLog.setUrlRequest(url);
            integracaoBoletoPixLog.setHttpMethod(httpMethod);
            ConsultaPagamentoPixResponseBBDTO response = (ConsultaPagamentoPixResponseBBDTO)this.restTemplate.exchange(url, httpMethod, requestEntity, ConsultaPagamentoPixResponseBBDTO.class, new Object[0]).getBody();
            integracaoBoletoPixLog.setJsonResponse(this.mapper.writeValueAsString((Object)response));
            integracaoBoletoPixLog.setTxid(response.getCodigoConciliacaoRecebedor());
            ConsultaPixResponseDTO consultaPixResponseDTO = response.toConsultaPixE2EResponseDTO();
            return consultaPixResponseDTO;
        }
        catch (RestException e) {
            ConsultaPagamentoPixResponseBBDTO dtoErros = (ConsultaPagamentoPixResponseBBDTO)this.converteErroResposta(e.getMessage(), ConsultaPagamentoPixResponseBBDTO.class);
            if (Objects.nonNull(dtoErros) && dtoErros.hasErro()) {
                integracaoBoletoPixLog.setDescricaoErro(dtoErros.getErrosConcatenado());
                integracaoBoletoPixLog.setJsonResponse(e.getMessage());
                throw new RestException(e.getStatus(), dtoErros.getErrosConcatenado());
            }
            integracaoBoletoPixLog.setDescricaoErro(e.getMessage());
            throw new RestException(e.getStatus(), e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            integracaoBoletoPixLog.setDescricaoErro(e.getMessage());
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), (Throwable)e);
        }
        finally {
            this.salvarIntegracaoBoletoPixLog(integracaoBoletoPixLog);
        }
    }

    public ConsultaPixResponseDTO getPagamentoByTxid(String txid, String numeroConvenio) {
        IntegracaoBoletoPixLog integracaoBoletoPixLog = new IntegracaoBoletoPixLog(TipoIntegracaoBoletoPix.CONSULTA_PIX_TXID);
        try {
            integracaoBoletoPixLog.setTxid(txid);
            String devAppKey = this.getParametro(ParametroGeralEnum.BOLETO_BB_API_DEV_APP_KEY);
            String url = String.format("%s/arrecadacao-qrcodes/%s?numeroConvenio=%s&gw-dev-app-key=%s", this.getParametro(ParametroGeralEnum.BOLETO_BB_API_PIX_URL), txid, numeroConvenio, devAppKey);
            HttpHeaders headers = new HttpHeaders();
            headers.set(AUTHORIZATION, String.format(BEARER, this.getAccessToken()));
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
            HttpMethod httpMethod = HttpMethod.GET;
            integracaoBoletoPixLog.setJsonRequest(this.mapper.writeValueAsString((Object)requestEntity));
            integracaoBoletoPixLog.setUrlRequest(url);
            integracaoBoletoPixLog.setHttpMethod(httpMethod);
            ConsultaQrCodePagamentoPixResponseBBDTO response = (ConsultaQrCodePagamentoPixResponseBBDTO)this.restTemplate.exchange(url, httpMethod, requestEntity, ConsultaQrCodePagamentoPixResponseBBDTO.class, new Object[0]).getBody();
            integracaoBoletoPixLog.setJsonResponse(this.mapper.writeValueAsString((Object)response));
            ConsultaPixResponseDTO responseDTO = response.toConsultaPixE2EResponseDTO();
            responseDTO.setTxid(txid);
            responseDTO.setPagamentoEncontrado(SimNao.SIM.getSigla());
            Optional boleto = this.bloquetoService.findByCodigoBarras(response.getCodigoGuiaRecebimento());
            if (boleto.isPresent()) {
                responseDTO.setIdkeyBoleto(((Bloqueto)boleto.get()).getId());
                responseDTO.setEntidadeBoleto(((Bloqueto)boleto.get()).getEntidade());
                responseDTO.setExercicioBoleto(((Bloqueto)boleto.get()).getExercicioBloqueto());
                responseDTO.setNumeroBoleto(((Bloqueto)boleto.get()).getBloqueto());
            }
            ConsultaPixResponseDTO consultaPixResponseDTO = responseDTO;
            return consultaPixResponseDTO;
        }
        catch (RestException e) {
            ConsultaPagamentoPixResponseBBDTO dtoErros = (ConsultaPagamentoPixResponseBBDTO)this.converteErroResposta(e.getMessage(), ConsultaPagamentoPixResponseBBDTO.class);
            if (Objects.nonNull(dtoErros) && dtoErros.hasErro()) {
                integracaoBoletoPixLog.setDescricaoErro(dtoErros.getErrosConcatenado());
                integracaoBoletoPixLog.setJsonResponse(e.getMessage());
                throw new RestException(e.getStatus(), dtoErros.getErrosConcatenado());
            }
            integracaoBoletoPixLog.setDescricaoErro(e.getMessage());
            throw new RestException(e.getStatus(), e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            integracaoBoletoPixLog.setDescricaoErro(e.getMessage());
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), (Throwable)e);
        }
        finally {
            this.salvarIntegracaoBoletoPixLog(integracaoBoletoPixLog);
        }
    }

    public ConsultaPixResponseDTO getPagamento(Optional<String> txid, Optional<String> endToendIdentification, Convenio convenio) {
        String parametroCosultaPagamento = this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.BOLETO_BB_CONSULTA_PG_COBRANCA, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        if (!parametroCosultaPagamento.isEmpty() && endToendIdentification.isPresent()) {
            return this.getPagamentoCobrancaByE2E(endToendIdentification.get(), parametroCosultaPagamento);
        }
        if (txid.isPresent()) {
            return this.getPagamentoByTxid(txid.get(), convenio.getNumeroConvenio());
        }
        if (endToendIdentification.isPresent()) {
            ConsultaPixResponseDTO pagamentoByE2E = this.getPagamentoByE2E(endToendIdentification.get());
            return this.getPagamentoByTxid(pagamentoByE2E.getTxid(), convenio.getNumeroConvenio());
        }
        throw new RestException(HttpStatus.NOT_FOUND, "\u00c9 necess\u00e1rio informar o e2eId ou txid para consultar.");
    }

    private void salvarIntegracaoBoletoPixLog(IntegracaoBoletoPixLog integracaoBoletoPixLog) {
        new TransactionTemplate(this.transactionManager, this.transactionDefinition).execute(status -> {
            try {
                return (IntegracaoBoletoPixLog)this.integracaoBoletoPixLogRepository.save((Object)integracaoBoletoPixLog);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
    }

    private void saveRespostaErro(HttpEntity<EmissaoBoletoBBDTO> request, String response, Bloqueto boleto, String observacao) {
        new TransactionTemplate(this.transactionManager, this.transactionDefinition).execute(status -> {
            try {
                ErroBoletoRegistroOnline erroRegistroBoletoOnlineEntity = new ErroBoletoRegistroOnline();
                erroRegistroBoletoOnlineEntity.setRequest(Objects.nonNull(request) ? this.mapper.writeValueAsBytes((Object)request) : null);
                erroRegistroBoletoOnlineEntity.setResponse((byte[])Optional.ofNullable(response).map(String::getBytes).orElse(null));
                erroRegistroBoletoOnlineEntity.setDataHoraIntegracao(LocalDateTime.now());
                erroRegistroBoletoOnlineEntity.setIdBoleto(boleto.getId());
                erroRegistroBoletoOnlineEntity.setDetalhes(observacao);
                return (ErroBoletoRegistroOnline)this.erroBoletoRegistradoOnlineRepository.save((Object)erroRegistroBoletoOnlineEntity);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
    }

    private <T> T converteErroResposta(String json, Class<T> valueType) {
        try {
            return (T)this.mapper.readValue(json, valueType);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    private String getParametro(ParametroGeralEnum parametroGeralEnum) {
        try {
            String valor = this.parametroGeralService.getParamValueAsString(parametroGeralEnum, ModuloEnum.MODULO_TRIBUTARIO.getValue());
            if (StringUtils.isEmpty((String)valor)) {
                throw new RestException(HttpStatus.BAD_REQUEST, String.format("O par\u00e2metro %s n\u00e3o foi configurado.", parametroGeralEnum.name()));
            }
            return valor;
        }
        catch (ParametroNaoEncontradoException e) {
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    public String getAccessToken() {
        String oauthUrl = this.getParametro(ParametroGeralEnum.BOLETO_BB_OAUTH_URL);
        String clientId = this.getParametro(ParametroGeralEnum.BOLETO_BB_OAUTH_CLIENTID);
        String clientSecret = this.getParametro(ParametroGeralEnum.BOLETO_BB_OAUTH_CLIENTSECRET);
        String authorizationBase64 = Base64.getEncoder().encodeToString((clientId + ":" + clientSecret).getBytes());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.set(AUTHORIZATION, String.format("Basic %s", authorizationBase64));
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"grant_type", (Object)"client_credentials");
        HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
        JsonNode response = (JsonNode)this.restTemplate.exchange(oauthUrl, HttpMethod.POST, httpEntity, JsonNode.class, new Object[0]).getBody();
        if (Objects.isNull(response) || !response.has("access_token")) {
            throw new RestException(HttpStatus.BAD_REQUEST, "N\u00e3o foi poss\u00edvel buscar o token.");
        }
        return response.get("access_token").asText();
    }

    public void beforeGenerateBoleto(Bloqueto boleto) {
        if (Objects.isNull(boleto.getExercicioBloqueto())) {
            throw new EloValidationException("\u00c9 necess\u00e1rio o exerc\u00edcio do bloqueto para gerar o nosso n\u00famero.");
        }
        if (Objects.isNull(boleto.getNossoNumero())) {
            String nossoNumero = this.gerarNossoNumero(boleto);
            String dv = this.gerarDVNossoNumero(nossoNumero);
            boleto.setNossoNumero(nossoNumero);
            boleto.setDvNossoNumero(dv);
        }
    }

    private String gerarNossoNumero(Bloqueto boleto) {
        return StringUtils.leftPad((String)boleto.getModeloBloqueto().getConvenio().getNumeroConvenio(), (int)7, (String)"0") + boleto.getEntidade() + boleto.getExercicioBloqueto().toString().substring(2, 4) + StringUtils.leftPad((String)StringUtils.substring((String)boleto.getBloqueto().toString(), (int)0, (int)7), (int)7, (String)"0");
    }

    private String gerarDVNossoNumero(String nossoNumero) {
        Integer nossoNumeroDV = GeradorDigitoVerificador.geradorDigitoVerificadorMod11((String)nossoNumero);
        if (nossoNumeroDV > 9) {
            nossoNumeroDV = 0;
        }
        return String.valueOf(nossoNumeroDV);
    }

    public TipoCodigoBarras getTipoCodigoBarras() {
        return TipoCodigoBarras.BOLETO_BANCARIO_BB_CONVENIO_7_POSICOES;
    }

    public Long getCodigoBanco() {
        return Banco.CODIGO_BANCO_BRASIL;
    }

    @Generated
    public IntegracaoBoletoBBService(RestTemplate restTemplate, ParametroGeralService parametroGeralService, ObjectMapper mapper, IntegracaoBoletoPixLogRepository integracaoBoletoPixLogRepository, PlatformTransactionManager transactionManager, ParametroCNAB240Repository parametroCNAB240Repository, BancoRepository bancoRepository, ErroBoletoRegistradoOnlineRepository erroBoletoRegistradoOnlineRepository, FormaPagamentoRepository formaPagamentoRepository, BloquetoService bloquetoService) {
        this.restTemplate = restTemplate;
        this.parametroGeralService = parametroGeralService;
        this.mapper = mapper;
        this.integracaoBoletoPixLogRepository = integracaoBoletoPixLogRepository;
        this.transactionManager = transactionManager;
        this.parametroCNAB240Repository = parametroCNAB240Repository;
        this.bancoRepository = bancoRepository;
        this.erroBoletoRegistradoOnlineRepository = erroBoletoRegistradoOnlineRepository;
        this.formaPagamentoRepository = formaPagamentoRepository;
        this.bloquetoService = bloquetoService;
    }
}

