/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto;

import br.com.elotech.core.exception.RestException;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.itextpdf.text.pdf.qrcode.EncodeHintType;
import com.itextpdf.text.pdf.qrcode.ErrorCorrectionLevel;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.commons.lang.Validate;
import org.springframework.http.HttpStatus;

public class IntegracaoPixUtil {
    public static byte[] gerarImagemQrCodePix(String pix) {
        try {
            Validate.notNull((Object)pix, (String)"O texto pix \u00e9 obrigat\u00f3rio para gerar a imagem QRCode.");
            HashMap<EncodeHintType, ErrorCorrectionLevel> hintMap = new HashMap<EncodeHintType, ErrorCorrectionLevel>();
            hintMap.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
            BitMatrix matrix = new MultiFormatWriter().encode(new String(pix.getBytes("UTF-8"), "UTF-8"), BarcodeFormat.QR_CODE, 300, 300, hintMap);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            MatrixToImageWriter.writeToStream((BitMatrix)matrix, (String)"jpg", (OutputStream)out);
            return out.toByteArray();
        }
        catch (Exception e) {
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }
}

