/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto;

import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoBoletoPixLog;
import br.com.elotech.tributos.dto.integracaoboleto.ConsultaPixResponseDTO;
import br.com.elotech.tributos.dto.integracaoboleto.IntegracaoPixResponseDTO;
import br.com.elotech.tributos.dto.integracaoboleto.itau.CodigoBarrasQrCodePixItauDTO;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoPixUtil;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.NotImplementedException;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;

public interface IntegracaoPix {
    public IntegracaoPixResponseDTO generateQrCodePix(Bloqueto var1);

    default public ConsultaPixResponseDTO getPagamentoByE2E(String endToendIdentification) {
        throw new NotImplementedException();
    }

    default public ConsultaPixResponseDTO getPagamentoByTxid(String txid, String numeroConvenio) {
        throw new NotImplementedException();
    }

    default public ConsultaPixResponseDTO getPagamento(Optional<String> txid, Optional<String> endToendIdentification, Convenio convenio) {
        throw new NotImplementedException();
    }

    public Long getCodigoBanco();

    default public void beforeGenerateQrCodePix(Bloqueto boleto) {
    }

    default public void afterGenerateQrCodePix(Bloqueto boleto, IntegracaoPixResponseDTO response) {
        if (Objects.nonNull(response.getTextoQrCode())) {
            byte[] imagemQrCode = IntegracaoPixUtil.gerarImagemQrCodePix((String)response.getTextoQrCode());
            boleto.setCodigoQrCode(imagemQrCode);
            boleto.setTextoQrCode(response.getTextoQrCode());
            boleto.setTxidPix(response.getTxid());
        }
    }

    default public IntegracaoBoletoPixLog updateCodigoBarrasBoleto(CodigoBarrasQrCodePixItauDTO boleto) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException {
        throw new NotImplementedException();
    }
}

