/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.impl;

import br.com.elotech.core.common.dto.EntidadeInfo;
import br.com.elotech.core.common.service.EntidadeService;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Bairro;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.dto.EntidadeDTO;
import br.com.elotech.tributos.repository.BairroRepository;
import br.com.elotech.tributos.repository.EntidadeRepository;
import br.com.elotech.tributos.repository.LogradouroRepository;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class EntidadeServiceImpl
extends CrudService<Entidade, Long>
implements EntidadeService {
    private final EntidadeRepository entidades;
    private final BairroRepository bairroRepository;
    private final LogradouroRepository logradouroRepository;

    public EntidadeServiceImpl(EntidadeRepository entidades, BairroRepository bairroRepository, LogradouroRepository logradouroRepository) {
        this.entidades = entidades;
        this.bairroRepository = bairroRepository;
        this.logradouroRepository = logradouroRepository;
    }

    public Optional<Entidade> getEntidadePrincipal() {
        List entidadesPrincipais = this.entidades.findEntidadesPrincipais();
        return entidadesPrincipais.stream().findFirst();
    }

    public EntidadeInfo findEntidadePrincipal() {
        EntidadeInfo dto = new EntidadeInfo();
        Entidade entidade = this.getEntidadePrincipal().orElse(null);
        if (Objects.nonNull(entidade)) {
            dto.setId(entidade.getId());
            dto.setDescricao(entidade.getNome());
            dto.setPrincipal(Boolean.valueOf(true));
        }
        return dto;
    }

    public Optional<EntidadeDTO> getInfoEntidadePrincipal() {
        Optional entidade = this.getEntidadePrincipal();
        return entidade.map(EntidadeDTO::from).map(dto -> dto.atualizaBairro(this.getDescricaoBairro((Entidade)entidade.get()))).map(dto -> dto.atualizaLogradouro(this.getDescricaoLogradouro((Entidade)entidade.get())));
    }

    private String getDescricaoBairro(Entidade entidade) {
        return this.bairroRepository.findByCidadeIdAndBairro(entidade.getCidade().getId(), entidade.getBairro()).map(Bairro::getDescricao).orElse(null);
    }

    private String getDescricaoLogradouro(Entidade entidade) {
        return this.logradouroRepository.findByCidadeIdAndLogradouro(entidade.getCidade().getId(), entidade.getLogradouro()).map(Logradouro::getDescricao).orElse(null);
    }
}

