/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.exception;

import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.TipoCadastro;
import java.math.BigDecimal;

public class GeracaoDebitoManualException
extends RuntimeException {
    private static final String CADASTRO_NOT_FOUND = "Cadastro %d/%d n\u00e3o encontrado.";
    private static final String FORMACORRECAO_NOT_FOUND = "Forma de corre\u00e7\u00e3o %d n\u00e3o encontrada.";
    private static final String DIVIDA_NOT_FOUND = "D\u00edvida %d n\u00e3o encontrada no exerc\u00edcio %d e entidade %d.";
    private static final String VALOR_PARCELA_DIFERENTE_TRIBUTO = "Valor total dos tributos %.2f difere do valor das parcelas %.2f.";
    private static final String TRIBUTO_SEM_RELACAO_DIVIDA = "Tributo %s informado n\u00e3o pertence a d\u00edvida %d.";
    private static final String TRIBUTO_SEM_VALOR = "N\u00e3o existem valores lan\u00e7ados no tributo.";
    private static final String TRIBUTO_DUPLICADO = "Tributo %s duplicado.";

    public GeracaoDebitoManualException(String message) {
        super(message);
    }

    public static GeracaoDebitoManualException cadastroNotFound(Long tipoCadastro, Long cadastroGeral) {
        return new GeracaoDebitoManualException(String.format(CADASTRO_NOT_FOUND, tipoCadastro, cadastroGeral));
    }

    public static GeracaoDebitoManualException dividaNotFound(Long entidade, Long exercicio, Long divida) {
        return new GeracaoDebitoManualException(String.format(DIVIDA_NOT_FOUND, divida, exercicio, entidade));
    }

    public static GeracaoDebitoManualException valorParcelaDifereTributo(BigDecimal valorTributo, BigDecimal valorParcela) {
        return new GeracaoDebitoManualException(String.format(VALOR_PARCELA_DIFERENTE_TRIBUTO, valorTributo, valorParcela));
    }

    public static GeracaoDebitoManualException formaCorrecaoNotFound(Long formaCorrecao) {
        return new GeracaoDebitoManualException(String.format(FORMACORRECAO_NOT_FOUND, formaCorrecao));
    }

    public static GeracaoDebitoManualException tributoSemRelacaoDivida(String tributo, Long divida) {
        return new GeracaoDebitoManualException(String.format(TRIBUTO_SEM_RELACAO_DIVIDA, tributo, divida));
    }

    public static GeracaoDebitoManualException tributoSemValor() {
        return new GeracaoDebitoManualException(TRIBUTO_SEM_VALOR);
    }

    public static GeracaoDebitoManualException tributoDuplicado(String tributo) {
        return new GeracaoDebitoManualException(String.format(TRIBUTO_DUPLICADO, tributo));
    }

    public static GeracaoDebitoManualException tributoNaoExisteNoDebito(String tributo, Debito debito) {
        return new GeracaoDebitoManualException(String.format("O tributo %s n\u00e3o est\u00e1 presente no d\u00e9bito j\u00e1 existente %d", tributo, debito.getId()));
    }

    public static GeracaoDebitoManualException parcelaNotFound(Long parcela) {
        return new GeracaoDebitoManualException(String.format("A parcela %d n\u00e3o est\u00e1 presente no d\u00e9bito manual informado", parcela));
    }

    public static GeracaoDebitoManualException tipoCadastroInvalido(TipoCadastro tipoCadastro) {
        return new GeracaoDebitoManualException(String.format("O Tipo de cadastro %s n\u00e3o permite emiss\u00e3o de d\u00e9bito de ISS.", tipoCadastro.getDescricao()));
    }
}

