/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.documento.cda;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.DocumentoItemDividaAtiva;
import br.com.elotech.tributos.domain.DocumentoItemDividaAtivaId;
import br.com.elotech.tributos.domain.DocumentoPessoa;
import br.com.elotech.tributos.domain.DocumentoTipo;
import br.com.elotech.tributos.domain.EntidadeTributacao;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.Livro;
import br.com.elotech.tributos.domain.LivroId;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.SituacaoDocumento;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoDivida;
import br.com.elotech.tributos.domain.TipoDocumentoEnum;
import br.com.elotech.tributos.domain.documento.cda.LoteCdaItem;
import br.com.elotech.tributos.domain.documento.cda.LoteCdaItemDetalhe;
import br.com.elotech.tributos.domain.documento.cda.LoteCdaItemPessoa;
import br.com.elotech.tributos.dto.CertidaoDividaAtivaAvulsaDTO;
import br.com.elotech.tributos.dto.DebitoDividaAtivaAvulsaDTO;
import br.com.elotech.tributos.dto.DebitoGeracaoDividaAtivaAvulsaDTO;
import br.com.elotech.tributos.dto.DividaDTO;
import br.com.elotech.tributos.dto.acrescimo.AcrescimoDTO;
import br.com.elotech.tributos.repository.SequenceGeneratorRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.DividaService;
import br.com.elotech.tributos.service.DocumentoService;
import br.com.elotech.tributos.service.DocumentoTipoService;
import br.com.elotech.tributos.service.EntidadeTributacaoService;
import br.com.elotech.tributos.service.FormaPagamentoService;
import br.com.elotech.tributos.service.PessoaService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import br.com.elotech.tributos.util.ListUtils;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.persistence.EntityManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class GeraCertidaoDividaAtivaService {
    private final CadastroGeralService cadastroGeralService;
    private final EntityManager entityManager;
    private final ContextService contextService;
    private final EntidadeTributacaoService entidadeTributacaoService;
    private final DocumentoTipoService documentoTipoService;
    private final DebitoService debitoService;
    private final DividaService dividaService;
    private final PessoaService pessoaService;
    private final DocumentoService documentoService;
    private final CalculoAcrescimoService calculoAcrescimoService;
    private final FormaPagamentoService formaPagamentoService;
    private final SequenceGeneratorRepository sequenceGeneratorRepository;

    GeraCertidaoDividaAtivaService(CadastroGeralService cadastroGeralService, EntityManager entityManager, ContextService contextService, EntidadeTributacaoService entidadeTributacaoService, DocumentoTipoService documentoTipoService, DebitoService debitoService, DividaService dividaService, PessoaService pessoaService, DocumentoService documentoService, CalculoAcrescimoService calculoAcrescimoService, FormaPagamentoService formaPagamentoService, SequenceGeneratorRepository sequenceGeneratorRepository) {
        this.cadastroGeralService = cadastroGeralService;
        this.entityManager = entityManager;
        this.contextService = contextService;
        this.entidadeTributacaoService = entidadeTributacaoService;
        this.documentoTipoService = documentoTipoService;
        this.debitoService = debitoService;
        this.dividaService = dividaService;
        this.pessoaService = pessoaService;
        this.documentoService = documentoService;
        this.calculoAcrescimoService = calculoAcrescimoService;
        this.formaPagamentoService = formaPagamentoService;
        this.sequenceGeneratorRepository = sequenceGeneratorRepository;
    }

    public Documento gerarCertidaoDividaAtiva(LoteCdaItem loteCdaItem, Long entidade, Long exercicio, DocumentoTipo documentoTipo, EntidadeTributacao entidadeTributacao, LocalDate dataEmissao) {
        Documento documento = new Documento();
        documento.setEntidade(entidade);
        documento.setTipoDocumento(documentoTipo.getId());
        documento.setExercicio(exercicio);
        documento.setDocumentoTipo(documentoTipo);
        documento.setDataEmissao(dataEmissao);
        documento.setEntidadeTributacao(entidadeTributacao);
        documento.setTipoCadastro(loteCdaItem.getCadastroGeral().getTipoCadastro());
        documento.setCadastroGeral(loteCdaItem.getCadastroGeral());
        documento.setPessoa(this.cadastroGeralService.getResponsavelPrincipal(loteCdaItem.getCadastroGeral()));
        documento.setCnpjCpf(documento.getPessoa().getCnpjCpf());
        documento.setSituacao(SituacaoDocumento.aberto());
        documento.setUsuario(SecurityUtils.getUserAise());
        for (LoteCdaItemDetalhe item : loteCdaItem.getItemDetalhes()) {
            DocumentoItemDividaAtiva itemDividaAtiva = new DocumentoItemDividaAtiva();
            DebitoParcela debitoParcela = item.getParcelaTributo().getDebitoParcela();
            itemDividaAtiva.setLivro((Livro)this.entityManager.getReference(Livro.class, (Object)LivroId.of((Long)entidade, (Long)debitoParcela.getExercicioLivro(), (Long)debitoParcela.getLivro())));
            itemDividaAtiva.setNumeroInscricao(debitoParcela.getNumeroInscricao());
            itemDividaAtiva.setNumeroFolha(debitoParcela.getNumeroFolha());
            itemDividaAtiva.setTipoCadastro(item.getParcelaTributo().getTipoCadastro());
            itemDividaAtiva.setCadastroGeral(item.getParcelaTributo().getCadastroGeral());
            itemDividaAtiva.setExercicioDebito(item.getParcelaTributo().getExercicio());
            itemDividaAtiva.setTributo(item.getParcelaTributo().getTributo());
            itemDividaAtiva.setDivida(debitoParcela.getDebito().getDivida());
            itemDividaAtiva.setCodigoDivida(debitoParcela.getDebito().getDivida().getDivida());
            itemDividaAtiva.setSubDivida(item.getParcelaTributo().getSubDivida());
            itemDividaAtiva.setParcela(item.getParcelaTributo().getParcela());
            itemDividaAtiva.setValor(item.getValor());
            itemDividaAtiva.setValorMulta(item.getValorMulta());
            itemDividaAtiva.setValorJuros(item.getValorJuros());
            itemDividaAtiva.setValorCorrecao(item.getValorCorrecao());
            documento.getDocumentoItemDividaAtivas().add(itemDividaAtiva);
        }
        loteCdaItem.getItemPessoas().stream().map(LoteCdaItemPessoa::getPessoa).map(pessoa -> DocumentoPessoa.of((Pessoa)pessoa, (Documento)documento)).forEach(documento.getDocumentoPessoas()::add);
        return documento;
    }

    public Documento gerarCertidaoDividaAtivaAvulsa(CertidaoDividaAtivaAvulsaDTO certidaoDividaAtivaAvulsa) {
        Long entidade = this.contextService.getEntidadePrincipal();
        CadastroGeral cadastroGeral = this.getCadastroGeralByCertidaoDividaAtivaAvulsa(certidaoDividaAtivaAvulsa);
        ArrayList debitoGeracaoDividaAtivaAvulsas = new ArrayList();
        for (DebitoDividaAtivaAvulsaDTO debito : certidaoDividaAtivaAvulsa.getDebitos()) {
            debitoGeracaoDividaAtivaAvulsas.addAll(this.debitoService.findDebitogeracaoCDAAvulsa(debito, entidade));
        }
        Documento documento = this.generateDocumentoDividaAtivaAvulsa(debitoGeracaoDividaAtivaAvulsas, entidade, cadastroGeral, certidaoDividaAtivaAvulsa.getDataReferencia(), certidaoDividaAtivaAvulsa.getNumeroCertidao(), certidaoDividaAtivaAvulsa.getAnoCertidao());
        if (this.documentoService.existsDocumentoCDA(certidaoDividaAtivaAvulsa.getNumeroCertidao(), certidaoDividaAtivaAvulsa.getAnoCertidao()).booleanValue()) {
            return (Documento)this.documentoService.save((EloEntity)this.substituirDocumento(certidaoDividaAtivaAvulsa, documento), null);
        }
        return (Documento)this.documentoService.save((EloEntity)documento, null);
    }

    private CadastroGeral getCadastroGeralByCertidaoDividaAtivaAvulsa(CertidaoDividaAtivaAvulsaDTO certidaoDividaAtivaAvulsa) {
        TipoCadastro tipoCadastro = TipoCadastro.fromValue((Long)certidaoDividaAtivaAvulsa.getDebitos().stream().findFirst().map(DebitoDividaAtivaAvulsaDTO::getTipoCadastro).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi encontrado tipo cadastro %s", certidaoDividaAtivaAvulsa.getDebitos().stream().findFirst()))));
        Long cadastro = certidaoDividaAtivaAvulsa.getDebitos().stream().findFirst().map(DebitoDividaAtivaAvulsaDTO::getCadastroGeral).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi encontrado cadastro geral %s", certidaoDividaAtivaAvulsa.getDebitos().stream().findFirst())));
        return (CadastroGeral)this.cadastroGeralService.findByTipoCadastroAndCadastroGeral(tipoCadastro, cadastro).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi encontrado cadastroGeral com cadastro geral: %d e tipo cadastro: %d ", tipoCadastro.getValue(), cadastro)));
    }

    private Documento generateDocumentoDividaAtivaAvulsa(List<DebitoGeracaoDividaAtivaAvulsaDTO> debitoGeracaoDividaAtivaAvulsas, Long entidade, CadastroGeral cadastroGeral, LocalDate dataReferencia, Long numeroCertidao, Long anoCertidao) {
        EntidadeTributacao entidadeTributacao = this.entidadeTributacaoService.findByEntidadeIdAndExercicio(entidade, anoCertidao);
        DocumentoTipo documentoTipo = this.documentoTipoService.findById(TipoDocumentoEnum.CERTIDAO_DIVIDA_ATIVA.getCodigo());
        Long idPessoa = debitoGeracaoDividaAtivaAvulsas.stream().findFirst().map(DebitoGeracaoDividaAtivaAvulsaDTO::getPessoa).orElseThrow(() -> new EloValidationException("N\u00e3o foi encontrado pessoa"));
        Pessoa responsavel = (Pessoa)this.pessoaService.findById(idPessoa).orElseThrow(() -> new EloValidationException(String.format("Pessoa com id: %d n\u00e3o encontrado", idPessoa)));
        Pessoa pessoa = this.cadastroGeralService.getResponsavelPrincipal(cadastroGeral);
        Documento documento = Documento.to((Long)entidade, (CadastroGeral)cadastroGeral, (LocalDate)dataReferencia, (Long)numeroCertidao, (Long)anoCertidao, (Pessoa)pessoa, (EntidadeTributacao)entidadeTributacao, (DocumentoTipo)documentoTipo);
        ListUtils.forEachWithCounter(debitoGeracaoDividaAtivaAvulsas, (index, item) -> {
            Divida divida = (Divida)this.dividaService.findByEntidadeAndExercicioAndDivida(item.getEntidade(), item.getExercicio(), item.getGuiaRecolhimento()).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi encontrado D\u00edvida com entidade: %d, exerc\u00edcio: %d e guia recolhimento: %d", item.getEntidade(), item.getExercicio(), item.getGuiaRecolhimento())));
            Livro livro = (Livro)this.entityManager.getReference(Livro.class, (Object)LivroId.of((Long)entidade, (Long)item.getExercicioLivro(), (Long)item.getLivro()));
            DocumentoItemDividaAtivaId documentoItemDividaAtivaId = new DocumentoItemDividaAtivaId();
            documentoItemDividaAtivaId.setDocumento(numeroCertidao);
            documentoItemDividaAtivaId.setTipoDocumento(documentoTipo.getId());
            documentoItemDividaAtivaId.setEntidade(entidade);
            documentoItemDividaAtivaId.setExercicio(anoCertidao);
            documentoItemDividaAtivaId.setSequenciaItem(index);
            DocumentoItemDividaAtiva itemDividaAtiva = DocumentoItemDividaAtiva.to((Livro)livro, (DebitoGeracaoDividaAtivaAvulsaDTO)item, (Divida)divida, (DocumentoItemDividaAtivaId)documentoItemDividaAtivaId);
            documento.getDocumentoItemDividaAtivas().add(itemDividaAtiva);
        });
        this.calcularAcrescimosGeracaoCda(dataReferencia, debitoGeracaoDividaAtivaAvulsas, entidade);
        documento.getDocumentoPessoas().add(DocumentoPessoa.of((Pessoa)responsavel, (Documento)documento));
        documento.setCadastroGeral(cadastroGeral);
        return documento;
    }

    private void calcularAcrescimosGeracaoCda(LocalDate dataReferencia, List<DebitoGeracaoDividaAtivaAvulsaDTO> itens, Long entidade) {
        FormaPagamento formaPagamento = this.formaPagamentoService.findFormaPagamentoPadrao(Optional.empty());
        itens.forEach(cda -> {
            DividaDTO dividaDTO = new DividaDTO();
            dividaDTO.setDivida(cda.getGuiaRecolhimento());
            dividaDTO.setTipoDivida(TipoDivida.fromValue((String)cda.getTipoguiarecolhimento()));
            dividaDTO.setApelido(cda.getApelido());
            dividaDTO.setEntidade(cda.getEntidade());
            dividaDTO.setExercicio(cda.getExercicio());
            dividaDTO.setInativa(cda.getInativo());
            dividaDTO.setApelido(cda.getApelido());
            dividaDTO.setId(cda.getDividaId());
            AcrescimoDTO acrescimo = AcrescimoDTO.of((DebitoGeracaoDividaAtivaAvulsaDTO)cda, (Long)formaPagamento.getId(), (DividaDTO)dividaDTO);
            acrescimo.setEntidade(entidade);
            acrescimo.setDataReferencia(dataReferencia);
            acrescimo.setCalculaValorDesconto(Boolean.FALSE);
            this.calculoAcrescimoService.calculaAcrescimos(acrescimo, Optional.empty());
            cda.setValor(acrescimo.getValor());
            cda.setValorMulta(acrescimo.getValorMulta());
            cda.setValorJuros(acrescimo.getValorJuros());
            cda.setValorCorrecao(acrescimo.getValorCorrecao());
        });
    }

    private Documento substituirDocumento(CertidaoDividaAtivaAvulsaDTO certidaoDividaAtivaAvulsa, Documento documento) {
        Documento documentoEntity = this.documentoService.findDocumentoByEntidadeAndExercicioAndTipoDocumentoAndDocumento(documento.getEntidade(), certidaoDividaAtivaAvulsa.getAnoCertidao(), documento.getTipoDocumento(), certidaoDividaAtivaAvulsa.getNumeroCertidao());
        this.documentoService.removeDividaAtivaPeticao(documentoEntity.getId());
        documento.setId(documentoEntity.getId());
        return documento;
    }
}

