/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.batch.simam;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.util.DateUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDate;
import java.util.Date;
import java.util.Objects;
import lombok.Generated;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class EstornoDeducaoCreditoJobStarter {
    private final ObjectMapper objectMapper;
    private final JobLauncher jobLauncher;
    private final JobExplorer jobExplorer;
    @Qualifier(value="estornoDeducaoCreditoBatchJob")
    private final Job estornoDeducaoCreditoBatchJob;

    public JobExecution startJob(Long entidade, LocalDate dataInicial, LocalDate dataFinal) throws Exception {
        Boolean existeJobNaoFinalizadoComMesmoFiltro = this.jobExplorer.findRunningJobExecutions(JobType.SIMAM_ESTORNO_DEDUCAO_CREDITO_NAO_INSCRITO_EM_DA.getTipo()).stream().anyMatch(job -> dataInicial.equals(DateUtils.dateToLocalDate((Date)Objects.requireNonNull(job.getJobParameters().getDate("dataInicial")))) && dataFinal.equals(DateUtils.dateToLocalDate((Date)Objects.requireNonNull(job.getJobParameters().getDate("dataFinal")))) && entidade.equals(Objects.requireNonNull(job.getJobParameters().getLong("entidade"))));
        if (Boolean.TRUE.equals(existeJobNaoFinalizadoComMesmoFiltro)) {
            throw new EloValidationException("J\u00e1 existe um job com estes par\u00e2metros.");
        }
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        jobParametersBuilder.addDate("dataInicial", DateUtils.localDateToDate((LocalDate)dataInicial));
        jobParametersBuilder.addDate("dataFinal", DateUtils.localDateToDate((LocalDate)dataFinal));
        jobParametersBuilder.addLong("entidade", entidade);
        jobParametersBuilder.addDate("dataReferencia", new Date());
        return this.jobLauncher.run(this.estornoDeducaoCreditoBatchJob, jobParametersBuilder.toJobParameters());
    }

    @Generated
    public EstornoDeducaoCreditoJobStarter(ObjectMapper objectMapper, JobLauncher jobLauncher, JobExplorer jobExplorer, Job estornoDeducaoCreditoBatchJob) {
        this.objectMapper = objectMapper;
        this.jobLauncher = jobLauncher;
        this.jobExplorer = jobExplorer;
        this.estornoDeducaoCreditoBatchJob = estornoDeducaoCreditoBatchJob;
    }
}

