/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.batch;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.EnvioLotePeticao;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.domain.documento.peticao.LotePeticao;
import br.com.elotech.tributos.repository.documento.EnvioLotePeticaoRepository;
import br.com.elotech.tributos.service.documento.peticao.LotePeticaoService;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class EnvioLotePeticaoProcuradoriaStarter {
    private final JobExplorer jobExplorer;
    private final JobLauncher jobLauncher;
    private final Job envioPeticaoProcuradoriaBatchJob;
    private final LotePeticaoService lotePeticaoService;
    private final EnvioLotePeticaoRepository envioPeticaoRepository;

    public EnvioLotePeticaoProcuradoriaStarter(JobExplorer jobExplorer, JobLauncher jobLauncher, @Qualifier(value="envioPeticaoProcuradoriaBatchJob") Job envioPeticaoProcuradoriaBatchJob, LotePeticaoService lotePeticaoService, EnvioLotePeticaoRepository envioPeticaoRepository) {
        this.jobExplorer = jobExplorer;
        this.jobLauncher = jobLauncher;
        this.envioPeticaoProcuradoriaBatchJob = envioPeticaoProcuradoriaBatchJob;
        this.lotePeticaoService = lotePeticaoService;
        this.envioPeticaoRepository = envioPeticaoRepository;
    }

    public JobExecution startJob(Long idLote) throws JobParametersInvalidException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException, JsonProcessingException {
        boolean existeJobComMesmosParametros = this.jobExplorer.findRunningJobExecutions(JobType.ENVIA_LOTE_PETICAO_PROCURADORIA.getTipo()).stream().anyMatch(jobExecution -> {
            Long parametroIdPeticao = jobExecution.getJobParameters().getLong("idLote");
            return parametroIdPeticao.equals(idLote);
        });
        if (existeJobComMesmosParametros) {
            throw new EloValidationException(String.format("O Lote Peti\u00e7\u00e3o de id: %d j\u00e1 se encontra em processamento.", idLote));
        }
        Optional lotePeticaoOptional = this.lotePeticaoService.findById((Serializable)idLote);
        if (!lotePeticaoOptional.isPresent()) {
            throw new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar nenhum Lote com id: %d.", idLote));
        }
        LotePeticao lotePeticao = (LotePeticao)lotePeticaoOptional.get();
        EnvioLotePeticao envioLotePeticao = ((LotePeticao)lotePeticaoOptional.get()).getEnvioLotePeticao();
        if (Objects.isNull(envioLotePeticao)) {
            envioLotePeticao = new EnvioLotePeticao();
            envioLotePeticao.setLotePeticao(lotePeticao);
        }
        EnvioLotePeticao envioLotePeticaoSalvo = (EnvioLotePeticao)this.envioPeticaoRepository.saveAndFlush((Object)envioLotePeticao);
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        jobParametersBuilder.addLong("idLote", idLote);
        jobParametersBuilder.addLong("idEnvioLotePeticao", envioLotePeticaoSalvo.getId());
        return this.jobLauncher.run(this.envioPeticaoProcuradoriaBatchJob, jobParametersBuilder.toJobParameters());
    }
}

