/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.batch;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.ConsultaDebito;
import br.com.elotech.tributos.domain.ConsultaDebitoTipoAgrupamento;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.dto.FiltroConsultaDebitoDTO;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.ConsultaDebitoBatchService;
import br.com.elotech.tributos.service.ContextService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDate;
import java.util.Date;
import java.util.Objects;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ConsultaDebitoJobStarter {
    private final JobLauncher jobLauncher;
    private final JobExplorer jobExplorer;
    private final ObjectMapper objectMapper;
    private final ContextService contextService;
    private final Job consultaDebitoBatchJob;
    private final ConsultaDebitoBatchService consultaDebitoBatchService;

    public ConsultaDebitoJobStarter(JobLauncher jobLauncher, JobExplorer jobExplorer, @Qualifier(value="consultaDebitoBatchJob") Job consultaDebitoBatchJob, ObjectMapper objectMapper, ContextService contextService, ConsultaDebitoBatchService consultaDebitoBatchService) {
        this.jobLauncher = jobLauncher;
        this.jobExplorer = jobExplorer;
        this.consultaDebitoBatchJob = consultaDebitoBatchJob;
        this.objectMapper = objectMapper;
        this.contextService = contextService;
        this.consultaDebitoBatchService = consultaDebitoBatchService;
    }

    public JobExecution startJob(FiltroConsultaDebitoDTO filtro) throws JobParametersInvalidException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException, JsonProcessingException {
        String filtroString = this.objectMapper.writeValueAsString((Object)filtro);
        Boolean existsJob = this.jobExplorer.findRunningJobExecutions(JobType.CONSULTA_DEBITO.getTipo()).stream().anyMatch(job -> filtroString.equals(job.getJobParameters().getString("filtro")));
        if (Boolean.TRUE.equals(existsJob)) {
            throw new EloValidationException("J\u00e1 existe uma job com este par\u00e2metro informado.");
        }
        if (ConsultaDebitoTipoAgrupamento.SALDO_ANALITICO_CONTRIBUINTE_PRIMEIRA_CARGA.equals((Object)filtro.getTipoAgrupamento())) {
            filtro.setDataReferencia(filtro.getDataReferencia());
            filtro.setCalcularAcrescimos(Boolean.TRUE);
            filtro.setSomenteParcelasEmAberto(Boolean.TRUE);
        }
        ConsultaDebito consultaDebito = new ConsultaDebito();
        consultaDebito.setDataCriacao(LocalDate.now());
        consultaDebito.setDataReferencia(filtro.getDataReferencia());
        consultaDebito.setTipoAgrupamento(filtro.getTipoAgrupamento());
        consultaDebito.setUsuario(Objects.requireNonNull(SecurityUtils.getUserAise()));
        ConsultaDebito consultaDebitoCreated = this.consultaDebitoBatchService.create(consultaDebito);
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        jobParametersBuilder.addLong("idConsulta", consultaDebitoCreated.getId());
        jobParametersBuilder.addString("filtro", filtroString);
        jobParametersBuilder.addLong("entidade", this.contextService.getEntidadePrincipal());
        jobParametersBuilder.addDate("data", new Date());
        return this.jobLauncher.run(this.consultaDebitoBatchJob, jobParametersBuilder.toJobParameters());
    }
}

