/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.batch;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.calculo.dto.AlteracaoVencimentoParcelaDTO;
import br.com.elotech.tributos.domain.JobType;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import java.util.List;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class CalculoAlteracaoVencimentoParcelaJobStarter {
    private final JobExplorer jobExplorer;
    private final JobLauncher jobLauncher;
    private final Job calculoAlteracaoVencimentoParcelaBatchJob;
    private final ObjectMapper objectMapper;

    public CalculoAlteracaoVencimentoParcelaJobStarter(JobExplorer jobExplorer, JobLauncher jobLauncher, @Qualifier(value="calculoAlteracaoVencimentoParcelaBatchJob") Job calculoAlteracaoVencimentoParcelaBatchJob, ObjectMapper objectMapper) {
        this.jobExplorer = jobExplorer;
        this.jobLauncher = jobLauncher;
        this.calculoAlteracaoVencimentoParcelaBatchJob = calculoAlteracaoVencimentoParcelaBatchJob;
        this.objectMapper = objectMapper;
    }

    public JobExecution startJob(Long idCalculo, List<AlteracaoVencimentoParcelaDTO> parcelas) throws JobParametersInvalidException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException, JsonProcessingException {
        boolean existeJobComMesmosParametros = this.jobExplorer.findRunningJobExecutions(JobType.CALCULO_ALTERACAO_VENCIMENTO_PARCELA.getTipo()).stream().anyMatch(jobExecution -> {
            Long parametroIdCalculo = jobExecution.getJobParameters().getLong("idCalculo");
            return parametroIdCalculo.equals(idCalculo);
        });
        if (existeJobComMesmosParametros) {
            throw new EloValidationException(String.format("A altera\u00e7\u00e3o de vencimento das parcelas do c\u00e1lculo %d j\u00e1 se encontra em processamento.", idCalculo));
        }
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        jobParametersBuilder.addLong("idCalculo", idCalculo);
        jobParametersBuilder.addString("parcelasJson", this.objectMapper.writeValueAsString(parcelas));
        jobParametersBuilder.addDate("data", new Date());
        return this.jobLauncher.run(this.calculoAlteracaoVencimentoParcelaBatchJob, jobParametersBuilder.toJobParameters());
    }
}

