/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.acrescimo.calculo;

import br.com.elotech.tributos.domain.BaseCorrecaoMonetaria;
import br.com.elotech.tributos.domain.BaseJurosCorrecao;
import br.com.elotech.tributos.domain.BaseMultaCorrecao;
import br.com.elotech.tributos.domain.DividaFormaPagamentoTributo;
import br.com.elotech.tributos.domain.Feriado;
import br.com.elotech.tributos.domain.FormaCorrecao;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.MudancaMonetaria;
import br.com.elotech.tributos.domain.TipoFormaPagamento;
import br.com.elotech.tributos.domain.TipoSituacaoParcela;
import br.com.elotech.tributos.domain.Tributo;
import br.com.elotech.tributos.domain.acrescimo.FormaCalculo;
import br.com.elotech.tributos.domain.acrescimo.IndiceComposto;
import br.com.elotech.tributos.domain.acrescimo.TipoCorrecao;
import br.com.elotech.tributos.domain.acrescimo.ValorIndice;
import br.com.elotech.tributos.dto.ListasNecessariasCalculaAcrescimoDTO;
import br.com.elotech.tributos.dto.acrescimo.AcrescimoDTO;
import br.com.elotech.tributos.dto.acrescimo.CalculaAcrescimoBaseDTO;
import br.com.elotech.tributos.dto.acrescimo.DividaFormaPagamentoDTO;
import br.com.elotech.tributos.dto.acrescimo.EntidadeCorrecaoDTO;
import br.com.elotech.tributos.dto.acrescimo.ParametroCalculoAcrescimoDTO;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DiaUtilService;
import br.com.elotech.tributos.service.FeriadoService;
import br.com.elotech.tributos.service.FormaCorrecaoService;
import br.com.elotech.tributos.service.FormaPagamentoService;
import br.com.elotech.tributos.service.MudancaMonetariaService;
import br.com.elotech.tributos.service.TributoService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoParamatroService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import br.com.elotech.tributos.service.acrescimo.calculo.correcao.CalculoCorrecaoUtils;
import br.com.elotech.tributos.service.acrescimo.calculo.multa.CalculoMultaComum;
import br.com.elotech.tributos.service.acrescimo.calculo.multa.CalculoMultaEspecialService;
import br.com.elotech.tributos.util.CalculoUtils;
import br.com.elotech.tributos.util.CalculoValoresConstants;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.server.ResponseStatusException;

@Service
public class CalculoAcrescimoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CalculoAcrescimoService.class);
    private static final Boolean NAO_ARREDONDA = Boolean.FALSE;
    private static final BigDecimal DIVISOR_100 = BigDecimal.valueOf(100L);
    private static final Set<TipoFormaPagamento> COTA_UNICA = EnumSet.of(TipoFormaPagamento.COTA_UNICA, TipoFormaPagamento.TRES_PARCELAS);
    private final List<FormaCalculo> formasCalculos = Arrays.asList(FormaCalculo.VALOR_ATUAL, FormaCalculo.ACUMULADO);
    private final CalculoAcrescimoParamatroService calculoAcrescimoParamatroService;
    private final CalculoMultaEspecialService calculoMultaEspecialService;
    private final DiaUtilService diaUtilService;
    private final MudancaMonetariaService mudancaMonetariaService;
    private final FormaPagamentoService formaPagamentoService;
    private final FormaCorrecaoService formaCorrecaoService;
    private final TributoService tributoService;
    private final ContextService contextService;
    private final FeriadoService feriadoService;

    private BigDecimal getValorFinal(BigDecimal valor, Boolean arredondaPorPartesNoCalculo) {
        return arredondaPorPartesNoCalculo != false ? valor.setScale((int)CalculoValoresConstants.QUANTIDADE_CASAS_DECIMAIS, 4) : valor;
    }

    private BigDecimal calculaBaseCompostaCorrecao(AcrescimoDTO dados, BigDecimal valorParaCalculo, Boolean calculaBaseComposta, ParametroCalculoAcrescimoDTO parametros, List<Feriado> feriados) {
        if (parametros.getEntidadeCorrecao().getBaseCorrecaoMonetaria().equals((Object)BaseCorrecaoMonetaria.PRINCIPAL_MULTA) || parametros.getEntidadeCorrecao().getBaseCorrecaoMonetaria().equals((Object)BaseCorrecaoMonetaria.PRINCIPAL_JUROS_MULTA)) {
            valorParaCalculo = valorParaCalculo.add(this.calcularMulta(dados, Boolean.valueOf(calculaBaseComposta == false), parametros, feriados));
        }
        if (parametros.getEntidadeCorrecao().getBaseCorrecaoMonetaria().equals((Object)BaseCorrecaoMonetaria.PRINCIPAL_JUROS) || parametros.getEntidadeCorrecao().getBaseCorrecaoMonetaria().equals((Object)BaseCorrecaoMonetaria.PRINCIPAL_JUROS_MULTA)) {
            valorParaCalculo = valorParaCalculo.add(this.calcularJuros(dados, Boolean.valueOf(calculaBaseComposta == false), parametros, feriados));
        }
        return valorParaCalculo;
    }

    private LocalDate atualizaDataBaseCalculo(IndiceComposto lastIndiceComposto, IndiceComposto indiceComposto, LocalDate dataBaseCalculo) {
        if (Objects.isNull(lastIndiceComposto) || indiceComposto.equals((Object)lastIndiceComposto) && !indiceComposto.getSobreporPeriodo().booleanValue()) {
            switch (1.$SwitchMap$br$com$elotech$tributos$domain$acrescimo$PeriodoCorrecao[indiceComposto.getIndiceCorrecao().getPeriodoCorrecao().ordinal()]) {
                case 1: {
                    return dataBaseCalculo.plusDays(1L);
                }
                case 2: {
                    return dataBaseCalculo.plusMonths(1L);
                }
                case 3: {
                    return dataBaseCalculo.plusYears(1L);
                }
            }
        }
        return dataBaseCalculo;
    }

    private BigDecimal calcularCorrecao(AcrescimoDTO dados, Boolean calculaBaseComposta, ParametroCalculoAcrescimoDTO parametros, List<Feriado> feriados) {
        if (!parametros.getEntidadeCorrecao().getEntidadeCorrecaoIndiceCorrecao().incideNaSituacao(dados.getSituacaoLegal()).booleanValue() || Objects.nonNull(dados.getTributo()) && !parametros.getTributo().getIncideCorrecao().booleanValue()) {
            return this.getValorFinal(dados.getValorCorrecao(), NAO_ARREDONDA);
        }
        BigDecimal valorParaCalculo = dados.getValorOriginal();
        if (calculaBaseComposta.booleanValue()) {
            valorParaCalculo = this.calculaBaseCompostaCorrecao(dados, valorParaCalculo, calculaBaseComposta, parametros, feriados);
            dados.setValor(valorParaCalculo);
        }
        BigDecimal valorRetorno = calculaBaseComposta != false ? dados.getValorCorrecao() : BigDecimal.ZERO;
        LocalDate dataBaseCalculo = this.getDataCorrecao(dados, parametros);
        LocalDate dataPagamento = CalculoCorrecaoUtils.novaDataPagamento((FormaCorrecao)parametros.getFormaCorrecao(), (LocalDate)dataBaseCalculo, (LocalDate)dados.getDataReferencia());
        IndiceComposto lastIndiceComposto = null;
        while (dataBaseCalculo.isBefore(dataPagamento)) {
            IndiceComposto indiceComposto = CalculoCorrecaoUtils.getIndiceCompostoByData((FormaCorrecao)parametros.getFormaCorrecao(), (LocalDate)dataBaseCalculo);
            FormaCalculo formaCalculo = indiceComposto.getIndiceCorrecao().getFormaCalculo();
            ValorIndice valorIndiceCorrecao = CalculoCorrecaoUtils.getValorIndice((FormaCorrecao)parametros.getFormaCorrecao(), lastIndiceComposto, (IndiceComposto)indiceComposto, (LocalDate)dataBaseCalculo);
            lastIndiceComposto = indiceComposto;
            valorRetorno = valorRetorno.add(formaCalculo.getCalculoCorrecao().calculoValorCorrecao(valorParaCalculo.add(!this.formasCalculos.contains(formaCalculo) ? valorRetorno : BigDecimal.ZERO), dataBaseCalculo, dataPagamento, indiceComposto, valorIndiceCorrecao, parametros.getCorrecoesMonetarias()));
            dataBaseCalculo = this.atualizaDataBaseCalculo(lastIndiceComposto, indiceComposto, dataBaseCalculo);
            if (!FormaCalculo.VARIACAO.equals((Object)formaCalculo) && !FormaCalculo.VALOR_ATUAL.equals((Object)formaCalculo)) continue;
            dataBaseCalculo = indiceComposto.getDataFinal().plusDays(1L);
        }
        if (calculaBaseComposta.booleanValue() && parametros.getFormaCorrecao().getAgregaAoValorDoPrincipal().booleanValue()) {
            dados.setValor(dados.getValor().add(this.getValorFinal(valorRetorno, parametros.getEntidadeCorrecao().getArredondaPorPartesNoCalculo())));
            return BigDecimal.ZERO;
        }
        return this.getValorFinal(valorRetorno, parametros.getEntidadeCorrecao().getArredondaPorPartesNoCalculo());
    }

    private LocalDate getDataCorrecao(AcrescimoDTO dados, ParametroCalculoAcrescimoDTO parametros) {
        if (TipoCorrecao.DATA_LANCAMENTO.equals((Object)parametros.getFormaCorrecao().getTipoCorrecao())) {
            return dados.getDataLancamento();
        }
        return dados.getDataVencimento();
    }

    private BigDecimal calculaBaseCompostaJuros(AcrescimoDTO dados, BigDecimal valorParaCalculo, Boolean calculaBaseComposta, ParametroCalculoAcrescimoDTO parametros, List<Feriado> feriados) {
        if (parametros.getEntidadeCorrecao().getBaseJuros().equals((Object)BaseJurosCorrecao.PRINCIPAL_CORRECAO) || parametros.getEntidadeCorrecao().getBaseJuros().equals((Object)BaseJurosCorrecao.PRINCIPAL_CORRECAO_MULTA)) {
            valorParaCalculo = valorParaCalculo.add(this.calcularCorrecao(dados, Boolean.valueOf(calculaBaseComposta == false), parametros, feriados));
        }
        if (parametros.getEntidadeCorrecao().getBaseJuros().equals((Object)BaseJurosCorrecao.PRINCIPAL_MULTA) || parametros.getEntidadeCorrecao().getBaseJuros().equals((Object)BaseJurosCorrecao.PRINCIPAL_CORRECAO_MULTA)) {
            valorParaCalculo = valorParaCalculo.add(this.calcularMulta(dados, Boolean.valueOf(calculaBaseComposta == false), parametros, feriados));
        }
        return valorParaCalculo;
    }

    private BigDecimal calcularJuros(AcrescimoDTO dados, Boolean calculaBaseComposta, ParametroCalculoAcrescimoDTO parametros, List<Feriado> feriados) {
        Assert.notNull((Object)parametros.getEntidadeCorrecao().getMesJuros(), (String)String.format("Entidade corre\u00e7\u00e3o sem m\u00eas juros configurado %s", parametros.getEntidadeCorrecao()));
        Assert.notNull((Object)parametros.getEntidadeCorrecao().getJuroMora(), (String)String.format("Entidade corre\u00e7\u00e3o sem juros mora configurado %s", parametros.getEntidadeCorrecao()));
        if (!dados.getDataReferencia().isAfter(dados.getDataVencimento())) {
            return this.getValorFinal(dados.getValorJuros(), NAO_ARREDONDA);
        }
        if (!parametros.getEntidadeCorrecao().getEntidadeCorrecaoIndiceJuros().incideNaSituacao(dados.getSituacaoLegal()).booleanValue() || Objects.nonNull(dados.getTributo()) && !parametros.getTributo().getIncideJuros().booleanValue()) {
            return this.getValorFinal(dados.getValorJuros(), NAO_ARREDONDA);
        }
        BigDecimal valorParaCalculo = dados.getValorOriginal();
        if (calculaBaseComposta.booleanValue()) {
            valorParaCalculo = this.calculaBaseCompostaJuros(dados, valorParaCalculo, calculaBaseComposta, parametros, feriados);
        }
        BigDecimal aliquotaVariavel = new BigDecimal(parametros.getEntidadeCorrecao().getMesJuros().getCalculoJuros().calculaAliquota(dados.getDataVencimento(), dados.getDataReferencia()));
        BigDecimal valorRetorno = valorParaCalculo.multiply(parametros.getEntidadeCorrecao().getJuroMora()).multiply(aliquotaVariavel).divide(DIVISOR_100);
        return this.getValorFinal(valorRetorno, parametros.getEntidadeCorrecao().getArredondaPorPartesNoCalculo());
    }

    private BigDecimal calculaBaseCompostaMulta(AcrescimoDTO dados, BigDecimal valorParaCalculo, Boolean calculaBaseComposta, ParametroCalculoAcrescimoDTO parametros, List<Feriado> feriados) {
        if (parametros.getEntidadeCorrecao().getBaseMulta().equals((Object)BaseMultaCorrecao.PRINCIPAL_CORRECAO) || parametros.getEntidadeCorrecao().getBaseMulta().equals((Object)BaseMultaCorrecao.PRINCIPAL_CORRECAO_JUROS)) {
            valorParaCalculo = valorParaCalculo.add(this.calcularCorrecao(dados, Boolean.valueOf(calculaBaseComposta == false), parametros, feriados));
        }
        if (parametros.getEntidadeCorrecao().getBaseMulta().equals((Object)BaseMultaCorrecao.PRINCIPAL_JUROS) || parametros.getEntidadeCorrecao().getBaseMulta().equals((Object)BaseMultaCorrecao.PRINCIPAL_CORRECAO_JUROS)) {
            valorParaCalculo = valorParaCalculo.add(this.calcularJuros(dados, Boolean.valueOf(calculaBaseComposta == false), parametros, feriados));
        }
        return valorParaCalculo;
    }

    private BigDecimal calcularMulta(AcrescimoDTO dados, Boolean calculaBaseComposta, ParametroCalculoAcrescimoDTO parametros, List<Feriado> feriados) {
        BigDecimal percentualMultaComum;
        Long diasAtraso;
        if (!parametros.getEntidadeCorrecao().getEntidadeCorrecaoIndiceMulta().incideNaSituacao(dados.getSituacaoLegal()).booleanValue() || Objects.nonNull(dados.getTributo()) && !parametros.getTributo().getIncideMulta().booleanValue()) {
            return this.getValorFinal(dados.getValorMulta(), NAO_ARREDONDA);
        }
        BigDecimal valorParaCalculo = dados.getValorOriginal();
        if (calculaBaseComposta.booleanValue()) {
            valorParaCalculo = this.calculaBaseCompostaMulta(dados, valorParaCalculo, calculaBaseComposta, parametros, feriados);
        }
        if ((diasAtraso = this.diaUtilService.countDiasAtraso(dados.getDataVencimento(), dados.getDataReferencia(), parametros.getEntidadeCorrecao().getMultaDias(), feriados)) <= 0L) {
            return this.getValorFinal(dados.getValorMulta(), NAO_ARREDONDA);
        }
        BigDecimal percentualMulta = percentualMultaComum = CalculoMultaComum.calculaValorMulta((List)parametros.getEntidadeCorrecao().getCorrecaoMulta(), (Long)diasAtraso, (Boolean)dados.getSituacaoLegal().isDividaAtivaOrJuizo(), (Boolean)dados.getParcelado());
        if (!parametros.getEntidadeCorrecao().getSobreporMulta().booleanValue()) {
            BigDecimal percentualMultaEspecial = this.calculoMultaEspecialService.calculaValorMultaEspecial(parametros.getEntidadeCorrecao().getCorrecaoMultaEspecial(), dados.getDataVencimento(), dados.getDataReferencia(), parametros.getEntidadeCorrecao().getMultaDias(), feriados);
            percentualMulta = percentualMultaComum.add(percentualMultaEspecial);
        }
        BigDecimal valorRetorno = valorParaCalculo.multiply(percentualMulta).divide(DIVISOR_100);
        return this.getValorFinal(valorRetorno, parametros.getEntidadeCorrecao().getArredondaPorPartesNoCalculo());
    }

    public EntidadeCorrecaoDTO getEntidadeCorrecao(Long entidade, Long exercicio, Optional<Long> divida) {
        if (Objects.isNull(entidade) || Objects.isNull(exercicio)) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "N\u00e3o foi poss\u00edvel realizar o c\u00e1lculo pois n\u00e3o foram informados os dados da entidade e do exerc\u00edcio.");
        }
        return this.calculoAcrescimoParamatroService.getEntidadeCorrecao(entidade, exercicio, divida);
    }

    public List<EntidadeCorrecaoDTO> getAllEntidadesCorrecoes(Long entidade) {
        return this.calculoAcrescimoParamatroService.getAllEntidadesCorrecoes(entidade);
    }

    private Boolean podeCalcularAcrescimos(AcrescimoDTO dados, ParametroCalculoAcrescimoDTO parametros) {
        return (parametros.getFormaCorrecao().getTipoCorrecao().equals((Object)TipoCorrecao.DATA_VENCIMENTO) && dados.getDataReferencia().isAfter(dados.getDataVencimento()) || parametros.getFormaCorrecao().getTipoCorrecao().equals((Object)TipoCorrecao.DATA_LANCAMENTO)) && !Arrays.asList(TipoFormaPagamento.COTA_UNICA, TipoFormaPagamento.TRES_PARCELAS).contains(parametros.getFormaPagamento().getTipoFormaPagamento());
    }

    private void verificaDataVencimento(AcrescimoDTO dados, List<Feriado> feriados) {
        LocalDate proximoDiaUtil;
        if (!this.diaUtilService.diaUtil(dados.getDataVencimento(), feriados).booleanValue() && Objects.nonNull(proximoDiaUtil = this.diaUtilService.diaUtilProximo(dados.getDataVencimento(), feriados)) && !dados.getDataVencimento().isAfter(dados.getDataReferencia()) && !dados.getDataReferencia().isAfter(proximoDiaUtil)) {
            dados.setDataVencimentoOriginal(dados.getDataVencimento());
            dados.setDataVencimento(proximoDiaUtil);
        }
    }

    private DividaFormaPagamentoTributo getDividaFormaPagamentoTributo(AcrescimoDTO dados, ParametroCalculoAcrescimoDTO parametros) {
        if (Objects.nonNull(parametros.getDividaFormaPagamento())) {
            return parametros.getDividaFormaPagamento().getFormasPagamentoTributo().stream().filter(tributo -> tributo.getId().getTributo().compareToIgnoreCase(dados.getTributo()) == 0).findFirst().orElse(null);
        }
        return null;
    }

    private Boolean possuiDesconto(AcrescimoDTO dados, ParametroCalculoAcrescimoDTO parametros, LocalDate proximoDiaUtil) {
        return Objects.nonNull(parametros.getDividaFormaPagamento()) && (parametros.getDividaFormaPagamento().getVencimento().compareTo(dados.getDataReferencia()) >= 0 && COTA_UNICA.contains(parametros.getFormaPagamento().getTipoFormaPagamento()) || !COTA_UNICA.contains(parametros.getFormaPagamento().getTipoFormaPagamento()) && proximoDiaUtil.compareTo(dados.getDataReferencia()) >= 0);
    }

    private void calculaValorDesconto(AcrescimoDTO dados, ParametroCalculoAcrescimoDTO parametros, List<Feriado> feriados) {
        DividaFormaPagamentoTributo dividaFormaPagamentoTributo;
        LocalDate proximoDiaUtil;
        LocalDate localDate = proximoDiaUtil = this.diaUtilService.diaUtil(dados.getDataVencimento(), feriados) != false ? dados.getDataVencimento() : this.diaUtilService.diaUtilProximo(dados.getDataVencimento(), feriados);
        if (dados.getDescontoParcelamento().compareTo(BigDecimal.ZERO) > 0 && (dados.getDataReferencia().isBefore(proximoDiaUtil) || COTA_UNICA.contains(parametros.getFormaPagamento().getTipoFormaPagamento()))) {
            dados.setValorDescontoPrincipal(CalculoUtils.arredonda((BigDecimal)dados.getValor().multiply(dados.getDescontoParcelamento()).divide(DIVISOR_100)));
        }
        if (Objects.nonNull(dividaFormaPagamentoTributo = this.getDividaFormaPagamentoTributo(dados, parametros)) && dividaFormaPagamentoTributo.possuiDesconto().booleanValue() && parametros.getFormaPagamento().getId().compareTo(0L) > 0) {
            if (this.possuiDesconto(dados, parametros, proximoDiaUtil).booleanValue()) {
                dados.setValorDescontoPrincipal(dados.getValorDescontoPrincipal().add(CalculoUtils.arredonda((BigDecimal)dados.getValor().multiply(dividaFormaPagamentoTributo.getDesconto()).divide(DIVISOR_100))));
            }
            if (dividaFormaPagamentoTributo.getDescontoJuros().compareTo(BigDecimal.ZERO) > 0) {
                dados.setValorDescontoJuros(dados.getValorDescontoJuros().add(CalculoUtils.arredonda((BigDecimal)dados.getValorJuros().multiply(dividaFormaPagamentoTributo.getDescontoJuros()).divide(DIVISOR_100))));
            }
            if (dividaFormaPagamentoTributo.getDescontoMulta().compareTo(BigDecimal.ZERO) > 0) {
                dados.setValorDescontoMulta(dados.getValorDescontoMulta().add(CalculoUtils.arredonda((BigDecimal)dados.getValorMulta().multiply(dividaFormaPagamentoTributo.getDescontoMulta()).divide(DIVISOR_100))));
            }
            if (dividaFormaPagamentoTributo.getDescontoCorrecao().compareTo(BigDecimal.ZERO) > 0) {
                dados.setValorDescontoCorrecao(dados.getValorDescontoCorrecao().add(CalculoUtils.arredonda((BigDecimal)dados.getValorCorrecao().multiply(dividaFormaPagamentoTributo.getDescontoCorrecao()).divide(DIVISOR_100))));
            }
        }
    }

    @Transactional(readOnly=true)
    public AcrescimoDTO calculaAcrescimos(AcrescimoDTO dados, List<EntidadeCorrecaoDTO> entidadeCorrecaoDTOS, List<FormaCorrecao> formaCorrecoes, List<FormaPagamento> formaPagamentos, List<MudancaMonetaria> mudancasMonetarias, List<Feriado> feriados, Map<String, Tributo> cacheTributos) {
        ParametroCalculoAcrescimoDTO parametros = this.getParamsCalculoCorrecao(dados, entidadeCorrecaoDTOS, formaCorrecoes, formaPagamentos, mudancasMonetarias);
        if (parametros.getFormaCorrecao().getConverteMoeda().booleanValue()) {
            dados.setValor(CalculoCorrecaoUtils.converteMoeda((BigDecimal)dados.getValor(), (LocalDate)dados.getDataLancamento(), (LocalDate)dados.getDataVencimento(), (FormaCorrecao)parametros.getFormaCorrecao()));
            log.trace("Converteu moeda");
        }
        if (Objects.nonNull(parametros.getCorrecoesMonetarias())) {
            parametros.getCorrecoesMonetarias().forEach(mudancaMonetaria -> {
                BigDecimal valorAnterior = dados.getValor();
                BigDecimal valorCorrigido = CalculoCorrecaoUtils.aplicaCorrecaoMonetaria((MudancaMonetaria)mudancaMonetaria, (BigDecimal)valorAnterior, (LocalDate)dados.getDataVencimento(), (LocalDate)dados.getDataReferencia());
                dados.setValor(valorCorrigido);
                log.trace("Calculou Correcao monetaria {}. Valor anterior: {}, valorCorrigido: {}", new Object[]{mudancaMonetaria.getId(), valorAnterior, valorCorrigido});
            });
        }
        dados.setValorOriginal(dados.getValor());
        dados.setDataVencimentoOriginal(dados.getDataVencimento());
        if (this.podeCalcularAcrescimos(dados, parametros).booleanValue()) {
            this.getParamsCalculoTributo(parametros, dados, cacheTributos);
            this.verificaDataVencimento(dados, feriados);
            log.trace("Verificou Data de vencimento ");
            dados.setValorCorrecao(CalculoUtils.arredonda((BigDecimal)this.calcularCorrecao(dados, Boolean.TRUE, parametros, feriados)));
            log.trace("Calculou Corre\u00e7\u00e3o");
            dados.setValorMulta(CalculoUtils.arredonda((BigDecimal)this.calcularMulta(dados, Boolean.TRUE, parametros, feriados)));
            log.trace("Calculou Multa");
            dados.setValorJuros(CalculoUtils.arredonda((BigDecimal)this.calcularJuros(dados, Boolean.TRUE, parametros, feriados)));
            log.trace("Calculou Juros");
            dados.setValor(CalculoUtils.arredonda((BigDecimal)dados.getValor()));
            log.trace("Arredondou valor");
            dados.setDataVencimento(dados.getDataVencimentoOriginal());
        }
        if (dados.getCalculaValorDesconto().booleanValue()) {
            this.getParamsCalculoDividaFormaPagamento(parametros, dados);
            this.calculaValorDesconto(dados, parametros, feriados);
            log.trace("Calculou desconto");
        }
        return dados;
    }

    @Transactional
    public List<AcrescimoDTO> calculaAcrescimos(List<AcrescimoDTO> dados) {
        List entidadesCorrecoes = this.getEntidadesCorrecoes(this.contextService.getEntidadePrincipalInfo().getId());
        List formasCorrecoes = this.getFormasCorrecoes();
        List formasPagamentos = this.getFormasPagamento();
        List mudancasMonetarias = this.getMudancasMonetarias();
        List feriados = this.getFeriados();
        HashMap cacheTributos = new HashMap();
        for (AcrescimoDTO dto : dados) {
            this.calculaAcrescimos(dto, entidadesCorrecoes, formasCorrecoes, formasPagamentos, mudancasMonetarias, feriados, cacheTributos);
        }
        return dados;
    }

    @Transactional
    public AcrescimoDTO calculaAcrescimos(AcrescimoDTO dto, Optional<ListasNecessariasCalculaAcrescimoDTO> lncaDTO) {
        ListasNecessariasCalculaAcrescimoDTO listasNecessariasCalculaAcrescimoDTO = lncaDTO.orElseGet(() -> this.createNecessariasCalculaAcrescimo());
        return this.calculaAcrescimos(dto, listasNecessariasCalculaAcrescimoDTO.getEntidadesCorrecoes(), listasNecessariasCalculaAcrescimoDTO.getFormasCorrecoes(), listasNecessariasCalculaAcrescimoDTO.getFormasPagamentos(), listasNecessariasCalculaAcrescimoDTO.getMudancasMonetarias(), listasNecessariasCalculaAcrescimoDTO.getFeriados(), new HashMap());
    }

    public <T extends CalculaAcrescimoBaseDTO> List<T> calculaAcrescimos(List<T> params, Long formaPagamento) {
        return this.calculaAcrescimos(params, formaPagamento, this.contextService.getDataAtual());
    }

    @Transactional(readOnly=true)
    public <T extends CalculaAcrescimoBaseDTO> List<T> calculaAcrescimos(List<T> params, Long formaPagamento, LocalDate dataReferencia) {
        List entidadesCorrecoes = this.getEntidadesCorrecoes(this.contextService.getEntidadePrincipalInfo().getId());
        log.trace("carregou entidade corre\u00e7\u00e3o");
        List formasCorrecoes = this.getFormasCorrecoes();
        log.trace("carregou forma corre\u00e7\u00e3o");
        List formasPagamentos = this.getFormasPagamento();
        log.trace("carregou forma pagamento");
        List mudancasMonetarias = this.getMudancasMonetarias();
        log.trace("carregou mudan\u00e7a monetaria");
        List feriados = this.getFeriados();
        log.trace("carregou feriados");
        AtomicLong i = new AtomicLong(0L);
        HashMap cacheTributos = new HashMap();
        int total = params.size();
        return params.stream().map(debito -> {
            log.trace("iniciou item numero {}/{}", (Object)i.get(), (Object)total);
            TipoSituacaoParcela tipoSituacaoParcela = TipoSituacaoParcela.fromValue((Long)debito.getTipoSituacaoParcela());
            if (!tipoSituacaoParcela.isAberto()) {
                return debito;
            }
            AcrescimoDTO valorAcrescimo = this.calculaAcrescimos(AcrescimoDTO.of((CalculaAcrescimoBaseDTO)debito, (Long)formaPagamento, (LocalDate)dataReferencia), entidadesCorrecoes, formasCorrecoes, formasPagamentos, mudancasMonetarias, feriados, cacheTributos);
            debito.setValorPrincipal(valorAcrescimo.getValor());
            debito.setValorJuros(valorAcrescimo.getValorJuros());
            debito.setValorMulta(valorAcrescimo.getValorMulta());
            debito.setValorCorrecao(valorAcrescimo.getValorCorrecao());
            debito.setValorDescontoPrincipal(valorAcrescimo.getValorDescontoPrincipal());
            debito.setValorDescontoJuros(valorAcrescimo.getValorDescontoJuros());
            debito.setValorDescontoMulta(valorAcrescimo.getValorDescontoMulta());
            debito.setValorDescontoCorrecao(valorAcrescimo.getValorDescontoCorrecao());
            log.trace("finalizou item {}/{}", (Object)i.getAndIncrement(), (Object)total);
            return debito;
        }).collect(Collectors.toList());
    }

    private ParametroCalculoAcrescimoDTO getParamsCalculoCorrecao(AcrescimoDTO dados, List<EntidadeCorrecaoDTO> entidadeCorrecaoDTOS, List<FormaCorrecao> formaCorrecoes, List<FormaPagamento> formaPagamentos, List<MudancaMonetaria> mudancasMonetarias) {
        ParametroCalculoAcrescimoDTO parametros = new ParametroCalculoAcrescimoDTO();
        parametros.setEntidadeCorrecao(this.filterEntidadeCorrecao(dados.getExercicio(), dados.getEntidade(), dados.getDivida().getDivida(), entidadeCorrecaoDTOS));
        parametros.setFormaCorrecao(formaCorrecoes.stream().filter(formaCorrecao -> formaCorrecao.getId().equals(dados.getFormaCorrecao())).findFirst().orElse(Optional.ofNullable(parametros.getEntidadeCorrecao()).map(EntidadeCorrecaoDTO::getFormaCorrecao).orElse(null)));
        log.trace("Carregou forma corre\u00e7\u00e3o.");
        parametros.setFormaPagamento((FormaPagamento)formaPagamentos.stream().filter(formaPagamento -> formaPagamento.getId().equals(dados.getFormaPagamento())).findFirst().orElse(null));
        log.trace("Carregou forma pagamento.");
        parametros.setCorrecoesMonetarias(mudancasMonetarias);
        log.trace("Carregou corre\u00e7\u00f5es monetarias.");
        return parametros;
    }

    private EntidadeCorrecaoDTO filterEntidadeCorrecao(Long exercicio, Long entidade, Long divida, List<EntidadeCorrecaoDTO> entidadeCorrecaoDTOS) {
        List entidadeCorrecaoByEntidadeExercicioDivida = entidadeCorrecaoDTOS.stream().filter(dto -> dto.getExercicio().equals(exercicio) && dto.getEntidade().equals(entidade) && dto.getEntidadeCorrecaoDivida().stream().anyMatch(d -> d.getId().getDivida().equals(divida))).collect(Collectors.toList());
        if (entidadeCorrecaoByEntidadeExercicioDivida.size() > 1) {
            throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, String.format("Existe mais de uma entidade corre\u00e7\u00e3o configurada para mesma guia. Entidade %d e Exerc\u00edcio %d e Divida %d ", entidade, exercicio, divida));
        }
        if (entidadeCorrecaoByEntidadeExercicioDivida.size() == 1) {
            log.trace("Carregou entidade corre\u00e7\u00e3o por exercicio, entidade e divida.");
            return entidadeCorrecaoByEntidadeExercicioDivida.stream().findFirst().orElse(null);
        }
        log.trace("Carregou entidade corre\u00e7\u00e3o por exercicio, entidade e principal.");
        return entidadeCorrecaoDTOS.stream().filter(dto -> dto.getExercicio().equals(exercicio) && dto.getEntidade().equals(entidade) && dto.getPrincipal() != false).findFirst().orElseThrow(() -> this.mountEntidadeCorrecaoErrorMessage(entidade, exercicio, divida));
    }

    private ResponseStatusException mountEntidadeCorrecaoErrorMessage(Long idEntidade, Long exercicio, Long divida) {
        String mensagemErro = String.format("N\u00e3o foi encontrado entidade de corre\u00e7\u00e3o principal para o exercicio %d e entidade %d. ", exercicio, idEntidade);
        if (Objects.nonNull(divida)) {
            mensagemErro = mensagemErro.concat(String.format("Tamb\u00e9m n\u00e3o foi encontrado entidade de corre\u00e7\u00e3o para a divida %d. ", divida));
        }
        return new ResponseStatusException(HttpStatus.NOT_FOUND, mensagemErro);
    }

    private void getParamsCalculoTributo(ParametroCalculoAcrescimoDTO parametros, AcrescimoDTO dados, Map<String, Tributo> cacheTributo) {
        String key = String.format("%d-%d-%s", dados.getEntidade(), dados.getExercicio(), dados.getTributo());
        Tributo tributo = cacheTributo.computeIfAbsent(key, k -> this.loadTributo(dados));
        parametros.setTributo(tributo);
        log.trace("Carregou tributo.");
    }

    private void getParamsCalculoDividaFormaPagamento(ParametroCalculoAcrescimoDTO parametros, AcrescimoDTO dados) {
        parametros.setDividaFormaPagamento(this.loadDividaFormaPagamento(dados));
        log.trace("Carregou divida forma pagamento.");
    }

    public List<EntidadeCorrecaoDTO> getEntidadesCorrecoes() {
        return this.getEntidadesCorrecoes(this.contextService.getEntidadePrincipalInfo().getId());
    }

    private List<EntidadeCorrecaoDTO> getEntidadesCorrecoes(Long idEntidade) {
        return this.getAllEntidadesCorrecoes(idEntidade);
    }

    @Transactional
    public ListasNecessariasCalculaAcrescimoDTO createNecessariasCalculaAcrescimo() {
        return new ListasNecessariasCalculaAcrescimoDTO(this.getEntidadesCorrecoes(), this.getFormasCorrecoes(), this.getFormasPagamento(), this.getMudancasMonetarias(), this.getFeriados());
    }

    public List<FormaPagamento> getFormasPagamento() {
        return this.formaPagamentoService.findAll();
    }

    private DividaFormaPagamentoDTO loadDividaFormaPagamento(AcrescimoDTO dados) {
        return this.calculoAcrescimoParamatroService.getDividaFormaPagamento(dados.getEntidade(), dados.getExercicio(), dados.getDivida().getDivida(), dados.getFormaPagamento());
    }

    public List<FormaCorrecao> getFormasCorrecoes() {
        return this.formaCorrecaoService.findByRsql(Optional.empty());
    }

    private Tributo loadTributo(AcrescimoDTO dados) {
        return this.tributoService.findByEntidadeAndExercicioAndTributo(dados.getEntidade(), dados.getExercicio(), dados.getTributo());
    }

    public List<MudancaMonetaria> getMudancasMonetarias() {
        return this.mudancaMonetariaService.findByRsql(Optional.empty());
    }

    public List<Feriado> getFeriados() {
        return this.feriadoService.findAllFeriados();
    }

    @Generated
    public CalculoAcrescimoService(CalculoAcrescimoParamatroService calculoAcrescimoParamatroService, CalculoMultaEspecialService calculoMultaEspecialService, DiaUtilService diaUtilService, MudancaMonetariaService mudancaMonetariaService, FormaPagamentoService formaPagamentoService, FormaCorrecaoService formaCorrecaoService, TributoService tributoService, ContextService contextService, FeriadoService feriadoService) {
        this.calculoAcrescimoParamatroService = calculoAcrescimoParamatroService;
        this.calculoMultaEspecialService = calculoMultaEspecialService;
        this.diaUtilService = diaUtilService;
        this.mudancaMonetariaService = mudancaMonetariaService;
        this.formaPagamentoService = formaPagamentoService;
        this.formaCorrecaoService = formaCorrecaoService;
        this.tributoService = tributoService;
        this.contextService = contextService;
        this.feriadoService = feriadoService;
    }
}

