/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.acrescimo.calculo;

import br.com.elotech.tributos.domain.EntidadeCorrecao;
import br.com.elotech.tributos.dto.acrescimo.DividaFormaPagamentoDTO;
import br.com.elotech.tributos.dto.acrescimo.EntidadeCorrecaoDTO;
import br.com.elotech.tributos.repository.DividaRepository;
import br.com.elotech.tributos.service.EntidadeCorrecaoService;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class CalculoAcrescimoParamatroService {
    private final EntidadeCorrecaoService entidadeCorrecaoService;
    private final DividaRepository dividaRepository;

    public CalculoAcrescimoParamatroService(EntidadeCorrecaoService entidadeCorrecaoService, DividaRepository dividaRepository) {
        this.entidadeCorrecaoService = entidadeCorrecaoService;
        this.dividaRepository = dividaRepository;
    }

    public EntidadeCorrecaoDTO getEntidadeCorrecao(Long entidade, Long exercicio, Optional<Long> divida) {
        EntidadeCorrecao entity = this.entidadeCorrecaoService.getEntidadeCorrecao(entidade, exercicio, divida);
        return Objects.nonNull(entity) ? EntidadeCorrecaoDTO.of((EntidadeCorrecao)entity) : null;
    }

    public List<EntidadeCorrecaoDTO> getAllEntidadesCorrecoes(Long entidade) {
        return this.entidadeCorrecaoService.getAllEntidadesCorrecao(entidade).stream().map(EntidadeCorrecaoDTO::of).collect(Collectors.toList());
    }

    public DividaFormaPagamentoDTO getDividaFormaPagamento(Long entidade, Long exercicio, Long divida, Long formaPagamento) {
        return this.dividaRepository.findByEntidadeAndExercicioAndDivida(entidade, exercicio, divida).map(item -> item.getDividaFormaPagamentoByFormaPagamentoId(formaPagamento)).map(DividaFormaPagamentoDTO::of).orElse(null);
    }
}

