/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.TipoDeducaoEnum;
import br.com.elotech.tributos.dto.CancelamentoDebitoTributoDTO;
import br.com.elotech.tributos.dto.SituacaoLegal;
import br.com.elotech.tributos.dto.cancelamento.CancelamentoTributosFormDTO;
import br.com.elotech.tributos.service.CertidaoDividaAtivaService;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.ValidaDataMovimentacaoService;
import br.com.elotech.tributos.service.exception.CancelamentoDebitoException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.stereotype.Service;

@Service
public class ValidaCancelamentoDebitoService {
    private final ParametroGeralService parametroGeralService;
    private final CertidaoDividaAtivaService certidaoDividaAtivaService;
    private final DebitoService debitoService;
    private final ValidaDataMovimentacaoService validaDataMovimentacaoService;

    public ValidaCancelamentoDebitoService(ParametroGeralService parametroGeralService, CertidaoDividaAtivaService certidaoDividaAtivaService, DebitoService debitoService, ValidaDataMovimentacaoService validaDataMovimentacaoService) {
        this.parametroGeralService = parametroGeralService;
        this.certidaoDividaAtivaService = certidaoDividaAtivaService;
        this.debitoService = debitoService;
        this.validaDataMovimentacaoService = validaDataMovimentacaoService;
    }

    public void validaCancelamento(CancelamentoTributosFormDTO cancelamentoTributosFormDTO) {
        this.validaDataMovimentacaoService.validaMesEDia(cancelamentoTributosFormDTO.getEntidade(), cancelamentoTributosFormDTO.getDataCancelamento());
        this.validateEstornoDebitoEmDividaAtiva(cancelamentoTributosFormDTO);
        this.validaDebitoParcelado(cancelamentoTributosFormDTO);
        this.validaCertidaoDividaAtivaDebito(cancelamentoTributosFormDTO);
    }

    private void validateEstornoDebitoEmDividaAtiva(CancelamentoTributosFormDTO cancelamentoTributosFormDTO) {
        if (cancelamentoTributosFormDTO.getMotivoCancelamento().getTipoDeducao().getId().equals(TipoDeducaoEnum.ESTORNO.getValue()) && (cancelamentoTributosFormDTO.getSituacaoLegal().equals(SituacaoLegal.DIVIDA_ATIVA.getCodigo()) || cancelamentoTributosFormDTO.getSituacaoLegal().equals(SituacaoLegal.JUIZO.getCodigo()))) {
            throw new EloValidationException("Cancelamento n\u00e3o permitido, d\u00e9bitos em d\u00edvida ativa/ajuizados n\u00e3o podem ser estornados");
        }
    }

    private void validaDebitoParcelado(CancelamentoTributosFormDTO cancelamentoTributosFormDTO) {
        if (!this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.PERMITE_CANCELAMENTO_DEBITO_PARCELADO).booleanValue()) {
            Map debitos = CancelamentoDebitoTributoDTO.getItensCanceladosByDebitos((List)cancelamentoTributosFormDTO.getParcelas());
            debitos.forEach((debitoIdDTO, listaCancelamentoDebitoTributoDTO) -> {
                Debito debito = (Debito)this.debitoService.findOne((Serializable)debitoIdDTO.getIdDebito());
                if (Objects.isNull(debito)) {
                    throw CancelamentoDebitoException.debitoNotFound((Long)debitoIdDTO.getExercicio(), (Long)debitoIdDTO.getDivida(), (Long)debitoIdDTO.getSubDivida(), (Long)debitoIdDTO.getTipoCadastro(), (Long)debitoIdDTO.getCadastroGeral());
                }
                if (debito.getReparcelado().booleanValue()) {
                    throw CancelamentoDebitoException.debitoReparcelado((Long)debitoIdDTO.getExercicio(), (Long)debitoIdDTO.getDivida(), (Long)debitoIdDTO.getSubDivida(), (Long)debitoIdDTO.getTipoCadastro(), (Long)debitoIdDTO.getCadastroGeral());
                }
            });
        }
    }

    private void validaCertidaoDividaAtivaDebito(CancelamentoTributosFormDTO form) {
        if (this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.VALIDA_CDA_VALIDA_NO_CANCELAMENTO).booleanValue()) {
            Map debitoParcelas = form.getItensCanceladosByParcelas();
            debitoParcelas.forEach((debitoParcelaId, listaCancelamentoDebitoTributoDTO) -> {
                List certidoes = this.certidaoDividaAtivaService.findByDebitoParcela(debitoParcelaId);
                if (!certidoes.isEmpty()) {
                    throw CancelamentoDebitoException.debitoCertidaoDividaAtiva((Long)debitoParcelaId.getExercicio(), (Long)debitoParcelaId.getDivida(), (Long)debitoParcelaId.getSubDivida(), (Long)debitoParcelaId.getTipoCadastro(), (Long)debitoParcelaId.getCadastroGeral());
                }
            });
        }
    }
}

