/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.tributos.repository.ProfissionalProfissaoRepository;
import br.com.elotech.tributos.repository.ProprietarioRepository;
import br.com.elotech.tributos.repository.RepresentanteLegalRepository;
import br.com.elotech.tributos.repository.mobiliario.ContratoSocialPessoaRepository;
import br.com.elotech.tributos.repository.projections.CadastroGeralResponsavelProjection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ResponsavelCadastroService {
    @Autowired
    private ProprietarioRepository proprietarioRepository;
    @Autowired
    private ContratoSocialPessoaRepository contratoSocialPessoaRepository;
    @Autowired
    private ProfissionalProfissaoRepository profissionalProfissaoRepository;
    @Autowired
    private RepresentanteLegalRepository representanteLegalRepository;

    public Stream<CadastroGeralResponsavelProjection> findResponsavel(String cpf) {
        Comparator<CadastroGeralResponsavelProjection> comparator = Comparator.comparing(CadastroGeralResponsavelProjection::getTipoCadastro).thenComparing(CadastroGeralResponsavelProjection::getCadastroGeral).thenComparing(CadastroGeralResponsavelProjection::getPessoa).thenComparing(CadastroGeralResponsavelProjection::getIdCadastroGeralIss);
        TreeSet<CadastroGeralResponsavelProjection> projectionSet = new TreeSet<CadastroGeralResponsavelProjection>(comparator);
        try (Stream proprietarioStream = this.proprietarioRepository.findResponsavel(cpf);){
            proprietarioStream.forEach(projectionSet::add);
        }
        try (Stream contratoSocialStream = this.contratoSocialPessoaRepository.findResponsavel(cpf);){
            contratoSocialStream.forEach(projectionSet::add);
        }
        try (Stream profissionalProfissaoStream = this.profissionalProfissaoRepository.findResponsavel(cpf);){
            profissionalProfissaoStream.forEach(projectionSet::add);
        }
        try (Stream representanteLegalStream = this.representanteLegalRepository.findResponsavel(cpf);){
            representanteLegalStream.forEach(projectionSet::add);
        }
        return projectionSet.stream();
    }

    public List<CadastroGeralResponsavelProjection> findResponsavelList(String cpf) {
        return this.findResponsavel(cpf).collect(Collectors.toList());
    }
}

