/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Quadricula;
import br.com.elotech.tributos.service.CadastroImobiliarioService;
import br.com.elotech.tributos.service.ConfiguracaoInscricaoCadastralService;
import java.util.Objects;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class QuadriculaService
extends CrudService<Quadricula, String> {
    private final CadastroImobiliarioService cadastroImobiliarioService;
    private final ConfiguracaoInscricaoCadastralService configuracaoInscricaoCadastralService;

    public QuadriculaService(CadastroImobiliarioService cadastroImobiliarioService, ConfiguracaoInscricaoCadastralService configuracaoInscricaoCadastralService) {
        this.cadastroImobiliarioService = cadastroImobiliarioService;
        this.configuracaoInscricaoCadastralService = configuracaoInscricaoCadastralService;
    }

    protected void beforeDelete(Quadricula entity, Authentication authentication) {
        super.beforeDelete((EloEntity)entity, authentication);
        if (this.cadastroImobiliarioService.existsQuadriculaLocalizacao(entity.getId()).booleanValue()) {
            throw new EloValidationException(String.format("A %s possui v\u00ednculos com cadastros imobili\u00e1rios", this.configuracaoInscricaoCadastralService.getConfiguracao().getQuadricula().getDescricao()));
        }
    }

    public Quadricula saveQuadricula(Quadricula quadricula) {
        if (Objects.nonNull(this.getCrudRepository().findOne((Object)quadricula.getId()))) {
            throw new EloValidationException(String.format("%s %s j\u00e1 existe.", this.configuracaoInscricaoCadastralService.getConfiguracao().getQuadricula().getDescricao(), quadricula.getId()));
        }
        return (Quadricula)this.getCrudRepository().save((Object)quadricula);
    }
}

